# BioWorldR

The `BioWorldR` package provides a curated collection of biodiversity and species-related datasets, covering a wide range of taxa including **birds, plants, reptiles, turtles, mammals, bees, and marine organisms**. By gathering and standardizing these datasets from public repositories and ecological R packages, it enables researchers, educators, and students to easily access well-documented examples for use in **biodiversity, ecology, biogeography, and comparative biology**.


## Installation

You can install the `BioWorldR` package from CRAN with the following R function:

```R

install.packages("BioWorldR")

```


## Usage

After installation, load the package and start exploring and using its functions and datasets.

```R

library(BioWorldR)

```

## Dataset Suffixes

Each dataset in `BioWorldR` is labeled with a *suffix* to indicate its structure and type:

- `_df`: A data frame

- `_list`: A list

- `_tbl_df`: A tibble


## Datasets Included in BioWorldR

These datasets encompass a wide variety of formats and content, including **species occurrence records, trait measurements, ecological interactions, population dynamics, and conservation-related information**. By centralizing well-documented examples, `BioWorldR` simplifies **teaching, prototyping, reproducible workflows, and exploratory analyses** in the biological sciences.  


- **Reptiles_df**: This dataset contains the valid names and url addresses for all reptile species cataloged in The Reptile Database

- **Gorillas_df**: Chest-beating rates in Gorillas.

- **Brain_animals**: Brain weight versus body weight of 28 animals


## Example Code:

```R

# Load the package

library(BioWorldR)




```
