# BioWorldR - A Curated Collection of Biodiversity and Species Datasets and Utilities
# Version 0.1.0
# Copyright (C) 2025 Juan David Monroy
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.


#' Bird Species Recorded in Peru (Updated 2025 Version)
#'
#' This dataset, Birds_Peru, is a tibble containing information on bird species recorded in Peru,
#' based on the most recent taxonomic revisions by the South American Checklist Committee (SACC).
#' The dataset includes 1,914 observations and 6 variables, covering taxonomic order, family,
#' scientific names, common names in English and Spanish, and conservation or occurrence status.
#' All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Birds_Peru' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Birds_Peru
#' @format A tibble with 1,914 observations and 6 variables:
#' \describe{
#'   \item{order_name}{Taxonomic order (character string)}
#'   \item{family_name}{Taxonomic family (character string)}
#'   \item{scientific_name}{Scientific name of the species (character string)}
#'   \item{english_name}{Common name in English (character string)}
#'   \item{spanish_name}{Common name in Spanish (character string)}
#'   \item{status}{Conservation or occurrence status (character string)}
#' }
#' @source Data taken from the avesperu package version 0.0.6
#' @usage data(Birds_Peru)
#' @export
load("data/Birds_Peru.rda")
NULL


#' Plant Species Occurrence in the US and Canada
#'
#' This dataset, Plants_list, is a list containing data on plant species and the states in
#' the United States and Canada where they occur. The list includes 33,721 plant species entries,
#' each with its corresponding occurrence information. All values are preserved as in the original source,
#' with no modifications.
#'
#' The dataset name has been kept as 'Plants_list' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Plants_list
#' @format A list with 33,721 elements:
#' \describe{
#'   \item{abelia}{Species information (character string)}
#'   \item{abelia_x_grandiflora}{Species information (character string)}
#'   \item{abelmoschus}{Species information (character string)}
#'   \item{...}{Additional species entries omitted for brevity}
#' }
#' @source Data taken from the eulerr package version 7.0.2
#' @usage data(Plants_list)
#' @export
load("data/Plants_list.rda")
NULL


#' Reptile Species Names and URLs
#'
#' This dataset, Reptiles_df, is a data frame containing the valid names and URL addresses
#' for all reptile species cataloged in The Reptile Database. The dataset includes 12,440 observations
#' and 8 variables, covering taxonomic order, suborder, family, genus, species, year of description,
#' author, and the URL reference. All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Reptiles_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
#'
#' @name Reptiles_df
#' @format A data frame with 12,440 observations and 8 variables:
#' \describe{
#'   \item{order}{Taxonomic order (character string)}
#'   \item{suborder}{Taxonomic suborder (character string)}
#'   \item{family}{Taxonomic family (character string)}
#'   \item{genus}{Genus name (character string)}
#'   \item{species}{Species name (character string)}
#'   \item{year}{Year of species description (character string)}
#'   \item{author}{Author(s) of the species description (character string)}
#'   \item{url}{URL reference for the species entry (character string)}
#' }
#' @source Data taken from the letsHerp package version 0.1.0
#' @usage data(Reptiles_df)
#' @export
load("data/Reptiles_df.rda")
NULL


#' Germline Sequence Information for Various Species
#'
#' This dataset, Germ_lines_df, is a data frame containing germline sequence information
#' for multiple species. The dataset includes 7,285 observations and 8 variables,
#' covering the nucleotide sequence, gene names, species, chain type, accession number,
#' official species name, source, and strain. All values are preserved as in the original source,
#' with no modifications.
#'
#' The dataset name has been kept as 'Germ_lines_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
#'
#' @name Germ_lines_df
#' @format A data frame with 7,285 observations and 8 variables:
#' \describe{
#'   \item{sequence}{Germline nucleotide sequence (factor)}
#'   \item{names}{Gene name(s) (character string)}
#'   \item{species}{Species code or name (character string)}
#'   \item{chain}{Chain type (factor)}
#'   \item{accession}{Accession number (factor)}
#'   \item{species_name_official}{Official species name (character string)}
#'   \item{source}{Source of the germline sequence (character string)}
#'   \item{strain}{Strain or line information (character string)}
#' }
#' @source Data taken from the VDJgermlines package version 0.1
#' @usage data(Germ_lines_df)
#' @export
load("data/Germ_lines_df.rda")
NULL


#' Turtle Carapace and Clutch Size Data
#'
#' This dataset, Turtles_list, is a list containing data to examine the effect of turtle carapace
#' length on clutch size. The list includes three main elements: traits, phylo, and traits_info.
#' All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Turtles_list' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Turtles_list
#' @format A list with 3 elements:
#' \describe{
#'   \item{traits}{A tibble with 240 observations and 17 variables, including species, morphometric traits (M1–M5), body measurements (B1–B2), life-history traits (LH1–LH2), and clutch size traits (CS1–CS2)}
#'   \item{phylo}{A list of 4 elements containing phylogenetic information (phylo structure)}
#'   \item{traits_info}{A data frame with 16 observations and 2 variables: trait_id and trait_name}
#' }
#' @source Data taken from the phylosignalDB package version 0.2.2
#' @usage data(Turtles_list)
#' @export
load("data/Turtles_list.rda")
NULL


#' Turtle Temperature-Dependent Sex Determination Data
#'
#' This dataset, Tsd_turtle, is a data frame containing extensive information on temperature-dependent
#' sex determination (TSD) in reptiles. The dataset includes 2,738 observations and 48 variables,
#' covering species, location, incubation temperatures, egg and hatchling measurements, sex ratios,
#' clutch information, and references. All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Tsd_turtle' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' is not used here because the dataset is identified by its function within BioWorldR.
#' The original content has not been modified.
#'
#' @name Tsd_turtle
#' @format A data frame with 2,738 observations and 48 variables:
#' \describe{
#'   \item{Species}{Species name (factor)}
#'   \item{Country}{Country of observation (factor)}
#'   \item{Area}{Specific area or locality (character string)}
#'   \item{Longitude}{Longitude of the location (numeric)}
#'   \item{Latitude}{Latitude of the location (numeric)}
#'   \item{Subspecies}{Subspecies information (character string)}
#'   \item{RMU.2010}{RMU code (2010 version) (factor)}
#'   \item{RMU.2023}{RMU code (2023 version) (factor)}
#'   \item{Incubation.temperature.set}{Incubation temperature set experimentally (numeric)}
#'   \item{Incubation.temperature.recorded}{Recorded incubation temperature (numeric)}
#'   \item{Incubation.temperature.corrected}{Corrected incubation temperature (numeric)}
#'   \item{Duplicated.data}{Indicator for duplicated data (logical)}
#'   \item{Duplicate}{Duplicate identifier (character string)}
#'   \item{Incubation.temperature.Constant}{Constant temperature indicator (logical)}
#'   \item{Incubation.temperature.Accuracy}{Accuracy of incubation temperature (numeric)}
#'   \item{Incubation.temperature.SD}{Standard deviation of incubation temperature (numeric)}
#'   \item{Incubation.temperature.Amplitude}{Amplitude of incubation temperature (numeric)}
#'   \item{2ndThird.Incubation.temperature.Amplitude}{Amplitude during 2nd/3rd incubation period (numeric)}
#'   \item{Correction.factor}{Correction factor applied (numeric)}
#'   \item{Egg.mass.mean}{Mean egg mass (numeric)}
#'   \item{Egg.mass.sd}{Standard deviation of egg mass (numeric)}
#'   \item{IP.min}{Minimum incubation period (numeric)}
#'   \item{IP.max}{Maximum incubation period (numeric)}
#'   \item{IP.mean}{Mean incubation period (numeric)}
#'   \item{IP.SD}{Standard deviation of incubation period (numeric)}
#'   \item{IP.SE}{Standard error of incubation period (numeric)}
#'   \item{Length.hatchlings.mean}{Mean length of hatchlings (numeric)}
#'   \item{Length.hatchlings.sd}{Standard deviation of hatchling length (numeric)}
#'   \item{SCL.hatchlings.mean}{Mean straight carapace length of hatchlings (numeric)}
#'   \item{SCL.hatchlings.sd}{Standard deviation of hatchling carapace length (numeric)}
#'   \item{Mass.hatchlings.mean}{Mean hatchling mass (numeric)}
#'   \item{Mass.hatchlings.sd}{Standard deviation of hatchling mass (numeric)}
#'   \item{Total}{Total eggs recorded (numeric)}
#'   \item{Hatched}{Number of hatched eggs (numeric)}
#'   \item{NotHatched}{Number of unhatched eggs (numeric)}
#'   \item{Undeveloped}{Number of undeveloped eggs (numeric)}
#'   \item{Unidentified}{Number of unidentified eggs (numeric)}
#'   \item{Intersexes}{Number of intersex hatchlings (numeric)}
#'   \item{Males}{Number of male hatchlings (numeric)}
#'   \item{Females}{Number of female hatchlings (numeric)}
#'   \item{Sexed}{Number of sexed hatchlings (numeric)}
#'   \item{Number.clutch}{Number of clutches observed (numeric)}
#'   \item{Clutch}{Clutch identifier (factor)}
#'   \item{Box}{Box or container identifier (character string)}
#'   \item{Reference}{Reference for the data (character string)}
#'   \item{Note}{Additional notes (character string)}
#'   \item{Digital_Identifier}{Digital identifier (character string)}
#'   \item{Version}{Dataset version (Date)}
#' }
#' @source Data taken from the embryogrowth package version 10.3
#' @usage data(Tsd_turtle)
#' @export
load("data/Tsd_turtle.rda")
NULL


#' Savannah River Tree Locations and Species
#'
#' This dataset, Savannah_trees, is a data frame containing the locations and species classification
#' of trees in a plot in the Savannah River, South Carolina, USA. The dataset includes 734 observations
#' and 4 variables, covering spatial coordinates, tree vitality, and species. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Savannah_trees' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' is not used here because the dataset is identified by its function within BioWorldR.
#' The original content has not been modified.
#'
#' @name Savannah_trees
#' @format A data frame with 734 observations and 4 variables:
#' \describe{
#'   \item{x}{X-coordinate of the tree location (numeric)}
#'   \item{y}{Y-coordinate of the tree location (numeric)}
#'   \item{live}{Tree vitality indicator (integer)}
#'   \item{sp}{Species classification (factor)}
#' }
#' @source Data taken from the nnspat package version 0.1.2
#' @usage data(Savannah_trees)
#' @export
load("data/Savannah_trees.rda")
NULL


#' Great Ape Skull Landmark Data
#'
#' This dataset, Apes_list, is a list containing landmark data of great ape skulls.
#' It includes 8 landmarks in 2 dimensions for 167 individuals. The dataset consists of two elements:
#' the landmark coordinates and the group factor indicating species. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Apes_list' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Apes_list
#' @format A list with 2 elements:
#' \describe{
#'   \item{x}{Array of landmark coordinates (numeric) with dimensions 8 landmarks × 2 dimensions × 167 individuals}
#'   \item{group}{Factor indicating the species or group of each individual}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Apes_list)
#' @export
load("data/Apes_list.rda")
NULL


#' Male Orangutan Skull Landmark Data
#'
#' This dataset, Orang_m, is an array containing landmark data of male orangutan skulls.
#' It includes 8 landmarks in 2 dimensions for 30 individuals. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Orang_m' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Orang_m
#' @format An array with dimensions 8 × 2 × 30:
#' \describe{
#'   \item{[1:8, 1:2, 1:30]}{Numeric values representing 8 landmarks in 2 dimensions for 30 male orangutan skulls}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Orang_m)
#' @export
load("data/Orang_m.rda")
NULL


#' Female Orangutan Skull Landmark Data
#'
#' This dataset, Orang_f, is an array containing landmark data of female orangutan skulls.
#' It includes 8 landmarks in 2 dimensions for 24 individuals. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Orang_f' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Orang_f
#' @format An array with dimensions 8 × 2 × 24:
#' \describe{
#'   \item{[1:8, 1:2, 1:24]}{Numeric values representing 8 landmarks in 2 dimensions for 24 female orangutan skulls}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Orang_f)
#' @export
load("data/Orang_f.rda")
NULL


#' Male Chimpanzee Skull Landmark Data
#'
#' This dataset, Chimp_m, is an array containing landmark data of male chimpanzee skulls.
#' It includes 8 landmarks in 2 dimensions for 28 individuals. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Chimp_m' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Chimp_m
#' @format An array with dimensions 8 × 2 × 28:
#' \describe{
#'   \item{[1:8, 1:2, 1:28]}{Numeric values representing 8 landmarks in 2 dimensions for 28 male chimpanzee skulls}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Chimp_m)
#' @export
load("data/Chimp_m.rda")
NULL


#' Female Chimpanzee Skull Landmark Data
#'
#' This dataset, Chimp_f, is an array containing landmark data of female chimpanzee skulls.
#' It includes 8 landmarks in 2 dimensions for 26 individuals. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Chimp_f' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Chimp_f
#' @format An array with dimensions 8 × 2 × 26:
#' \describe{
#'   \item{[1:8, 1:2, 1:26]}{Numeric values representing 8 landmarks in 2 dimensions for 26 female chimpanzee skulls}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Chimp_f)
#' @export
load("data/Chimp_f.rda")
NULL


#' Male Gorilla Skull Landmark Data
#'
#' This dataset, Gorilla_m, is an array containing landmark data of male gorilla skulls.
#' It includes 8 landmarks in 2 dimensions for 29 individuals. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Gorilla_m' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Gorilla_m
#' @format An array with dimensions 8 × 2 × 29:
#' \describe{
#'   \item{[1:8, 1:2, 1:29]}{Numeric values representing 8 landmarks in 2 dimensions for 29 male gorilla skulls}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Gorilla_m)
#' @export
load("data/Gorilla_m.rda")
NULL


#' Female Gorilla Skull Landmark Data
#'
#' This dataset, Gorilla_f, is an array containing landmark data of female gorilla skulls.
#' It includes 8 landmarks in 2 dimensions for 30 individuals. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Gorilla_f' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified in any way.
#'
#' @name Gorilla_f
#' @format An array with dimensions 8 × 2 × 30:
#' \describe{
#'   \item{[1:8, 1:2, 1:30]}{Numeric values representing 8 landmarks in 2 dimensions for 30 female gorilla skulls}
#' }
#' @source Data taken from the shapes package version 1.2.7
#' @usage data(Gorilla_f)
#' @export
load("data/Gorilla_f.rda")
NULL


#' Metallogorgia melanotrichos Sampling Locations
#'
#' This dataset, Fish_metallo, is a data frame containing sampling locations for the deep-sea
#' octocoral species Metallogorgia melanotrichos. The dataset includes 38 observations
#' and 3 variables, covering longitude, latitude, and depth in meters. All values are preserved
#' as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Fish_metallo' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' is not used here because the dataset is identified by its function within BioWorldR.
#' The original content has not been modified.
#'
#' @name Fish_metallo
#' @format A data frame with 38 observations and 3 variables:
#' \describe{
#'   \item{lon}{Longitude of sampling location (numeric)}
#'   \item{lat}{Latitude of sampling location (numeric)}
#'   \item{depth}{Depth of sampling location in meters (integer)}
#' }
#' @source Data taken from the marmap package version 1.0.12
#' @usage data(Fish_metallo)
#' @export
load("data/Fish_metallo.rda")
NULL


#' Sparrow Morphological Data
#'
#' The dataset sparrow_morph was extracted from Hermon Bumpus (1898) and records
#' morphological variables in sparrows that survived or perished after a severe storm.
#' It is one of the earliest examples of a natural selection dataset in ecological studies.
#'
#' @name sparrow_morph
#' @format A data frame with 49 observations and 6 variables:
#' \describe{
#'   \item{Survivorship}{Survival status of the sparrow (factor with 2 levels: survived or perished)}
#'   \item{Total_length}{Total body length (numeric)}
#'   \item{Alar_extent}{Wing (alar) extent (numeric)}
#'   \item{L_beak_head}{Length from beak to head (numeric)}
#'   \item{L_humerus}{Length of humerus (numeric)}
#'   \item{L_keel_sternum}{Length of keel of sternum (numeric)}
#' }
#' @source Data extracted from Hermon Bumpus (1898), as reproduced in multiple ecological datasets.
#' @usage data(sparrow_morph)
#' @export
load("data/sparrow_morph.rda")
NULL


#' Morphological Data of Crabs
#'
#' This dataset, Crab_morpho, is a data frame containing morphological measurements of crabs.
#' The dataset includes 173 observations and 5 variables, covering sex, color, spine count, body width,
#' and weight. All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Crab_morpho' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified.
#'
#' @name Crab_morpho
#' @format A data frame with 173 observations and 5 variables:
#' \describe{
#'   \item{color}{Color score of the crab (integer)}
#'   \item{spine}{Number of spines (integer)}
#'   \item{weight}{Body weight (numeric)}
#'   \item{width}{Body width (numeric)}
#'   \item{satellites}{Sex of the crab (integer)}
#' }
#' @source Data taken from the condvis package version 0.5-1
#' @usage data(Crab_morpho)
#' @export
load("data/Crab_morpho.rda")
NULL


#' Bee Occurrence Records
#'
#' The `Bees_data` dataset contains occurrence records of bee species,
#' including detailed taxonomy, geographic coordinates, collection metadata,
#' and data quality flags. It is designed for biodiversity, ecology,
#' and conservation studies involving bee populations.
#'
#' @name Bees_data
#' @format A tibble with 105 observations and 124 variables:
#' \describe{
#'   \item{database_id}{Unique database identifier (character)}
#'   \item{scientificName}{Full scientific name (character)}
#'   \item{family}{Taxonomic family (character)}
#'   \item{subfamily}{Taxonomic subfamily (character)}
#'   \item{genus}{Taxonomic genus (character)}
#'   \item{subgenus}{Taxonomic subgenus (character)}
#'   \item{subspecies}{Taxonomic subspecies (character)}
#'   \item{species}{Species name (character)}
#'   \item{specificEpithet}{Specific epithet (character)}
#'   \item{infraspecificEpithet}{Infraspecific epithet (character)}
#'   \item{acceptedNameUsage}{Accepted taxonomic name (character)}
#'   \item{taxonRank}{Rank of the taxon (character)}
#'   \item{scientificNameAuthorship}{Authority for the name (character)}
#'   \item{decimalLatitude}{Geographic latitude (numeric)}
#'   \item{decimalLongitude}{Geographic longitude (numeric)}
#'   \item{stateProvince}{Administrative region (character)}
#'   \item{continent}{Continent name (character)}
#'   \item{locality}{Locality description (character)}
#'   \item{eventDate}{Date of collection event (date/character)}
#'   \item{year}{Year of collection (integer)}
#'   \item{basisOfRecord}{Type of record (e.g., specimen, observation) (character)}
#'   \item{occurrenceStatus}{Occurrence status (character)}
#'   \item{recordedBy}{Collector(s) name(s) (character)}
#'   \item{institutionCode}{Code of institution holding the record (character)}
#'   \item{datasetName}{Name of the source dataset (character)}
#'   \item{gbifID}{Global Biodiversity Information Facility record ID (character)}
#'   \item{spatiallyValid}{Spatial validity flag (logical)}
#'   \item{coordinateUncertaintyInMeters}{Uncertainty of coordinates (numeric)}
#'   \item{hasGeospatialIssues}{Flag for geospatial issues (logical)}
#'   \item{duplicateStatus}{Duplicate record flag (character)}
#'   \item{.GBIFflags}{GBIF quality control flags (character)}
#'   \item{...}{Additional metadata on taxonomy, collection, and validation flags (90+ fields)}
#' }
#'
#' @details
#' This dataset is rich in metadata and includes validation flags such as:
#' \itemize{
#'   \item Coordinate validity and uncertainty
#'   \item Taxonomic cleaning and synonym resolution
#'   \item Record duplication and licensing status
#'   \item Event and occurrence metadata
#' }
#'
#' @source Extracted from the **BeeBDC** package, version 1.3.0.
#' @usage data(Bees_data)
#' @export
load("data/Bees_data.rda")
NULL



#' Gorilla Chest-beating Rates and Physical Measurements
#'
#' This dataset, Gorillas_df, is a data frame containing measurements related to chest-beating behavior
#' in gorillas. The dataset includes 25 observations and 7 variables, covering physical measurements,
#' focal time, age, sex, and number of chest beats. All values are preserved as in the original source,
#' with no modifications.
#'
#' The dataset name has been kept as 'Gorillas_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
#'
#' @name Gorillas_df
#' @format A data frame with 25 observations and 7 variables:
#' \describe{
#'   \item{BackBreadth}{Back breadth measurement (numeric)}
#'   \item{ChestBeatRate}{Rate of chest beats (numeric)}
#'   \item{FocalTime}{Focal observation time (numeric)}
#'   \item{Male}{Sex of the individual (character)}
#'   \item{NoChestBeats}{Number of chest beats observed (integer)}
#'   \item{Age}{Age of the individual (numeric)}
#'   \item{Age20}{Indicator if age is above 20 (character)}
#' }
#' @source Data taken from the SRMData package version 1.0.2
#' @usage data(Gorillas_df)
#' @export
load("data/Gorillas_df.rda")
NULL


#' Dog Breed Life History Data
#'
#' This dataset, DogsLife_df, is a data frame containing life history information for various dog breeds.
#' The dataset includes 73 observations and 5 variables, covering breed, average weight, litter size,
#' birth weight, and lifespan. All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'DogsLife_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
#'
#' @name DogsLife_df
#' @format A data frame with 73 observations and 5 variables:
#' \describe{
#'   \item{Breed}{Name of the dog breed (character)}
#'   \item{Weight}{Average weight of the breed (numeric)}
#'   \item{LitterSize}{Average litter size (numeric)}
#'   \item{BirthWeight}{Average birth weight (numeric)}
#'   \item{Lifespan}{Average lifespan in years (numeric)}
#' }
#' @source Data taken from the SRMData package version 1.0.2
#' @usage data(DogsLife_df)
#' @export
load("data/DogsLife_df.rda")
NULL


#' Elephant Morphometric Measurements
#'
#' This dataset, Elephants_df, is a data frame containing physical measurements of elephants.
#' The dataset includes 1,470 observations and 5 variables, covering sex, age, chest circumference,
#' height, and mass. All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Elephants_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
#'
#' @name Elephants_df
#' @format A data frame with 1,470 observations and 5 variables:
#' \describe{
#'   \item{Sex}{Sex of the elephant (character)}
#'   \item{Age}{Age in years (numeric)}
#'   \item{Chest}{Chest circumference (numeric)}
#'   \item{Height}{Height (numeric)}
#'   \item{Mass}{Mass (numeric)}
#' }
#' @source Data taken from the SRMData package version 1.0.2
#' @usage data(Elephants_df)
#' @export
load("data/Elephants_df.rda")
NULL


#' Flowering Time Observations
#'
#' This dataset, flwr_time, is a data frame containing flowering observations for two plant species
#' (Willow and Skypilot), along with minimum temperature and altitude at the observation sites.
#' The dataset includes 25 observations and 4 variables. All values are preserved as in the original source,
#' with no modifications.
#'
#' The dataset name has been kept as 'flwr_time' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified.
#'
#' @name flwr_time
#' @format A data frame with 25 observations and 4 variables:
#' \describe{
#'   \item{Willow}{Flowering count or observation for Willow (integer)}
#'   \item{Skypilot}{Flowering count or observation for Skypilot (integer)}
#'   \item{MinTemp}{Minimum temperature at site (numeric)}
#'   \item{Altitude}{Altitude of observation site (numeric)}
#' }
#' @source Data taken from the SRMData package version 1.0.2
#' @usage data(flwr_time)
#' @export
load("data/flwr_time.rda")
NULL


#' Snake Morphological Measurements
#'
#' This dataset, Snakes_df, is a data frame containing morphological measurements for snakes,
#' including diet (presence of crayfish), sex, snout-vent length (SVL), and teeth count.
#' The dataset includes 200 observations and 4 variables. All values are preserved as in the original source,
#' with no modifications.
#'
#' The dataset name has been kept as 'Snakes_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified.
#'
#' @name Snakes_df
#' @format A data frame with 200 observations and 4 variables:
#' \describe{
#'   \item{Crayfish}{Presence of crayfish in diet (character)}
#'   \item{Sex}{Sex of the snake (character)}
#'   \item{SVL}{Snout-vent length (numeric)}
#'   \item{Teeth}{Number of teeth (integer)}
#' }
#' @source Data taken from the SRMData package version 1.0.2
#' @usage data(Snakes_df)
#' @export
load("data/Snakes_df.rda")
NULL


#' Plant Occurrence Records
#'
#' This dataset, Plants_occ, is a data frame containing occurrence records for 7 plant species,
#' including species name and geographic coordinates. The dataset includes 1,658 observations
#' and 3 variables. All values are preserved as in the original source, with no modifications.
#'
#' The dataset name has been kept as 'Plants_occ' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified.
#'
#' @name Plants_occ
#' @format A data frame with 1,658 observations and 3 variables:
#' \describe{
#'   \item{species}{Name of the plant species (character)}
#'   \item{x}{Longitude coordinate (numeric)}
#'   \item{y}{Latitude coordinate (numeric)}
#' }
#' @source Data taken from the florabr package version 1.3.0
#' @usage data(Plants_occ)
#' @export
load("data/Plants_occ.rda")
NULL



#' Brain and Body Weight Data for Animals
#'
#' This dataset, Brain_animals, is a tibble containing brain and body weight measurements
#' for 28 animal species, useful for allometric and comparative studies. The dataset
#' includes 28 observations and 3 variables. All values are preserved as in the original source,
#' with no modifications.
#'
#' The dataset name has been kept as 'Brain_animals' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The original content has not been modified.
#'
#' @name Brain_animals
#' @format A tibble with 28 observations and 3 variables:
#' \describe{
#'   \item{species}{Species name (character)}
#'   \item{bodyweight}{Body weight of the species (numeric)}
#'   \item{brainweight}{Brain weight of the species (numeric)}
#' }
#' @source Data taken from the BSDA package version 1.2.2
#' @usage data(Brain_animals)
#' @export
load("data/Brain_animals.rda")
NULL


#' Extinct Mammals Data
#'
#' This dataset, Extinct_mammals_tbl_df, is a data frame containing information on 85 extinct mammal species.
#' It includes common and binomial names, taxonomic order, date of extinction, former geographic range,
#' and a flag indicating the presence of a picture. The data were read from a CSV file and no modifications have been made.
#'
#' The dataset name has been kept as 'Extinct_mammals_tbl_df' to avoid confusion with other datasets
#' in the R ecosystem. This naming convention helps distinguish this dataset as part of the
#' BioWorldR package and assists users in identifying its specific characteristics.
#' The suffix 'tbl_df' indicates that the dataset is a data frame/tibble. The original content has not been modified.
#'
#' @name Extinct_mammals_tbl_df
#' @format A data frame with 85 observations and 6 variables:
#' \describe{
#'   \item{Common.name}{Common name of the species (character)}
#'   \item{Binomial.name}{Scientific (binomial) name of the species (character)}
#'   \item{Order}{Taxonomic order (character)}
#'   \item{Date.of.extinction}{Date or year of extinction (character)}
#'   \item{Former.range}{Former geographic range (character)}
#'   \item{Picture}{Logical flag indicating presence of a picture (logical)}
#' }
#' @source Data taken from Kaggle: \url{https://www.kaggle.com/datasets/battle11king/extinct-mammals}
#' @usage data(Extinct_mammals_tbl_df)
#' @export
load("data/Extinct_mammals_tbl_df.rda")
NULL






