% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_indexclass.R
\name{assign_IndexClass}
\alias{assign_IndexClass}
\title{Assign Index_Class}
\usage{
assign_IndexClass(
  data,
  criteria,
  name_indexclass = "INDEX_CLASS",
  name_indexname = "INDEX_NAME",
  name_siteid = "SITEID",
  data_shape = "WIDE"
)
}
\arguments{
\item{data}{Data frame (wide format) with metric values to be evaluated.}

\item{criteria}{Data frame of metric thresholds to check.}

\item{name_indexclass}{Name for new Index_Class column.
Default = INDEX_CLASS}

\item{name_indexname}{Name for Index Name column.
Default = INDEX_NAME}

\item{name_siteid}{Name for Site ID column.
Default = SITEID}

\item{data_shape}{Shape of data; wide or long.  Default is 'wide'}
}
\value{
Returns a data frame with new column added.
}
\description{
Assign Index_Class for based on user input fields.
If use the same name of an existing field the information will be
overwritten.

Multiple criteria are treated as "AND" so all must be met to be assigned
to a particular Index_Class.

Internally uses `tidyr` and `dplyr`

If Index_Class is included in data then it is renamed Index_Class_Orig and
returned in the output data frame.
}
\details{
Requires use of reference file with criteria.
}
\examples{
# Packages
library(readxl)

# EXAMPLE 1
# Create Example Data
df_data <- data.frame(SITEID = paste0("Site_", LETTERS[1:10]),
                      INDEX_NAME = "BCG_MariNW_Bugs500ct",
                      GRADIENT = round(stats::runif(10, 0.5, 1.5), 1),
                      ELEVATION = round(stats::runif(10, 700, 800), 1))

# Import Checks
df_criteria <- read_excel(system.file("extdata/IndexClass.xlsx",
                                      package = "BioMonTools"),
                          sheet = "Index_Class")

# Run Function
df_results <- assign_IndexClass(df_data, df_criteria, "INDEX_CLASS")

# Results
df_results

}
