% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_dist.R
\name{compute_expected_distance}
\alias{compute_expected_distance}
\title{Expected value of metrics under a Mallows rank model}
\usage{
compute_expected_distance(
  alpha,
  n_items,
  metric = c("footrule", "spearman", "cayley", "hamming", "kendall", "ulam")
)
}
\arguments{
\item{alpha}{Non-negative scalar specifying the scale (precision) parameter
in the Mallows rank model.}

\item{n_items}{Integer specifying the number of items.}

\item{metric}{Character string specifying the distance measure to use.
Available options are \code{"kendall"}, \code{"cayley"}, \code{"hamming"}, \code{"ulam"},
\code{"footrule"}, and \code{"spearman"}.}
}
\value{
A scalar providing the expected value of the \code{metric} under the
Mallows rank model with distance specified by the \code{metric} argument.
}
\description{
Compute the expectation of several metrics under the Mallows
rank model.
}
\examples{
compute_expected_distance(1, 5, metric = "kendall")
compute_expected_distance(2, 6, metric = "cayley")
compute_expected_distance(1.5, 7, metric = "hamming")
compute_expected_distance(5, 30, "ulam")
compute_expected_distance(3.5, 45, "footrule")
compute_expected_distance(4, 10, "spearman")
}
\seealso{
Other rank functions: 
\code{\link{compute_observation_frequency}()},
\code{\link{compute_rank_distance}()},
\code{\link{create_ranking}()},
\code{\link{get_mallows_loglik}()},
\code{\link{sample_mallows}()}
}
\concept{rank functions}
