% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ces.R
\name{get_ces}
\alias{get_ces}
\title{Download Current Employment Statistics (CES) Data}
\usage{
get_ces(
  transform = TRUE,
  monthly_only = TRUE,
  simplify_table = TRUE,
  suppress_warnings = TRUE,
  return_diagnostics = FALSE
)
}
\arguments{
\item{transform}{Logical. If TRUE (default), converts employment values from thousands
to actual counts by multiplying by 1000 for specific data types (codes 1, 6, 26)
and removes ", In Thousands" from data type labels.}

\item{monthly_only}{Logical. If TRUE (default), filters out annual data (period M13).}

\item{simplify_table}{Logical. If TRUE (default), removes excess columns and creates 
a date column from Year and Period in the original data.}

\item{suppress_warnings}{Logical. If TRUE (default), suppress individual download warnings and diagnostic messages
for cleaner output during batch processing. If FALSE, returns the data and prints warnings and messages to the console.}

\item{return_diagnostics}{Logical. If FALSE (default), returns only the data. If TRUE,
returns the full bls_data_collection object with diagnostics.}
}
\value{
By default, returns a data.table with CES data. If return_diagnostics = TRUE,
  returns a bls_data_collection object containing data and comprehensive diagnostics.
}
\description{
This function downloads Current Employment Statistics data from the Bureau of Labor Statistics.
The data includes national, regional, state, and substate employment statistics.
By default, all available areas, data types, and periods are included.
}
\examples{
\donttest{
# Download CES data (streamlined approach)
ces_data <- get_ces()

# Download with full diagnostics if needed
ces_result <- get_ces(return_diagnostics = TRUE)
ces_data <- get_bls_data(ces_result)

# Check for download issues
if (has_bls_issues(ces_result)) {
  print_bls_warnings(ces_result)
}
}
}
