% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATM_simulations.R
\name{simulate_topics}
\alias{simulate_topics}
\title{Simulate genetic-disease-topic structure (step 1)}
\usage{
simulate_topics(
  topic_number,
  num_snp = 100,
  pop_sz = 10000,
  disease2topic = 0,
  v2t = 20,
  snp2t = 0.04,
  snp2d = 0.15,
  liability_thre = 0.8
)
}
\arguments{
\item{topic_number}{Number of topics to simulate.}

\item{num_snp}{Total number of SNPs (default 100; must be >= 60).}

\item{pop_sz}{Number of individuals (default 10,000).}

\item{disease2topic}{Disease-to-topic effect size (default 0).}

\item{v2t}{Number of variants affecting topic 1 (0-20; default 20).}

\item{snp2t}{SNP-to-topic effect size (default 0.04; informed by UKB).}

\item{snp2d}{SNP-to-disease effect size (default 0.15).}

\item{liability_thre}{Liability threshold: proportion set to \emph{healthy}.
For example, \code{0.8} means the top 20\% of liability are set to \emph{diseased}
(default 0.8).}
}
\value{
A list of length 3:
\itemize{
\item \code{para}: Topic parameters.
\item \code{genetics_population}: Simulated genotype matrix.
\item \code{causal_disease}: One simulated binary disease caused by loading on topic 1.
}
}
\description{
First step of a two-step procedure to simulate a genetic-disease-topic
structure. In this step, all genetic effects act on topic 1.
}
\details{
Five configurations across three SNP sets:
\enumerate{
\item \strong{SNP -> disease -> topic}: SNP IDs 1-20; disease ID \code{para$D + 1}; topic ID 1.
\item \strong{SNP * topic -> disease}: SNP IDs 41-60; disease ID \code{para$D + 2}; topic ID 1.
\item \strong{SNP -> topic -> disease; SNP -> disease}: SNP IDs 21-(20 + v2t); disease ID \code{para$D + 3}; topic ID 1.
\item \strong{SNP -> topic -> disease; SNP + SNP^2 -> disease}: SNP IDs 21-(20 + v2t); disease ID \code{para$D + 4}; topic ID 1.
\item \strong{SNP -> topic + topic^2 -> disease; SNP -> disease}: SNP IDs 21-(20 + v2t); disease ID \code{para$D + 5}; topic ID 1.
}
}
\examples{
set.seed(1)
disease2topic <- 0
v2t_small <- 20

# Step 1: simulate topics (fast)
rslts <- simulate_topics(
  topic_number = 2, pop_sz = 1000,
  disease2topic = disease2topic, v2t = v2t_small
)
para_sim            <- rslts[[1]]
genetics_population <- rslts[[2]]
causal_disease      <- rslts[[3]]

# Step 2 (optional): generate diseases from topics
reslt_ds <- simulate_genetic_disease_from_topic(
  para_sim, genetics_population, causal_disease,
  disease_number = 20, itr_effect = 1,
  topic2disease = 2, v2t = 20
)
rec_data <- reslt_ds[[1]]
}
\seealso{
\code{\link[=simulate_genetic_disease_from_topic]{simulate_genetic_disease_from_topic()}}
}
