/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.ogc;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;

public class WKTParser {
    private String geogcsName;
    private String datumName;
    private String spheroidName;
    private double majorAxis;
    private double inverseMinor;
    private String primeMeridianName;
    private double primeMeridianValue;
    private String geogUnitName;
    private double geogUnitValue;
    private boolean isAProjection;
    private String projName;
    private String projectionType;
    private HashMap parameters = new HashMap();
    private String projUnitName;
    private double projUnitValue;
    private int position = 0;
    StringReader reader;

    public WKTParser(String srtext) throws ParseException {
        this.reader = new StringReader(srtext);
        if (srtext.startsWith("PROJCS")) {
            this.isAProjection = true;
            this.parseProjcs();
        } else {
            this.isAProjection = false;
            this.parseGeogcs();
        }
    }

    private char peek() throws ParseException {
        try {
            this.reader.mark(10);
            int aChar = this.reader.read();
            this.reader.reset();
            if (aChar < 0) {
                return '\u0000';
            }
            return (char)aChar;
        }
        catch (IOException e1) {
            throw new ParseException("Strange io error " + e1, this.position);
        }
    }

    private char getChar() throws ParseException {
        try {
            int val = this.reader.read();
            ++this.position;
            if (val < 0) {
                throw new ParseException("unexpected eof of srtext", this.position);
            }
            return (char)val;
        }
        catch (IOException e1) {
            throw new ParseException(e1.toString(), this.position);
        }
    }

    private void eatLiteral(String literal) throws ParseException {
        int n = literal.length();
        for (int i = 0; i < n; ++i) {
            char v = this.getChar();
            if (v == literal.charAt(i)) continue;
            throw new ParseException("bad srtext", this.position);
        }
    }

    private double eatReal() throws ParseException {
        char t;
        StringBuffer b = new StringBuffer();
        while (Character.isDigit(t = this.peek()) || t == 'e' || t == 'E' || t == '.' || t == '-' || t == '+') {
            b.append(this.getChar());
        }
        try {
            return Double.parseDouble(b.toString());
        }
        catch (NumberFormatException e1) {
            throw new ParseException("bad number" + e1, this.position);
        }
    }

    private String eatString() throws ParseException {
        char t;
        StringBuffer b = new StringBuffer();
        if (this.getChar() != '\"') {
            throw new ParseException("expected string", this.position);
        }
        while ((t = this.getChar()) != '\"') {
            b.append(t);
        }
        return b.toString();
    }

    private String eatTerm() throws ParseException {
        char val;
        StringBuffer b = new StringBuffer();
        while (Character.isJavaIdentifierPart(val = this.peek())) {
            b.append(this.getChar());
        }
        return b.toString();
    }

    private void eatComma() throws ParseException {
        if (this.getChar() != ',') {
            throw new ParseException("expected comma", this.position);
        }
    }

    private void eatOpenBrace() throws ParseException {
        if (this.getChar() != '[') {
            throw new ParseException("expected [", this.position);
        }
    }

    private void eatCloseBrace() throws ParseException {
        if (this.getChar() != ']') {
            throw new ParseException("expected ]", this.position);
        }
    }

    private void parseProjcs() throws ParseException {
        char next;
        this.eatLiteral("PROJCS[");
        this.projName = this.eatString();
        this.eatComma();
        this.parseGeogcs();
        while ((next = this.getChar()) != ']') {
            if (next != ',') {
                throw new ParseException("expected , or ]", this.position);
            }
            String term = this.eatTerm();
            if ("PARAMETER".equals(term)) {
                this.eatParameter();
                continue;
            }
            if ("UNIT".equals(term)) {
                this.eatProjcsUnit();
                continue;
            }
            if (!"PROJECTION".equals(term)) continue;
            this.eatProjectionType();
        }
    }

    private void eatParameter() throws ParseException {
        this.eatOpenBrace();
        String parameterName = this.eatString();
        this.eatComma();
        Double value = new Double(this.eatReal());
        this.eatCloseBrace();
        this.parameters.put(parameterName.toLowerCase(), value);
    }

    private void eatProjcsUnit() throws ParseException {
        this.eatOpenBrace();
        this.projUnitName = this.eatString();
        this.eatComma();
        this.projUnitValue = this.eatReal();
        this.eatCloseBrace();
    }

    private void eatProjectionType() throws ParseException {
        this.eatOpenBrace();
        this.projectionType = this.eatString();
        this.eatCloseBrace();
    }

    private void parseGeogcs() throws ParseException {
        char t;
        this.eatLiteral("GEOGCS[");
        this.geogcsName = this.eatString();
        while ((t = this.getChar()) != ']') {
            if (t != ',') {
                throw new ParseException("expected , or ]", this.position);
            }
            String term = this.eatTerm();
            if ("DATUM".equals(term)) {
                this.eatDatum();
                continue;
            }
            if ("PRIMEM".equals(term)) {
                this.eatPrimem();
                continue;
            }
            if (!"UNIT".equals(term)) continue;
            this.eatUnit();
        }
    }

    private void eatDatum() throws ParseException {
        this.eatOpenBrace();
        this.datumName = this.eatString();
        this.eatComma();
        this.eatSpheroid();
        this.eatCloseBrace();
    }

    private void eatPrimem() throws ParseException {
        this.eatOpenBrace();
        this.primeMeridianName = this.eatString();
        this.eatComma();
        this.primeMeridianValue = this.eatReal();
        this.eatCloseBrace();
    }

    private void eatSpheroid() throws ParseException {
        this.eatLiteral("SPHEROID");
        this.eatOpenBrace();
        this.spheroidName = this.eatString();
        this.eatComma();
        this.majorAxis = this.eatReal();
        this.eatComma();
        this.inverseMinor = this.eatReal();
        this.eatCloseBrace();
    }

    private void eatUnit() throws ParseException {
        this.eatOpenBrace();
        this.geogUnitName = this.eatString();
        this.eatComma();
        this.geogUnitValue = this.eatReal();
        this.eatCloseBrace();
    }

    public String getGeogcsName() {
        return this.geogcsName;
    }

    public String getDatumName() {
        return this.datumName;
    }

    public String getSpheroidName() {
        return this.spheroidName;
    }

    public double getMajorAxis() {
        return this.majorAxis;
    }

    public double getInverseFlattening() {
        return this.inverseMinor;
    }

    public String getPrimeMeridianName() {
        return this.primeMeridianName;
    }

    public double getPrimeMeridianValue() {
        return this.primeMeridianValue;
    }

    public String getGeogUnitName() {
        return this.geogUnitName;
    }

    public double getGeogUnitValue() {
        return this.geogUnitValue;
    }

    public boolean hasParameter(String name) {
        return this.parameters.get(name.toLowerCase()) != null;
    }

    public double getParameter(String name) {
        Double val = (Double)this.parameters.get(name.toLowerCase());
        if (val == null) {
            throw new IllegalArgumentException("no parameter called " + name);
        }
        return val;
    }

    public boolean isPlanarProjection() {
        return this.isAProjection;
    }

    public String getProjName() {
        return this.projName;
    }

    public String getProjectionType() {
        return this.projectionType;
    }

    public String getProjUnitName() {
        return this.projUnitName;
    }

    public double getProjUnitValue() {
        return this.projUnitValue;
    }

    public static ProjectionImpl convertWKTToProjection(WKTParser srp) {
        double lat0;
        if (!srp.isPlanarProjection()) {
            return new LatLonProjection();
        }
        String projectionType = srp.getProjectionType();
        double falseEasting = 0.0;
        double falseNorthing = 0.0;
        ProjectionImpl proj = null;
        if (srp.hasParameter("False_Easting")) {
            falseEasting = srp.getParameter("False_Easting");
        }
        if (srp.hasParameter("False_Northing")) {
            falseNorthing = srp.getParameter("False_Northing");
        }
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            double scalef = 1.0;
            if (srp.getProjUnitName() != null) {
                try {
                    SimpleUnit unit = SimpleUnit.factoryWithExceptions(srp.getProjUnitName());
                    scalef = unit.convertTo(srp.getProjUnitValue(), SimpleUnit.kmUnit);
                }
                catch (Exception e) {
                    System.out.println(srp.getProjUnitValue() + " " + srp.getProjUnitName() + " not convertible to km");
                }
            }
            falseEasting *= scalef;
            falseNorthing *= scalef;
        }
        if ("Transverse_Mercator".equals(projectionType)) {
            lat0 = srp.getParameter("Latitude_Of_Origin");
            double scale = srp.getParameter("Scale_Factor");
            double tangentLon = srp.getParameter("Central_Meridian");
            proj = new TransverseMercator(lat0, tangentLon, scale, falseEasting, falseNorthing);
        } else {
            double lon0;
            if ("Lambert_Conformal_Conic".equals(projectionType)) {
                double par1;
                lon0 = srp.getParameter("Central_Meridian");
                double par2 = par1 = srp.getParameter("Standard_Parallel_1");
                if (srp.hasParameter("Standard_Parallel_2")) {
                    par2 = srp.getParameter("Standard_Parallel_2");
                }
                double lat02 = srp.getParameter("Latitude_Of_Origin");
                return new LambertConformal(lat02, lon0, par1, par2, falseEasting, falseNorthing);
            }
            if ("Albers".equals(projectionType)) {
                double par1;
                lon0 = srp.getParameter("Central_Meridian");
                double par2 = par1 = srp.getParameter("Standard_Parallel_1");
                if (srp.hasParameter("Standard_Parallel_2")) {
                    par2 = srp.getParameter("Standard_Parallel_2");
                }
                double lat03 = srp.getParameter("Latitude_Of_Origin");
                return new AlbersEqualArea(lat03, lon0, par1, par2, falseEasting, falseNorthing);
            }
            if ("Stereographic".equals(projectionType)) {
                double lont = srp.getParameter("Central_Meridian");
                double scale = srp.getParameter("Scale_Factor");
                double latt = srp.getParameter("Latitude_Of_Origin");
                return new Stereographic(latt, lont, scale, falseEasting, falseNorthing);
            }
            if ("Mercator".equals(projectionType)) {
                lat0 = srp.getParameter("Latitude_Of_Origin");
                double lon02 = srp.getParameter("Central_Meridian");
                proj = new Mercator(lon02, lat0, falseEasting, falseNorthing);
            } else if ("Universal_Transverse_Mercator".equals(projectionType)) {
                // empty if block
            }
        }
        return proj;
    }
}

