/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    public KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        this(keyTransRecipientInfo, algorithmIdentifier, null, null, inputStream);
    }

    public KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, InputStream inputStream) {
        this(keyTransRecipientInfo, algorithmIdentifier, algorithmIdentifier2, null, inputStream);
    }

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, AlgorithmIdentifier algorithmIdentifier3, InputStream inputStream) {
        super(algorithmIdentifier, algorithmIdentifier2, algorithmIdentifier3, keyTransRecipientInfo.getKeyEncryptionAlgorithm(), inputStream);
        this.info = keyTransRecipientInfo;
        this.rid = new RecipientId();
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        try {
            if (recipientIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
                this.rid.setSubjectKeyIdentifier(aSN1OctetString.getOctets());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
                this.rid.setIssuer(issuerAndSerialNumber.getName().getEncoded());
                this.rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyTransRecipientInformation");
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier dERObjectIdentifier) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals(dERObjectIdentifier)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return dERObjectIdentifier.getId();
    }

    protected Key getSessionKey(Key key, Provider provider) throws CMSException {
        byte[] byArray = this.info.getEncryptedKey().getOctets();
        String string = this.getExchangeEncryptionAlgorithmName(this.keyEncAlg.getObjectId());
        AlgorithmIdentifier algorithmIdentifier = this.getActiveAlgID();
        String string2 = CMSEnvelopedHelper.INSTANCE.getSymmetricCipherName(algorithmIdentifier.getObjectId().getId());
        try {
            Key key2;
            Cipher cipher = CMSEnvelopedHelper.INSTANCE.getSymmetricCipher(string, provider);
            try {
                cipher.init(4, key);
                key2 = cipher.unwrap(byArray, string2, 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string2);
            }
            catch (IllegalStateException illegalStateException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string2);
            }
            catch (ProviderException providerException) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string2);
            }
            return key2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
    }

    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        Key key2 = this.getSessionKey(key, provider);
        return this.getContentFromSessionKey(key2, provider);
    }
}

