package JIRA::REST::Class::User;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.03';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents a JIRA user as an object.

__PACKAGE__->mk_data_ro_accessors(qw( active avatarUrls displayName emailAddress key name self timeZone));

1;

__END__

=pod

=encoding UTF-8

=for :stopwords Packy Anderson Alexey Melezhik Atlassian ScriptRunner TODO
aggregateprogress aggregatetimeestimate aggregatetimeoriginalestimate
assigneeType avatar avatarUrls completeDate displayName duedate
emailAddress endDate fieldtype fixVersions fromString genericized iconUrl
isAssigneeTypeValid issueTypes issuelinks issuetype jira jql lastViewed
maxResults originalEstimate originalEstimateSeconds parentkey projectId
rapidViewId remainingEstimate remainingEstimateSeconds resolutiondate
sprintlist startDate subtaskIssueTypes timeSpent timeSpentSeconds
timeestimate timeoriginalestimate timespent timetracking toString
updateAuthor worklog workratio

=head1 NAME

JIRA::REST::Class::User - A helper class for C<JIRA::REST::Class> that represents a JIRA user as an object.

=head1 VERSION

version 0.03

=head1 METHODS

=head2 B<active>

A boolean indicating whether or not the user is active.

=head2 B<avatarUrls>

A hashref of the different sizes available for the project's avatar.

=head2 B<displayName>

The display name of the user.

=head2 B<emailAddress>

The email address of the user.

=head2 B<key>

The key for the user.

=head2 B<name>

The short name of the user.

=head2 B<self>

The URL of the JIRA REST API for the user

=head2 B<timeZone>

The home time zone of the user.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
