/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.errorLogging;

import com.sun.electric.api.minarea.errorLogging.AbstractErrorLogger;
import com.sun.electric.api.minarea.errorLogging.io.CSVFile;
import com.sun.electric.api.minarea.errorLogging.io.CSVInput;
import com.sun.electric.api.minarea.errorLogging.io.CSVWriter;
import java.io.File;
import java.util.LinkedList;

public class ErrorLoggerCSVFile
extends AbstractErrorLogger {
    private String fileName = System.getProperty("minarea.csv");

    @Override
    public void printReports(long time) {
        try {
            LinkedList<String> csvEntry = new LinkedList<String>();
            csvEntry.add(String.valueOf(time));
            for (AbstractErrorLogger.MinAreaViolation violation : this.violations) {
                csvEntry.add(this.getViolationString(violation));
            }
            CSVFile csvFile = new CSVFile(Character.valueOf(';'));
            File file = new File(this.fileName);
            if (file.exists()) {
                CSVInput input = new CSVInput(file);
                csvFile = input.readCSVFile(Character.valueOf(';'), false);
            }
            csvFile.addLine(csvEntry);
            CSVWriter writer = new CSVWriter(file);
            writer.printCSVFile(csvFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getViolationString(AbstractErrorLogger.MinAreaViolation violation) {
        return violation.getMinArea() + "|" + violation.getX() + "|" + violation.getY();
    }
}

