/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.LayerId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.GDSLayers;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeGroup;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechFactory;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.GEM;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.collections.ImmutableArrayList;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;

public class Technology
implements Comparable<Technology>,
Serializable {
    public static final Version DISK_VERSION_1 = Version.parseVersion("8.05g");
    public static final Version DISK_VERSION_2 = Version.parseVersion("8.05o");
    public static final Technology[] NULL_ARRAY = new Technology[0];
    public static final ImmutableArrayList<Technology> EMPTY_LIST = ImmutableArrayList.of(new Technology[0]);
    public static final Variable.Key TRANS_CONTACT = Variable.newKey("MOCMOS_transcontacts");
    public static final String TECH_NODE = "technology/technologies";
    public static final String SPECIALMENUCELL = "Cell";
    public static final String SPECIALMENUMISC = "Misc.";
    public static final String SPECIALMENUPURE = "Pure";
    public static final String SPECIALMENUSPICE = "Spice";
    public static final String SPECIALMENUEXPORT = "Export";
    public static final String SPECIALMENUTEXT = "Text";
    public static final String SPECIALMENUHIGH = "High";
    public static final String SPECIALMENUPORT = "Port";
    public static final String SPECIALMENUSEPARATOR = "-";
    private static final int NONELECTRICAL = 1;
    private static final int NODIRECTIONALARCS = 2;
    private static final int NONEGATEDARCS = 4;
    private static final int NONSTANDARD = 8;
    private static final int STATICTECHNOLOGY = 16;
    private static final int NOPRIMTECHNOLOGY = 32;
    final Generic generic;
    private final TechId techId;
    private String techShortName;
    private String techDesc;
    private int userBits;
    private boolean scaleRelevant;
    private final Setting.RootGroup rootSettings;
    private final Setting.Group settings;
    private Color[] factoryTransparentColors = new Color[0];
    private final List<Layer> layers = new ArrayList<Layer>();
    private final HashMap<String, Layer> layersByName = new HashMap();
    private Layer[] layersByChronIndex = new Layer[0];
    private boolean layersAllocationLocked;
    private final LinkedHashMap<String, PrimitiveNode> nodes = new LinkedHashMap();
    private PrimitiveNode[] nodesByChronIndex = new PrimitiveNode[0];
    protected final HashMap<String, PrimitiveNode> oldNodeNames = new HashMap();
    private int nodeIndex = 0;
    final ArrayList<PrimitiveNodeGroup> primitiveNodeGroups = new ArrayList();
    private final LinkedHashMap<String, ArcProto> arcs = new LinkedHashMap();
    private ArcProto[] arcsByChronIndex = new ArcProto[0];
    protected final HashMap<String, ArcProto> oldArcNames = new HashMap();
    private String[] spiceHeaderLevel1;
    private String[] spiceHeaderLevel2;
    private String[] spiceHeaderLevel3;
    private ECoord factoryResolution = ECoord.ZERO;
    protected final List<Foundry> foundries = new ArrayList<Foundry>();
    private final Setting cacheFoundry;
    protected String paramFoundry;
    private Setting cacheScale;
    private final Setting cacheNumMetalLayers;
    protected Integer paramNumMetalLayers;
    private Setting cacheMinResistance;
    private Setting cacheMinCapacitance;
    private final Setting cacheGateLengthSubtraction;
    private final Setting cacheIncludeGate;
    private final Setting cacheIncludeGnd;
    private final Setting cacheMaxSeriesResistance;
    private Setting cacheGateCapacitance;
    private Setting cacheWireRatio;
    protected XMLRules factoryRules = null;
    private Setting cacheDiffAlpha;
    private static double DEFAULT_GATECAP = 0.4;
    private static double DEFAULT_WIRERATIO = 0.16;
    private static double DEFAULT_DIFFALPHA = 0.7;
    public static final int N_TYPE = 1;
    public static final int P_TYPE = 0;
    protected XMLRules cachedRules = null;
    protected final TechFactory techFactory;
    private final Map<TechFactory.Param, Object> paramValues;
    protected Xml.Technology xmlTech;
    protected Xml.MenuPalette factoryMenuPalette;
    private static Map<PrimitiveNode, List<ExtraField>> extraFields = new HashMap<PrimitiveNode, List<ExtraField>>();
    private static boolean photonicsChecked = false;
    private static Class<?> photonicsClass;
    private static final Layer.Function.Set diffLayers;

    public Map<TechFactory.Param, Object> getParamValues() {
        return this.paramValues;
    }

    protected Map<TechFactory.Param, Object> checkParamValues(Map<TechFactory.Param, Object> paramValues) {
        LinkedHashMap<TechFactory.Param, Object> fixedParamValues = new LinkedHashMap<TechFactory.Param, Object>();
        for (TechFactory.Param param : this.techFactory.getTechParams()) {
            Object value = paramValues.get(param);
            if (value == null || value.getClass() != param.factoryValue.getClass()) {
                value = param.factoryValue;
            }
            fixedParamValues.put(param, value);
        }
        return Collections.unmodifiableMap(fixedParamValues);
    }

    public SizeCorrector getSizeCorrector(Version version, Map<Setting, Object> projectSettings, boolean isJelib, boolean keepExtendOverMin) {
        return new SizeCorrector(version, isJelib);
    }

    protected void setArcCorrection(SizeCorrector sc, String arcName, double lambdaBaseWidth) {
        ArcProto ap = this.findArcProto(arcName);
        ECoord correction = sc.arcExtends.get(ap.getId());
        ECoord baseExtend = ECoord.fromLambdaRoundGrid(0.5 * lambdaBaseWidth);
        if (!baseExtend.equals(ap.getBaseExtend())) {
            correction = correction.add(baseExtend).subtract(ap.getBaseExtend());
            sc.arcExtends.put(ap.getId(), correction);
        }
    }

    protected void setNodeCorrection(SizeCorrector sc, String nodeName, double lambdaBaseWidth, double lambdaBaseHeight) {
        PrimitiveNode np = this.findNodeProto(nodeName);
        EPoint correction = sc.nodeExtends.get(np.getId());
        int gridWidthExtend = (int)DBMath.lambdaToGrid(0.5 * lambdaBaseWidth);
        int gridHeightExtend = (int)DBMath.lambdaToGrid(0.5 * lambdaBaseHeight);
        ERectangle baseRectangle = np.getBaseRectangle();
        if ((long)gridWidthExtend != baseRectangle.getGridWidth() / 2L || (long)gridHeightExtend != baseRectangle.getGridHeight() / 2L) {
            correction = EPoint.fromGrid(correction.getGridX() + (long)gridWidthExtend - baseRectangle.getGridWidth() / 2L, correction.getGridY() + (long)gridHeightExtend - baseRectangle.getGridHeight() / 2L);
            sc.nodeExtends.put(np.getId(), correction);
        }
    }

    protected Technology(Generic generic, TechFactory techFactory) {
        this(generic, techFactory, Foundry.Type.NONE, 0);
    }

    protected Technology(Generic generic, TechFactory techFactory, Foundry.Type defaultFoundry, int defaultNumMetals) {
        this(generic.getId().idManager, generic, techFactory, Collections.emptyMap(), defaultFoundry, defaultNumMetals);
    }

    protected Technology(Generic generic, TechFactory techFactory, Map<TechFactory.Param, Object> techParams, Foundry.Type defaultFoundry, int defaultNumMetals) {
        this(generic.getId().idManager, generic, techFactory, techParams, defaultFoundry, defaultNumMetals);
    }

    protected Technology(IdManager idManager, Generic generic, TechFactory techFactory, Map<TechFactory.Param, Object> techParams, Foundry.Type defaultFoundry, int defaultNumMetals) {
        if (this instanceof Generic) {
            assert (generic == null);
            generic = (Generic)this;
        }
        this.generic = generic;
        this.techId = idManager.newTechId(techFactory.techName);
        this.techFactory = techFactory;
        assert (techParams.size() == techFactory.getTechParams().size());
        for (TechFactory.Param param : techFactory.getTechParams()) {
            assert (techParams.get(param).getClass() == param.factoryValue.getClass());
        }
        this.paramValues = this.checkParamValues(techParams);
        this.scaleRelevant = true;
        this.userBits = 0;
        this.rootSettings = new Setting.RootGroup();
        this.settings = this.rootSettings.node(this.getTechName());
        this.cacheFoundry = this.makeStringSetting("SelectedFoundryFor" + this.getTechName(), "Technology tab", this.getTechName() + " foundry", "Foundry", defaultFoundry.getName());
        this.paramFoundry = defaultFoundry.getName();
        this.cacheNumMetalLayers = this.makeIntSetting(this.getTechName() + "NumberOfMetalLayers", "Technology tab", this.getTechName() + ": Number of Metal Layers", "NumMetalLayers", defaultNumMetals, new String[0]);
        this.paramNumMetalLayers = defaultNumMetals;
        this.cacheMaxSeriesResistance = this.makeParasiticSetting("MaxSeriesResistance", 10.0);
        this.cacheGateLengthSubtraction = this.makeParasiticSetting("GateLengthSubtraction", 0.0);
        this.cacheIncludeGate = this.makeParasiticSetting("Gate Inclusion", false);
        this.cacheIncludeGnd = this.makeParasiticSetting("Ground Net Inclusion", false);
    }

    protected Object writeReplace() {
        return new TechnologyKey(this);
    }

    public Technology(Generic generic, TechFactory techFactory, Map<TechFactory.Param, Object> techParams, Xml.Technology t) {
        this(generic, techFactory, techParams, Foundry.Type.valueOf(t.defaultFoundry), t.defaultNumMetals);
        this.xmlTech = t;
        this.factoryMenuPalette = t.menuPalette;
        this.setTechShortName(t.shortTechName);
        this.setTechDesc(t.description);
        this.setFactoryScale(t.scaleValue, t.scaleRelevant);
        this.setFactoryResolution(t.resolutionValue);
        this.setFactoryParasitics(t.minResistance, t.minCapacitance);
        this.setFactoryLESettings(t.leGateCapacitance, t.leWireRatio, t.leDiffAlpha);
        if (!t.transparentLayers.isEmpty()) {
            this.setFactoryTransparentLayers(t.transparentLayers.toArray(new Color[t.transparentLayers.size()]));
        }
        HashMap<String, Layer> layers = new HashMap<String, Layer>();
        for (Xml.Layer l : t.layers) {
            Layer layer = Layer.newInst(this, l.name, l.desc);
            layers.put(l.name, layer);
            layer.setFunction(l.function, l.extraFunction);
            layer.setFactoryParasitics(l.resistance, l.capacitance, l.edgeCapacitance, l.inductanceAreaFactor, l.inductanceLengthFactor);
            layer.setFactoryCIFLayer(l.cif != null ? l.cif : "");
            layer.setFactoryDXFLayer("");
            layer.setFactorySkillLayer(l.skill != null ? l.skill : "");
            layer.setFactory3DInfo(l.thick3D, l.height3D);
        }
        HashMap<String, ArcProto> arcs = new HashMap<String, ArcProto>();
        for (Xml.ArcProto a : t.arcs) {
            if (this.findArcProto(a.name) != null) {
                System.out.println("Error: technology " + this.getTechName() + " has multiple arcs named " + a.name);
                continue;
            }
            if (t.findPinNode(a.name) == null) {
                System.out.println("Error: no pin found for arc '" + a.name + "'");
            }
            ArcLayer[] arcLayers = new ArcLayer[a.arcLayers.size()];
            for (int i = 0; i < arcLayers.length; ++i) {
                Xml.ArcLayer al = a.arcLayers.get(i);
                Layer la = layers.get(al.layer);
                if (la == null) {
                    System.out.println("Error: no layer named '" + al.layer + "' found for arc '" + a.name + "'");
                }
                arcLayers[i] = new ArcLayer(layers.get(al.layer), al.style, al.extend.value);
            }
            Double diskOffset1 = a.diskOffset.get(1);
            Double diskOffset2 = a.diskOffset.get(2);
            long halfElibWidthOffset = 0L;
            if (diskOffset1 != null && diskOffset2 != null) {
                halfElibWidthOffset = DBMath.lambdaToGrid(diskOffset1 - diskOffset2);
            }
            ArcProto ap = a.curvable ? new ArcProto.Curvable(this, a.name, DBMath.gridToLambda(halfElibWidthOffset * 2L), a.function, arcLayers, arcs.size()) : new ArcProto(this, a.name, DBMath.gridToLambda(halfElibWidthOffset * 2L), a.function, arcLayers, arcs.size());
            this.addArcProto(ap);
            if (a.oldName != null) {
                this.oldArcNames.put(a.oldName, ap);
            }
            arcs.put(a.name, ap);
            if (a.wipable) {
                ap.setWipable();
            }
            if (a.special) {
                ap.setSpecialArc();
            }
            if (a.notUsed) {
                ap.setNotUsed(true);
            }
            if (a.skipSizeInPalette) {
                ap.setSkipSizeInPalette();
            }
            ap.setFactoryExtended(a.extended);
            ap.setFactoryFixedAngle(a.fixedAngle);
            ap.setFactoryAngleIncrement(a.angleIncrement);
            ap.setFactoryAntennaRatio(a.antennaRatio);
        }
        this.setNoNegatedArcs();
        for (Xml.PrimitiveNodeGroup ng : t.nodeGroups) {
            PrimitiveNodeGroup.makePrimitiveNodes(this, ng, layers, arcs);
        }
        for (Xml.Layer l : t.layers) {
            if (l.pureLayerNode == null) continue;
            Layer layer = layers.get(l.name);
            PrimitiveNode pn = layer.makePureLayerNode(l.pureLayerNode.name, l.pureLayerNode.size.value, l.pureLayerNode.style, l.pureLayerNode.port, Technology.makeConnections(l.pureLayerNode.name, l.pureLayerNode.port, l.pureLayerNode.portArcs, arcs));
            if (l.pureLayerNode.oldName == null) continue;
            this.oldNodeNames.put(l.pureLayerNode.oldName, pn);
        }
        for (Xml.SpiceHeader h : t.spiceHeaders) {
            String[] spiceLines = h.spiceLines.toArray(new String[h.spiceLines.size()]);
            switch (h.level) {
                case 1: {
                    this.setSpiceHeaderLevel1(spiceLines);
                    break;
                }
                case 2: {
                    this.setSpiceHeaderLevel2(spiceLines);
                    break;
                }
                case 3: {
                    this.setSpiceHeaderLevel3(spiceLines);
                }
            }
        }
        for (Xml.Foundry f : t.foundries) {
            ArrayList<CallSite> gdsLayers = new ArrayList<CallSite>();
            for (Layer layer : this.layers) {
                String gds = f.layerGds.get(layer.getName());
                if (gds == null) continue;
                gdsLayers.add((CallSite)((Object)(layer.getName() + " " + gds)));
            }
            Foundry foundry = new Foundry(this, Foundry.Type.valueOf(f.name), f.rules, gdsLayers.toArray(new String[gdsLayers.size()]));
            this.foundries.add(foundry);
        }
    }

    static ArcProto[] makeConnections(String nodeName, String portName, List<String> portArcs, Map<String, ArcProto> arcs) {
        ArcProto[] connections = new ArcProto[portArcs.size()];
        for (int j = 0; j < connections.length; ++j) {
            ArcProto ap = arcs.get(portArcs.get(j));
            if (ap == null) {
                String error = "No such arcProto '" + portArcs.get(j) + "' found for node '" + nodeName + "', port '" + portName + "'";
                throw new NoSuchElementException(error);
            }
            connections[j] = ap;
        }
        return connections;
    }

    static TechPoint makeTechPoint(Xml.Distance x, Xml.Distance y) {
        return new TechPoint(Technology.makeEdgeH(x), Technology.makeEdgeV(y));
    }

    static EdgeH makeEdgeH(Xml.Distance x) {
        return new EdgeH(x.k * 0.5, x.value);
    }

    static EdgeV makeEdgeV(Xml.Distance y) {
        return new EdgeV(y.k * 0.5, y.value);
    }

    public boolean isXmlTechAvailable() {
        return this.xmlTech != null;
    }

    public Xml.Technology getXmlTech() {
        return this.xmlTech != null ? this.xmlTech.deepClone() : null;
    }

    public static Environment makeInitialEnvironment() {
        Environment env = IdManager.stdIdManager.getInitialEnvironment();
        env = env.withToolSettings((Setting.RootGroup)ToolSettings.getToolSettings(""));
        Generic generic = Generic.newInst(IdManager.stdIdManager);
        env = env.addTech(generic);
        for (TechFactory techFactory : TechFactory.getKnownTechs().values()) {
            Map<TechFactory.Param, Object> paramValues;
            Technology tech = techFactory.newInst(generic, paramValues = Technology.paramValuesFromPreferences(techFactory));
            if (tech == null) continue;
            env = env.addTech(tech);
        }
        Setting.SettingChangeBatch changeBatch = new Setting.SettingChangeBatch();
        Preferences prefRoot = Pref.getPrefRoot();
        for (Setting setting : env.getSettings().keySet()) {
            changeBatch.add(setting, setting.getValueFromPreferences(prefRoot));
        }
        for (Technology t : env.techPool.values()) {
            for (Map.Entry<TechFactory.Param, Object> e : t.getParamValues().entrySet()) {
                TechFactory.Param param = e.getKey();
                changeBatch.add(t.getSetting(param), e.getValue());
            }
        }
        env = env.withSettingChanges(changeBatch);
        return env;
    }

    public static Map<String, Object> getParamValuesByXmlPath() {
        HashMap<String, Object> paramValuesByXmlPath = new HashMap<String, Object>();
        for (TechFactory techFactory : TechFactory.getKnownTechs().values()) {
            Map<TechFactory.Param, Object> paramValues = Technology.paramValuesFromPreferences(techFactory);
            for (Map.Entry<TechFactory.Param, Object> e : paramValues.entrySet()) {
                paramValuesByXmlPath.put(e.getKey().xmlPath, e.getValue());
            }
        }
        return paramValuesByXmlPath;
    }

    public static void initPreinstalledTechnologies(EDatabase database, Map<String, Object> paramValuesByXmlPath) {
        database.setToolSettings((Setting.RootGroup)ToolSettings.getToolSettings(""));
        assert (database.getGeneric() == null);
        Generic generic = Generic.newInst(database.getIdManager());
        database.addTech(generic);
        for (TechFactory techFactory : TechFactory.getKnownTechs().values()) {
            HashMap<TechFactory.Param, Object> paramValues = new HashMap<TechFactory.Param, Object>();
            for (TechFactory.Param techParam : techFactory.getTechParams()) {
                Object paramValue = paramValuesByXmlPath.get(techParam.xmlPath);
                if (paramValue == null) continue;
                paramValues.put(techParam, paramValue);
            }
            Technology tech = techFactory.newInst(generic, paramValues);
            if (tech == null) continue;
            database.addTech(tech);
        }
    }

    private static Map<TechFactory.Param, Object> paramValuesFromPreferences(TechFactory techFactory) {
        HashMap<TechFactory.Param, Object> paramValues = new HashMap<TechFactory.Param, Object>();
        for (TechFactory.Param param : techFactory.getTechParams()) {
            String prefPath = param.prefPath;
            int index = prefPath.lastIndexOf(47);
            String prefName = prefPath.substring(index + 1);
            prefPath = prefPath.substring(0, index);
            Preferences prefNode = Pref.getPrefRoot().node(prefPath);
            Object value = null;
            Object factoryValue = param.factoryValue;
            value = factoryValue instanceof Boolean ? Boolean.valueOf(prefNode.getBoolean(prefName, (Boolean)factoryValue)) : (factoryValue instanceof Integer ? Integer.valueOf(prefNode.getInt(prefName, (Integer)factoryValue)) : (factoryValue instanceof Long ? Long.valueOf(prefNode.getLong(prefName, (Long)factoryValue)) : (factoryValue instanceof Double ? Double.valueOf(prefNode.getDouble(prefName, (Double)factoryValue)) : prefNode.get(prefName, factoryValue.toString()))));
            if (value.equals(factoryValue)) {
                value = factoryValue;
            }
            paramValues.put(param, value);
        }
        return paramValues;
    }

    public static Technology getMocmosTechnology() {
        return Technology.findTechnology("mocmos");
    }

    public static Technology getTSMC180Technology() {
        return Technology.findTechnology("tsmc180");
    }

    public static Technology getCMOS90Technology() {
        return Technology.findTechnology("cmos90");
    }

    public static List<ExtraField> getExtraFields(PrimitiveNode np) {
        return extraFields.get(np);
    }

    public static boolean hasPhotonics() {
        if (!photonicsChecked) {
            photonicsChecked = true;
            try {
                photonicsClass = Class.forName("com.sun.electric.plugins.photonics.Photonics");
            }
            catch (ClassNotFoundException e) {
                photonicsClass = null;
                return false;
            }
        }
        return photonicsClass != null;
    }

    public void setup() {
        if (this.cacheMinResistance == null || this.cacheMinCapacitance == null) {
            this.setFactoryParasitics(10.0, 0.0);
        }
        if (this.cacheGateCapacitance == null || this.cacheWireRatio == null || this.cacheDiffAlpha == null) {
            this.setFactoryLESettings(DEFAULT_GATECAP, DEFAULT_WIRERATIO, DEFAULT_DIFFALPHA);
        }
        this.layersAllocationLocked = true;
        for (Foundry foundry : this.foundries) {
            foundry.finish();
        }
        for (Layer layer : this.layers) {
            layer.finish();
        }
        for (ArcProto arcProto : this.arcs.values()) {
            arcProto.finish();
        }
        this.rootSettings.lock();
        this.check();
    }

    public Technology withTechParams(Map<TechFactory.Param, Object> paramValues) {
        Map<TechFactory.Param, Object> newParams = this.checkParamValues(paramValues);
        if (newParams.equals(this.paramValues)) {
            return this;
        }
        return this.techFactory.newInst(this.generic, newParams);
    }

    protected void setNotUsed(int numPolys) {
        boolean isUsed;
        int numMetals = this.getNumMetals();
        for (PrimitiveNode pn : this.nodes.values()) {
            isUsed = true;
            for (NodeLayer nl : pn.getNodeLayers()) {
                isUsed = isUsed && nl.getLayer().getFunction().isUsed(numMetals, numPolys);
            }
            pn.setNotUsed(!isUsed);
        }
        for (ArcProto ap : this.arcs.values()) {
            isUsed = true;
            for (ArcLayer al : ap.layers) {
                isUsed = isUsed && al.getLayer().getFunction().isUsed(numMetals, numPolys);
            }
            ap.setNotUsed(!isUsed);
        }
    }

    public static Technology getCurrent() {
        return Job.getUserInterface().getCurrentTechnology();
    }

    public static Technology findTechnology(String name) {
        if (name == null) {
            return null;
        }
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology t = it.next();
            if (!t.getTechName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public static Technology findTechnology(TechId techId) {
        return TechPool.getThreadTechPool().getTech(techId);
    }

    public static Iterator<Technology> getTechnologies() {
        return TechPool.getThreadTechPool().values().iterator();
    }

    public Map<Setting, Object> convertOldVariable(String varName, Object value) {
        return null;
    }

    public boolean cleanUnusedNodesInLibrary(NodeInst ni, List<Geometric> list) {
        NodeProto np = ni.getProto();
        if (np instanceof PrimitiveNode && ((PrimitiveNode)np).isNotUsed()) {
            if (list != null) {
                list.add(ni);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(PrintWriter out, Map<Setting, Object> settings) {
        void var6_19;
        String[] techBits = new String[]{"NONELECTRICAL", "NODIRECTIONALARCS", "NONEGATEDARCS", "NONSTANDARD", "STATICTECHNOLOGY", "NOPRIMTECHNOLOGY"};
        out.println("Technology " + this.getTechName());
        out.println(this.getClass().toString());
        out.println("shortName=" + this.getTechShortName());
        out.println("techDesc=" + this.getTechDesc());
        out.print("Bits: ");
        Technology.printlnBits(out, techBits, this.userBits);
        out.print("isScaleRelevant=" + this.isScaleRelevant());
        Technology.printlnSetting(out, settings, this.getScaleSetting());
        Technology.printlnSetting(out, settings, this.getPrefFoundrySetting());
        Technology.printlnSetting(out, settings, this.getNumMetalsSetting());
        this.dumpExtraProjectSettings(out, settings);
        Technology.printlnSetting(out, settings, this.getMinResistanceSetting());
        Technology.printlnSetting(out, settings, this.getGateLengthSubtractionSetting());
        Technology.printlnSetting(out, settings, this.getGateIncludedSetting());
        Technology.printlnSetting(out, settings, this.getGroundNetIncludedSetting());
        Technology.printlnSetting(out, settings, this.getMaxSeriesResistanceSetting());
        Technology.printlnSetting(out, settings, this.getGateCapacitanceSetting());
        Technology.printlnSetting(out, settings, this.getWireRatioSetting());
        Technology.printlnSetting(out, settings, this.getDiffAlphaSetting());
        Technology.printlnPref(out, 0, "ResolutionValueFor" + this.getTechName(), this.factoryResolution.getLambda());
        Color[] transparentLayers = this.getFactoryTransparentLayerColors();
        for (int i = 0; i < transparentLayers.length; ++i) {
            out.println("TRANSPARENT_" + (i + 1) + "=" + Integer.toHexString(transparentLayers[i].getRGB()));
        }
        for (Layer layer : this.layers) {
            layer.dump(out, settings);
        }
        for (ArcProto arcProto : this.arcs.values()) {
            arcProto.dump(out);
        }
        if (!this.oldArcNames.isEmpty()) {
            out.println("OldArcNames:");
            for (Map.Entry entry : this.getOldArcNames().entrySet()) {
                out.println("\t" + (String)entry.getKey() + " --> " + ((ArcProto)entry.getValue()).getFullName());
            }
        }
        for (PrimitiveNode primitiveNode : this.nodes.values()) {
            primitiveNode.dump(out);
        }
        if (!this.oldNodeNames.isEmpty()) {
            out.println("OldNodeNames:");
            for (Map.Entry entry : this.getOldNodeNames().entrySet()) {
                out.println("\t" + (String)entry.getKey() + " --> " + ((PrimitiveNode)entry.getValue()).getFullName());
            }
        }
        for (Foundry foundry : this.foundries) {
            out.println("Foundry " + foundry.getType());
            for (Layer layer : this.layers) {
                Setting setting = foundry.getGDSLayerSetting(layer);
                out.print("\t");
                Technology.printlnSetting(out, settings, setting);
            }
        }
        this.printSpiceHeader(out, 1, this.getSpiceHeaderLevel1());
        this.printSpiceHeader(out, 2, this.getSpiceHeaderLevel2());
        this.printSpiceHeader(out, 3, this.getSpiceHeaderLevel3());
        Xml.MenuPalette menuPalette = this.getFactoryMenuPalette();
        boolean bl = false;
        while (var6_19 < menuPalette.menuBoxes.size()) {
            List<?> menuBox = menuPalette.menuBoxes.get((int)var6_19);
            if (menuBox != null && !menuBox.isEmpty()) {
                out.print(" menu " + (int)(var6_19 / menuPalette.numColumns) + " " + (int)(var6_19 % menuPalette.numColumns));
                for (Object menuItem : menuBox) {
                    if (menuItem instanceof Xml.ArcProto) {
                        out.print(" arc " + ((Xml.ArcProto)menuItem).name);
                        continue;
                    }
                    if (menuItem instanceof Xml.PrimitiveNode) {
                        out.print(" node " + ((Xml.PrimitiveNode)menuItem).name);
                        continue;
                    }
                    if (menuItem instanceof Xml.MenuNodeInst) {
                        Xml.MenuNodeInst n = (Xml.MenuNodeInst)menuItem;
                        boolean display = n.text != null;
                        out.print(" nodeInst " + n.protoName + ":" + n.function + ":" + Orientation.fromAngle(n.rotation));
                        if (n.text == null) continue;
                        out.print(":" + n.text + ":" + display);
                        continue;
                    }
                    assert (menuItem instanceof String);
                    out.print(" " + menuItem);
                }
                out.println();
            }
            ++var6_19;
        }
        Iterator<Foundry> iterator = this.getFoundries();
        while (iterator.hasNext()) {
            Foundry foundry = iterator.next();
            out.println("    <Foundry name=\"" + foundry.getType().getName() + "\">");
            Iterator<Layer> iterator2 = this.getLayers();
            while (iterator2.hasNext()) {
                Layer layer = iterator2.next();
                Setting layerGdsSetting = foundry.getGDSLayerSetting(layer);
                String gdsStr = (String)settings.get(layerGdsSetting);
                if (gdsStr == null || gdsStr.length() == 0) continue;
                out.println("        <layerGds layer=\"" + layer.getName() + "\" gds=\"" + gdsStr + "\"/>");
            }
            List<DRCTemplate> list = foundry.getRules();
            if (list != null) {
                for (DRCTemplate rule : list) {
                    DRCTemplate.exportDRCRule(out, rule);
                }
            }
            out.println("    </Foundry>");
        }
    }

    protected void dumpExtraProjectSettings(PrintWriter out, Map<Setting, Object> settings) {
    }

    protected static void printlnSetting(PrintWriter out, Map<Setting, Object> settings, Setting setting) {
        out.println(setting.getXmlPath() + "=" + settings.get(setting) + "(" + setting.getFactoryValue() + ")");
    }

    static void printlnPref(PrintWriter out, int indent, String prefName, Object factoryValue) {
        while (indent-- > 0) {
            out.print("\t");
        }
        out.println(prefName + "=" + factoryValue);
    }

    protected static void printlnBits(PrintWriter out, String[] bitNames, int bits) {
        for (int i = 0; i < 32; ++i) {
            Object bitName;
            if ((bits & 1 << i) == 0) continue;
            Object object = bitName = i < bitNames.length ? bitNames[i] : null;
            if (bitName == null) {
                bitName = "BIT" + i;
            }
            out.print(" " + (String)bitName);
        }
        out.println();
    }

    private void printSpiceHeader(PrintWriter out, int level, String[] header) {
        if (header == null) {
            return;
        }
        out.println("SpiceHeader " + level);
        for (String s : header) {
            out.println("\t\"" + s + "\"");
        }
    }

    public Xml.Technology makeXml() {
        return this.makeXml(null);
    }

    public Xml.Technology makeXml(Map<Object, Map<String, Object>> additiionalAttributes) {
        int numMetals;
        Xml.Technology t = new Xml.Technology();
        t.techName = this.getTechName();
        if (this.getClass() != Technology.class) {
            t.className = this.getClass().getName();
        }
        Xml.Version version = new Xml.Version();
        version.techVersion = 1;
        version.electricVersion = DISK_VERSION_1;
        t.versions.add(version);
        version = new Xml.Version();
        version.techVersion = 2;
        version.electricVersion = DISK_VERSION_2;
        t.versions.add(version);
        t.shortTechName = this.getTechShortName();
        t.description = this.getTechDesc();
        t.maxNumMetals = t.defaultNumMetals = (numMetals = ((Integer)this.getNumMetalsSetting().getFactoryValue()).intValue());
        t.minNumMetals = t.defaultNumMetals;
        t.scaleValue = this.getScaleSetting().getDoubleFactoryValue();
        t.scaleRelevant = this.isScaleRelevant();
        t.resolutionValue = this.getFactoryResolution().getLambda();
        t.defaultFoundry = (String)this.getPrefFoundrySetting().getFactoryValue();
        t.minResistance = this.getMinResistanceSetting().getDoubleFactoryValue();
        t.minCapacitance = this.getMinCapacitanceSetting().getDoubleFactoryValue();
        t.leGateCapacitance = this.getGateCapacitanceSetting().getDoubleFactoryValue();
        t.leWireRatio = this.getWireRatioSetting().getDoubleFactoryValue();
        t.leDiffAlpha = this.getDiffAlphaSetting().getDoubleFactoryValue();
        t.transparentLayers.addAll(Arrays.asList(this.getFactoryTransparentLayerColors()));
        Iterator<Comparable> it = this.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            t.layers.add(layer.makeXml());
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            t.arcs.add(ap.makeXml());
        }
        HashSet<PrimitiveNodeGroup> groupsDone = new HashSet<PrimitiveNodeGroup>();
        Iterator<Object> it2 = this.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode pnp = it2.next();
            if (pnp.getFunction() == PrimitiveNode.Function.NODE) continue;
            PrimitiveNodeGroup group = pnp.getPrimitiveNodeGroup();
            if (group != null) {
                if (groupsDone.contains(group)) continue;
                t.nodeGroups.add(group.makeXml());
                groupsDone.add(group);
                continue;
            }
            t.nodeGroups.add(pnp.makeXml(additiionalAttributes));
        }
        Technology.addSpiceHeader(t, 1, this.getSpiceHeaderLevel1());
        Technology.addSpiceHeader(t, 2, this.getSpiceHeaderLevel2());
        Technology.addSpiceHeader(t, 3, this.getSpiceHeaderLevel3());
        t.menuPalette = this.getFactoryMenuPalette();
        it2 = this.getFoundries();
        while (it2.hasNext()) {
            Foundry foundry = (Foundry)it2.next();
            Xml.Foundry f = new Xml.Foundry();
            f.name = foundry.toString();
            for (Layer layer : this.layers) {
                Setting setting = foundry.getGDSLayerSetting(layer);
                String gds = (String)setting.getFactoryValue();
                if (gds.length() == 0) continue;
                f.layerGds.put(layer.getName(), gds);
            }
            List<DRCTemplate> rules = foundry.getRules();
            if (rules != null) {
                f.rules.addAll(rules);
            }
            t.foundries.add(f);
        }
        return t;
    }

    private static void addSpiceHeader(Xml.Technology t, int level, String[] spiceLines) {
        if (spiceLines == null) {
            return;
        }
        Xml.SpiceHeader spiceHeader = new Xml.SpiceHeader();
        spiceHeader.level = level;
        for (String spiceLine : spiceLines) {
            spiceHeader.spiceLines.add(spiceLine);
        }
        t.spiceHeaders.add(spiceHeader);
    }

    public Iterator<Layer> getLayers() {
        this.layersAllocationLocked = true;
        return this.layers.iterator();
    }

    Layer getLayerByChronIndex(int chronIndex) {
        return chronIndex < this.layersByChronIndex.length ? this.layersByChronIndex[chronIndex] : null;
    }

    public Layer getLayer(int index) {
        return this.layers.get(index);
    }

    public int getNumLayers() {
        this.layersAllocationLocked = true;
        return this.layers.size();
    }

    public Layer findLayer(String layerName) {
        Layer layer = this.layersByName.get(layerName);
        if (layer != null) {
            return layer;
        }
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            layer = it.next();
            if (!layer.getName().equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        it = this.getLayers();
        while (it.hasNext()) {
            layer = it.next();
            if (layer == null || !layer.getName().equalsIgnoreCase(layerName)) continue;
            return layer;
        }
        return null;
    }

    public int getRuleIndex(int index1, int index2) {
        int numLayers = this.getNumLayers();
        if (index1 > index2) {
            int temp = index1;
            index1 = index2;
            index2 = temp;
        }
        int pIndex = (index1 + 1) * (index1 / 2) + (index1 & 1) * ((index1 + 1) / 2);
        pIndex = index2 + numLayers * index1 - pIndex;
        return numLayers + this.getNumNodes() + pIndex;
    }

    public final int getPrimNodeIndexInTech(PrimitiveNode node) {
        return this.getNumLayers() + node.getPrimNodeInddexInTech();
    }

    public int getRuleNodeIndex(String name) {
        int count = 0;
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            if (pn.getName().equals(name)) {
                return this.getNumLayers() + count;
            }
            ++count;
        }
        return -1;
    }

    public static Layer getLayerFromOverride(String override, int startPos, char endChr, Technology tech) {
        int endPos = override.indexOf(endChr, startPos);
        if (endPos < 0) {
            return null;
        }
        String layerName = override.substring(startPos, endPos);
        return tech.findLayer(layerName);
    }

    public Layer findLayerFromFunction(Layer.Function fun, int functionExtras) {
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer lay = it.next();
            Layer.Function lFun = lay.getFunction();
            if (lFun != fun || functionExtras != -1 && functionExtras != lay.getFunctionExtras()) continue;
            return lay;
        }
        return null;
    }

    public void addLayer(Layer layer) {
        if (this.layersAllocationLocked) {
            throw new IllegalStateException("layers allocation is locked");
        }
        layer.setIndex(this.layers.size());
        this.layers.add(layer);
        Layer oldLayer = this.layersByName.put(layer.getName(), layer);
        assert (oldLayer == null);
        LayerId layerId = layer.getId();
        if (layerId.chronIndex >= this.layersByChronIndex.length) {
            Layer[] newLayersByChronIndex = new Layer[layerId.chronIndex + 1];
            System.arraycopy(this.layersByChronIndex, 0, newLayersByChronIndex, 0, this.layersByChronIndex.length);
            this.layersByChronIndex = newLayersByChronIndex;
        }
        assert (this.layersByChronIndex[layerId.chronIndex] == null);
        this.layersByChronIndex[layerId.chronIndex] = layer;
    }

    public boolean sameLayer(Layer layer1, Layer layer2) {
        if (layer1 == layer2) {
            return true;
        }
        if (layer1.getFunction() == layer2.getFunction() && layer1.getFunctionExtras() == layer2.getFunctionExtras()) {
            return true;
        }
        if (layer1.getFunction() == Layer.Function.POLY1 && layer2.getFunction() == Layer.Function.GATE) {
            return true;
        }
        return layer2.getFunction() == Layer.Function.POLY1 && layer1.getFunction() == Layer.Function.GATE;
    }

    public List<Layer> getLayersSortedByUserPreference() {
        return this.getLayersSortedByRule(Layer.LayerSortingType.findType(User.getLayersSorting()));
    }

    public List<Layer> getLayersSortedByRule(Layer.LayerSortingType type) {
        ArrayList<Layer> layerList = new ArrayList<Layer>();
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            layerList.add(it.next());
        }
        if (type != Layer.LayerSortingType.ByOrderInTechFile) {
            return Layer.getLayersSortedByRule(layerList, type);
        }
        return layerList;
    }

    public boolean hasColoredMetalLayer(Layer layer) {
        Layer.Function f1 = layer.getFunction();
        assert (!f1.isColored());
        Iterator<Layer> it = this.getLayers();
        while (it.hasNext()) {
            Layer l = it.next();
            Layer.Function f2 = l.getFunction();
            if (f1.getLevel() != f2.getLevel() || !f2.isColored()) continue;
            return true;
        }
        return false;
    }

    public int getNumMetals() {
        return this.paramNumMetalLayers;
    }

    public Setting getNumMetalsSetting() {
        return this.cacheNumMetalLayers;
    }

    protected ArcProto newArcProto(String protoName, double lambdaWidthOffset, double defaultWidth, ArcProto.Function function, ArcLayer ... layers) {
        if (this.findArcProto(protoName) != null) {
            System.out.println("Error: technology " + this.getTechName() + " has multiple arcs named " + protoName);
            return null;
        }
        long gridWidthOffset = DBMath.lambdaToSizeGrid(lambdaWidthOffset);
        if (gridWidthOffset < 0L || gridWidthOffset > Integer.MAX_VALUE) {
            System.out.println("ArcProto " + this.getTechName() + ":" + protoName + " has invalid width offset " + lambdaWidthOffset);
            return null;
        }
        if (defaultWidth < DBMath.gridToLambda(gridWidthOffset)) {
            System.out.println("ArcProto " + this.getTechName() + ":" + protoName + " has negative width");
            return null;
        }
        long defaultGridWidth = DBMath.lambdaToSizeGrid(defaultWidth);
        assert (layers[0].getExtend().getGrid() == (defaultGridWidth - gridWidthOffset) / 2L);
        ArcProto ap = new ArcProto(this, protoName, DBMath.gridToLambda(gridWidthOffset), function, layers, this.arcs.size());
        this.addArcProto(ap);
        return ap;
    }

    public ArcProto findArcProto(String name) {
        if (name == null) {
            return null;
        }
        return this.arcs.get(name);
    }

    public ArcProto getArcProto(ArcProtoId arcProtoId) {
        assert (arcProtoId.techId == this.techId);
        int chronIndex = arcProtoId.chronIndex;
        return chronIndex < this.arcsByChronIndex.length ? this.arcsByChronIndex[chronIndex] : null;
    }

    ArcProto getArcProtoByChronIndex(int chronIndex) {
        return chronIndex < this.arcsByChronIndex.length ? this.arcsByChronIndex[chronIndex] : null;
    }

    public Iterator<ArcProto> getArcs() {
        return this.arcs.values().iterator();
    }

    public Collection<ArcProto> getArcsCollection() {
        return this.arcs.values();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public ArcProto getArc(ArcProto.Function fun, int mask) {
        ArrayList<ArcProto> possibleArcs = new ArrayList<ArcProto>();
        Iterator<ArcProto> it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (ap.getFunction() != fun) continue;
            possibleArcs.add(ap);
        }
        if (possibleArcs.size() == 0) {
            return null;
        }
        if (possibleArcs.size() == 1 || mask == 0) {
            return (ArcProto)possibleArcs.get(0);
        }
        for (ArcProto ap : possibleArcs) {
            int maskNum = ap.getMaskLayer();
            if (maskNum != mask) continue;
            return ap;
        }
        return (ArcProto)possibleArcs.get(0);
    }

    public void addArcProto(ArcProto ap) {
        assert (this.findArcProto(ap.getName()) == null);
        assert (ap.primArcIndex == this.arcs.size());
        this.arcs.put(ap.getName(), ap);
        ArcProtoId arcProtoId = ap.getId();
        if (arcProtoId.chronIndex >= this.arcsByChronIndex.length) {
            ArcProto[] newArcsByChronIndex = new ArcProto[arcProtoId.chronIndex + 1];
            System.arraycopy(this.arcsByChronIndex, 0, newArcsByChronIndex, 0, this.arcsByChronIndex.length);
            this.arcsByChronIndex = newArcsByChronIndex;
        }
        this.arcsByChronIndex[arcProtoId.chronIndex] = ap;
    }

    protected void setNoDirectionalArcs() {
        this.userBits |= 2;
    }

    public boolean isNoDirectionalArcs() {
        return (this.userBits & 2) != 0;
    }

    protected void setNoNegatedArcs() {
        this.userBits |= 4;
    }

    public boolean isNoNegatedArcs() {
        return (this.userBits & 4) != 0;
    }

    public Poly[] getShapeOfArc(ArcInst ai) {
        return this.getShapeOfArc(ai, null);
    }

    public Poly[] getShapeOfArc(ArcInst ai, Layer.Function.Set onlyTheseLayers) {
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        return polyBuilder.getShapeArray(ai, onlyTheseLayers);
    }

    public ArcProto convertOldArcName(String name) {
        return this.oldArcNames.get(name);
    }

    public Map<String, ArcProto> getOldArcNames() {
        return new TreeMap<String, ArcProto>(this.oldArcNames);
    }

    public List<PrimitiveNode> getNodesSortedByName() {
        TreeMap<String, PrimitiveNode> sortedMap = new TreeMap<String, PrimitiveNode>(TextUtils.STRING_NUMBER_ORDER);
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pn = it.next();
            sortedMap.put(pn.getName(), pn);
        }
        return new ArrayList<PrimitiveNode>(sortedMap.values());
    }

    public PrimitiveNode findNodeProto(String name) {
        if (name == null) {
            return null;
        }
        return this.nodes.get(name);
    }

    public PrimitiveNode getPrimitiveNode(PrimitiveNodeId primitiveNodeId) {
        assert (primitiveNodeId.techId == this.techId);
        int chronIndex = primitiveNodeId.chronIndex;
        return chronIndex < this.nodesByChronIndex.length ? this.nodesByChronIndex[chronIndex] : null;
    }

    PrimitiveNode getPrimitiveNodeByChronIndex(int chronIndex) {
        return chronIndex < this.nodesByChronIndex.length ? this.nodesByChronIndex[chronIndex] : null;
    }

    public Iterator<PrimitiveNode> getNodes() {
        return this.nodes.values().iterator();
    }

    public Collection<PrimitiveNode> getNodesCollection() {
        return this.nodes.values();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    protected PrimitiveNode newPrimitiveNode(String protoName, EPoint sizeCorrector1, EPoint sizeCorrector2, String minSizeRule, double width, double height, ERectangle fullRectangle, ERectangle baseRectangle, NodeLayer[] layers) {
        return new PrimitiveNode(protoName, this, sizeCorrector1, sizeCorrector2, minSizeRule, width, height, fullRectangle, baseRectangle, layers);
    }

    public void addNodeProto(PrimitiveNode np) {
        if (Job.getDebug() && this.findNodeProto(np.getName()) != null) {
            System.out.println(np.getName() + " is already defined as primitive node");
        }
        assert (this.findNodeProto(np.getName()) == null);
        np.setPrimNodeIndexInTech(this.nodeIndex++);
        this.nodes.put(np.getName(), np);
        PrimitiveNodeId primitiveNodeId = np.getId();
        if (primitiveNodeId.chronIndex >= this.nodesByChronIndex.length) {
            PrimitiveNode[] newNodesByChronIndex = new PrimitiveNode[primitiveNodeId.chronIndex + 1];
            System.arraycopy(this.nodesByChronIndex, 0, newNodesByChronIndex, 0, this.nodesByChronIndex.length);
            this.nodesByChronIndex = newNodesByChronIndex;
        }
        this.nodesByChronIndex[primitiveNodeId.chronIndex] = np;
    }

    public PrimitiveNodeSize getResistorSize(NodeInst ni, VarContext context) {
        if (ni.isCellInstance()) {
            return null;
        }
        double length = ni.getLambdaBaseXSize();
        double width = ni.getLambdaBaseYSize();
        PrimitiveNodeSize size = new PrimitiveNodeSize(width, length, false);
        return size;
    }

    public double getTransistorActiveLength(NodeInst ni) {
        Poly[] diffList = this.getShapeOfNode(ni, true, false, diffLayers);
        double activeLen = 0.0;
        if (diffList.length > 0) {
            Poly poly = diffList[0];
            activeLen = poly.getBounds2D().getHeight();
        }
        return activeLen;
    }

    public TransistorSize getTransistorSize(NodeInst ni, VarContext context) {
        double width = ni.getLambdaBaseXSize();
        double height = ni.getLambdaBaseYSize();
        EPoint[] trace = ni.getTrace();
        if (trace != null) {
            width = 0.0;
            for (int i = 1; i < trace.length; ++i) {
                width += ((Point2D)trace[i - 1]).distance(trace[i]);
            }
            height = 2.0;
            double serpentineLength = ni.getSerpentineTransistorLength();
            if (serpentineLength > 0.0) {
                height = serpentineLength;
            }
        }
        double activeLen = this.getTransistorActiveLength(ni);
        TransistorSize size = new TransistorSize(width, height, activeLen, null, true);
        return size;
    }

    private void setPrimitiveNodeSizeLocal(NodeInst ni, double width, double length) {
        double oldWidth = ni.getLambdaBaseXSize();
        double oldLength = ni.getLambdaBaseYSize();
        double dW = width - oldWidth;
        double dL = length - oldLength;
        ni.resize(dW, dL);
    }

    public void setPrimitiveNodeSize(NodeInst ni, double width, double length, EditingPreferences ep) {
        if (ni.getFunction().isResistor()) {
            this.setPrimitiveNodeSizeLocal(ni, length, width);
        } else {
            this.setPrimitiveNodeSizeLocal(ni, width, length);
        }
    }

    public PortInst getTransistorGatePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorAltGatePort(NodeInst ni) {
        if (ni.getProto().getTechnology() == Schematics.tech()) {
            return ni.getPortInst(0);
        }
        return ni.getPortInst(2);
    }

    public PortInst getTransistorBasePort(NodeInst ni) {
        return ni.getPortInst(0);
    }

    public PortInst getTransistorSourcePort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorEmitterPort(NodeInst ni) {
        return ni.getPortInst(1);
    }

    public PortInst getTransistorDrainPort(NodeInst ni) {
        if (ni.getProto().getTechnology() == Schematics.tech()) {
            return ni.getPortInst(2);
        }
        if (ni.getNumPortInsts() < 4) {
            return null;
        }
        return ni.getPortInst(3);
    }

    public PortInst getTransistorCollectorPort(NodeInst ni) {
        return ni.getPortInst(2);
    }

    public PortInst getTransistorBiasPort(NodeInst ni) {
        if (ni.getNumPortInsts() > 4) {
            return ni.getPortInst(ni.getNumPortInsts() - 1);
        }
        return null;
    }

    public void setNoPrimitiveNodes() {
        this.userBits |= 0x20;
    }

    public boolean isNoPrimitiveNodes() {
        return (this.userBits & 0x20) != 0;
    }

    public void setDefaultOutline(NodeInst ni) {
    }

    public ERectangle getNodeInstBaseRectangle(NodeInst ni) {
        PrimitiveNode pn = (PrimitiveNode)ni.getProto();
        return pn.getBaseRectangle();
    }

    public Poly[] getShapeOfNode(NodeInst ni) {
        return this.getShapeOfNode(ni, false, false, null);
    }

    public Poly[] getShapeOfNode(NodeInst ni, boolean electrical, boolean reasonable, Layer.Function.Set onlyTheseLayers) {
        if (ni.isCellInstance()) {
            return null;
        }
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        return polyBuilder.getShapeArray(ni, electrical, reasonable, onlyTheseLayers);
    }

    public boolean isEasyShape(NodeInst ni, boolean explain) {
        return false;
    }

    public boolean isMultiCutInTechnology(MultiCutData mcd) {
        if (mcd == null) {
            return false;
        }
        return mcd.numCuts() > 1;
    }

    public MultiCutData getMultiCutData(NodeInst ni) {
        if (ni.isCellInstance()) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)ni.getProto();
        if (!pnp.isMulticut()) {
            return null;
        }
        return new MultiCutData(ni.getD(), ni.getTechPool());
    }

    public boolean isMultiCutCase(NodeInst ni) {
        MultiCutData data = this.getMultiCutData(ni);
        if (data == null) {
            return false;
        }
        return this.isMultiCutInTechnology(data);
    }

    public PrimitiveNode convertOldNodeName(String name) {
        return this.oldNodeNames.get(name);
    }

    public Map<String, PrimitiveNode> getOldNodeNames() {
        return new TreeMap<String, PrimitiveNode>(this.oldNodeNames);
    }

    public Poly getShapeOfPort(NodeInst ni, PrimitivePort pp) {
        Poly.Builder polyBuilder = Poly.threadLocalLambdaBuilder();
        return polyBuilder.getShape(ni, pp);
    }

    public PrimitivePort convertOldPortName(String portName, PrimitiveNode np) {
        PrimitivePort pp;
        int len = portName.length() - 4;
        if (len > 0 && portName.substring(len).equals("-bot") && (pp = (PrimitivePort)np.findPortProto(portName + "tom")) != null) {
            return pp;
        }
        if (np.getNumPorts() == 1) {
            return np.getPort(0);
        }
        return null;
    }

    public boolean isUniversalConnectivityPort(PrimitivePort pp) {
        return false;
    }

    private Setting makeParasiticSetting(String what, double factory) {
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        return this.getProjectSettings().makeDoubleSetting(what + "IN" + this.getTechName(), TECH_NODE, what, "Parasitic tab", techShortName + " " + what, factory);
    }

    private Setting makeParasiticSetting(String what, boolean factory) {
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        return this.getProjectSettings().makeBooleanSetting(what + "IN" + this.getTechName(), TECH_NODE, what, "Parasitic tab", techShortName + " " + what, factory);
    }

    public double getMinResistance() {
        return this.cacheMinResistance.getDouble();
    }

    public Setting getMinResistanceSetting() {
        return this.cacheMinResistance;
    }

    public double getMinCapacitance() {
        return this.cacheMinCapacitance.getDouble();
    }

    public Setting getMinCapacitanceSetting() {
        return this.cacheMinCapacitance;
    }

    public double getMaxSeriesResistance() {
        return this.cacheMaxSeriesResistance.getDouble();
    }

    public Setting getMaxSeriesResistanceSetting() {
        return this.cacheMaxSeriesResistance;
    }

    public boolean isGateIncluded() {
        return this.cacheIncludeGate.getBoolean();
    }

    public Setting getGateIncludedSetting() {
        return this.cacheIncludeGate;
    }

    public boolean isGroundNetIncluded() {
        return this.cacheIncludeGnd.getBoolean();
    }

    public Setting getGroundNetIncludedSetting() {
        return this.cacheIncludeGnd;
    }

    public double getGateLengthSubtraction() {
        return this.cacheGateLengthSubtraction.getDouble();
    }

    public Setting getGateLengthSubtractionSetting() {
        return this.cacheGateLengthSubtraction;
    }

    public void setFactoryParasitics(double minResistance, double minCapacitance) {
        this.cacheMinResistance = this.makeParasiticSetting("MininumResistance", minResistance);
        this.cacheMinCapacitance = this.makeParasiticSetting("MininumCapacitance", minCapacitance);
    }

    private Setting.Group getLESettingsNode() {
        return this.getProjectSettings().node("LogicalEffort");
    }

    private Setting makeLESetting(String what, double factory) {
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        return this.getLESettingsNode().makeDoubleSetting(what + "IN" + this.getTechName(), TECH_NODE, what, "Logical Effort tab", techShortName + " " + what, factory);
    }

    protected void setFactoryLESettings(double gateCapacitance, double wireRation, double diffAlpha) {
        this.cacheGateCapacitance = this.makeLESetting("GateCapacitance", gateCapacitance);
        this.cacheWireRatio = this.makeLESetting("WireRatio", wireRation);
        this.cacheDiffAlpha = this.makeLESetting("DiffAlpha", diffAlpha);
    }

    public double getGateCapacitance() {
        return this.cacheGateCapacitance.getDouble();
    }

    public Setting getGateCapacitanceSetting() {
        return this.cacheGateCapacitance;
    }

    public double getWireRatio() {
        return this.cacheWireRatio.getDouble();
    }

    public Setting getWireRatioSetting() {
        return this.cacheWireRatio;
    }

    public double getDiffAlpha() {
        return this.cacheDiffAlpha.getDouble();
    }

    public Setting getDiffAlphaSetting() {
        return this.cacheDiffAlpha;
    }

    public String[] getSpiceHeaderLevel1() {
        return this.spiceHeaderLevel1;
    }

    public void setSpiceHeaderLevel1(String[] lines) {
        this.spiceHeaderLevel1 = lines;
    }

    public String[] getSpiceHeaderLevel2() {
        return this.spiceHeaderLevel2;
    }

    public void setSpiceHeaderLevel2(String[] lines) {
        this.spiceHeaderLevel2 = lines;
    }

    public String[] getSpiceHeaderLevel3() {
        return this.spiceHeaderLevel3;
    }

    public void setSpiceHeaderLevel3(String[] lines) {
        this.spiceHeaderLevel3 = lines;
    }

    protected void setNonElectrical() {
        this.userBits |= 1;
    }

    public boolean isNonElectrical() {
        return (this.userBits & 1) != 0;
    }

    protected void setNonStandard() {
        this.userBits |= 8;
    }

    public boolean isNonStandard() {
        return (this.userBits & 8) != 0;
    }

    protected void setStaticTechnology() {
        this.userBits |= 0x10;
    }

    public boolean isStaticTechnology() {
        return (this.userBits & 0x10) != 0;
    }

    public TechId getId() {
        return this.techId;
    }

    public String getTechName() {
        return this.techId.techName;
    }

    public void setTechName(String techName) {
        throw new UnsupportedOperationException();
    }

    static boolean jelibSafeName(String str) {
        return TechId.jelibSafeName(str);
    }

    public String getTechShortName() {
        return this.techShortName;
    }

    protected void setTechShortName(String techShortName) {
        this.techShortName = techShortName;
    }

    public String getTechDesc() {
        return this.techDesc;
    }

    public void setTechDesc(String techDesc) {
        this.techDesc = techDesc;
    }

    public double getScale() {
        return this.cacheScale.getDouble();
    }

    public String getScaleVariableName() {
        return "ScaleFOR" + this.getTechName();
    }

    protected void setFactoryScale(double factory, boolean scaleRelevant) {
        this.scaleRelevant = scaleRelevant;
        String techShortName = this.getTechShortName();
        if (techShortName == null) {
            techShortName = this.getTechName();
        }
        this.cacheScale = this.getProjectSettings().makeDoubleSetting(this.getScaleVariableName(), TECH_NODE, "Scale", "Scale tab", techShortName + " scale", factory);
        this.cacheScale.setValidOption(this.isScaleRelevant());
    }

    public Setting getScaleSetting() {
        return this.cacheScale;
    }

    public boolean isScaleRelevant() {
        return this.scaleRelevant;
    }

    protected void setFactoryResolution(double factory) {
        this.factoryResolution = ECoord.fromLambdaRoundSizeGrid(factory);
    }

    public ECoord getFactoryResolution() {
        return this.factoryResolution;
    }

    public String getPrefFoundry() {
        return this.paramFoundry;
    }

    public Setting getPrefFoundrySetting() {
        return this.cacheFoundry;
    }

    protected Foundry findFoundry(String name) {
        if (name == null) {
            return null;
        }
        for (Foundry f : this.foundries) {
            Foundry.Type t = f.getType();
            if (!t.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public Iterator<Foundry> getFoundries() {
        return this.foundries.iterator();
    }

    protected void newFoundry(Foundry.Type mode, URL fileURL, String ... gdsLayers) {
        Foundry foundry = new Foundry(this, mode, fileURL, gdsLayers);
        this.foundries.add(foundry);
    }

    public Foundry getSelectedFoundry() {
        String foundryName = this.getPrefFoundry();
        Foundry f = this.findFoundry(foundryName);
        if (f != null) {
            return f;
        }
        if (this.foundries.size() > 0) {
            f = this.foundries.get(0);
            if (foundryName.length() > 0) {
                System.out.println("Foundry '" + foundryName + "' not available in Technology '" + this.getTechName() + "'. Setting '" + f.toString() + "' as foundry.");
            }
            return f;
        }
        return f;
    }

    public Map<Integer, List<Layer>> getLayersPerGDSNumber(Set<Integer> pinLayers) {
        assert (pinLayers != null);
        HashMap<Integer, List<Layer>> layerNames = new HashMap<Integer, List<Layer>>();
        for (Map.Entry<Layer, String> e : this.getGDSLayers().entrySet()) {
            Layer layer = e.getKey();
            String gdsName = e.getValue();
            GDSLayers gdsl = GDSLayers.parseLayerString(gdsName);
            for (GDSLayers.GDSLayerType type : GDSLayers.GDSLayerType.values()) {
                ArrayList<Layer> list;
                if (!gdsl.hasLayerType(type)) continue;
                int val = gdsl.getLayer(type);
                if (type == GDSLayers.GDSLayerType.PIN) {
                    pinLayers.add(val);
                }
                if ((list = (ArrayList<Layer>)layerNames.get(val)) == null) {
                    list = new ArrayList<Layer>();
                    layerNames.put(val, list);
                }
                list.add(layer);
            }
        }
        return layerNames;
    }

    public Map<Layer, String> getGDSLayers() {
        Foundry foundry = this.getSelectedFoundry();
        Map<Layer, String> gdsLayers = Collections.emptyMap();
        if (foundry != null) {
            gdsLayers = foundry.getGDSLayers();
        }
        return gdsLayers;
    }

    protected void setFactoryTransparentLayers(Color[] layers) {
        this.factoryTransparentColors = layers;
    }

    public Color[] getFactoryTransparentLayerColors() {
        return (Color[])this.factoryTransparentColors.clone();
    }

    public Color[] getTransparentLayerColors() {
        return UserInterfaceMain.getGraphicsPreferences().getTransparentLayerColors(this);
    }

    public int getNumTransparentLayers() {
        return UserInterfaceMain.getGraphicsPreferences().getNumTransparentLayers(this);
    }

    public void setColorMapFromLayers(Color[] layers) {
        UserInterfaceMain.setGraphicsPreferences(UserInterfaceMain.getGraphicsPreferences().withTransparentLayerColors(this, layers));
    }

    public XMLRules getFactoryDesignRules() {
        return this.makeFactoryDesignRules();
    }

    protected XMLRules makeFactoryDesignRules() {
        XMLRules rules = new XMLRules(this);
        Foundry foundry = this.getSelectedFoundry();
        List<DRCTemplate> rulesList = foundry.getRules();
        boolean pSubstrateProcess = User.isPSubstrateProcessLayoutTechnology();
        if (rulesList != null) {
            for (DRCTemplate rule : rulesList) {
                if (rule.ruleType == DRCTemplate.DRCRuleType.NODSIZ) continue;
                rules.loadDRCRules(this, foundry, rule, pSubstrateProcess);
            }
            for (DRCTemplate rule : rulesList) {
                if (rule.ruleType != DRCTemplate.DRCRuleType.NODSIZ) continue;
                rules.loadDRCRules(this, foundry, rule, pSubstrateProcess);
            }
        }
        return rules;
    }

    public static StringBuffer getRuleDifferences(XMLRules origRules, XMLRules newRules) {
        return new StringBuffer("");
    }

    public static StringBuffer getRuleDifferences_8_05(XMLRules origDRCRules, XMLRules newDRCRules) {
        StringBuffer changes = new StringBuffer();
        Technology tech = origDRCRules.getTechnology();
        XMLRules origRules = origDRCRules;
        XMLRules newRules = newDRCRules;
        for (int l1 = 0; l1 < tech.getNumLayers(); ++l1) {
            for (int l2 = 0; l2 <= l1; ++l2) {
                XMLRules.XMLRule rule2;
                int i = newRules.getRuleIndex(l2, l1);
                XMLRules.XMLRule rule1 = origRules.getRule(i, DRCTemplate.DRCRuleType.CONSPA);
                if (!rule1.equals(rule2 = newRules.getRule(i, DRCTemplate.DRCRuleType.CONSPA))) {
                    changes.append("c:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + rule2.values[0] + ";");
                }
                if (!rule1.ruleName.equals(rule2.ruleName)) {
                    changes.append("cr:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + rule2.ruleName + ";");
                }
                if (!(rule1 = origRules.getRule(i, DRCTemplate.DRCRuleType.UCONSPA)).equals(rule2 = newRules.getRule(i, DRCTemplate.DRCRuleType.UCONSPA))) {
                    changes.append("u:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + rule2.values[0] + ";");
                }
                if (rule1.ruleName.equals(rule2.ruleName)) continue;
                changes.append("ur:" + tech.getLayer(l1).getName() + "/" + tech.getLayer(l2).getName() + "=" + rule2.ruleName + ";");
            }
        }
        return changes;
    }

    public void setRuleVariables(XMLRules newRules) {
    }

    public Color[] getColorMap() {
        return UserInterfaceMain.getGraphicsPreferences().getColorMap(this);
    }

    public static Color[] makeColorMap(Color[] transparentColors) {
        int numEntries = 1 << transparentColors.length;
        Color[] map = new Color[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            int r = 200;
            int g = 200;
            int b = 200;
            boolean hasPrevious = false;
            for (int j = 0; j < transparentColors.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                Color layerColor = transparentColors[j];
                if (hasPrevious) {
                    double[] lastColor = new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0};
                    Technology.normalizeColor(lastColor);
                    double[] curColor = new double[]{(double)layerColor.getRed() / 255.0, (double)layerColor.getGreen() / 255.0, (double)layerColor.getBlue() / 255.0};
                    Technology.normalizeColor(curColor);
                    for (int k = 0; k < 3; ++k) {
                        int n = k;
                        curColor[n] = curColor[n] + lastColor[k];
                    }
                    Technology.normalizeColor(curColor);
                    r = (int)(curColor[0] * 255.0);
                    g = (int)(curColor[1] * 255.0);
                    b = (int)(curColor[2] * 255.0);
                    continue;
                }
                r = layerColor.getRed();
                g = layerColor.getGreen();
                b = layerColor.getBlue();
                hasPrevious = true;
            }
            map[i] = new Color(r, g, b);
        }
        return map;
    }

    private static void normalizeColor(double[] a) {
        double mag = Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
        if (mag < (double)1.0E-11f) {
            return;
        }
        a[0] = a[0] / mag;
        a[1] = a[1] / mag;
        a[2] = a[2] / mag;
    }

    public static Technology whatTechnology(NodeProto cell) {
        Technology tech = Technology.whatTechnology(cell, null, 0, 0, null);
        return tech;
    }

    public static Technology whatTechnology(NodeProto cellOrPrim, NodeProto[] nodeProtoList, int startNodeProto, int endNodeProto, ArcProto[] arcProtoList) {
        int i;
        if (cellOrPrim instanceof PrimitiveNode) {
            return ((PrimitiveNode)cellOrPrim).getTechnology();
        }
        Cell cell = (Cell)cellOrPrim;
        int maxTech = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            if (tech.getId().techIndex <= maxTech) continue;
            maxTech = tech.getId().techIndex;
        }
        int[] useCount = new int[++maxTech];
        for (i = 0; i < maxTech; ++i) {
            useCount[i] = 0;
        }
        if (nodeProtoList != null) {
            for (i = startNodeProto; i < endNodeProto; ++i) {
                Cell subCell;
                NodeProto np = nodeProtoList[i];
                if (np == null) continue;
                Technology nodeTech = np.getTechnology();
                if (np instanceof Cell && (subCell = (Cell)np).isIcon()) {
                    nodeTech = Schematics.tech();
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getId().techIndex;
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                Cell subCell;
                NodeInst ni = it2.next();
                NodeProto np = ni.getProto();
                Technology nodeTech = np.getTechnology();
                if (ni.isCellInstance() && (subCell = (Cell)np).isIcon()) {
                    nodeTech = Schematics.tech();
                }
                if (nodeTech == null) continue;
                int n = nodeTech.getId().techIndex;
                useCount[n] = useCount[n] + 1;
            }
        }
        if (arcProtoList != null) {
            for (ArcProto ap : arcProtoList) {
                if (ap == null) continue;
                int n = ap.getTechnology().getId().techIndex;
                useCount[n] = useCount[n] + 1;
            }
        } else {
            Iterator<ArcInst> it2 = cell.getArcs();
            while (it2.hasNext()) {
                ArcInst ai = (ArcInst)it2.next();
                ArcProto ap = ai.getProto();
                int n = ap.getTechnology().getId().techIndex;
                useCount[n] = useCount[n] + 1;
            }
        }
        int best = 0;
        Technology bestTech = null;
        int bestLayout = 0;
        Technology bestLayoutTech = null;
        Iterator<Technology> it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            Technology tech = it3.next();
            if (tech instanceof Generic) continue;
            if (useCount[tech.getId().techIndex] > best) {
                best = useCount[tech.getId().techIndex];
                bestTech = tech;
            }
            if (!tech.isLayout() || useCount[tech.getId().techIndex] <= bestLayout) continue;
            bestLayout = useCount[tech.getId().techIndex];
            bestLayoutTech = tech;
        }
        Technology retTech = null;
        if (cell.isIcon() || cell.getView().isTextView()) {
            if (useCount[Artwork.tech().getId().techIndex] > 0) {
                return Artwork.tech();
            }
            if (bestTech == null) {
                return Artwork.tech();
            }
            retTech = Artwork.tech();
        } else if (cell.isSchematic()) {
            if (useCount[Schematics.tech().getId().techIndex] > 0) {
                return Schematics.tech();
            }
            if (bestTech == null) {
                return Schematics.tech();
            }
            retTech = Schematics.tech();
        } else {
            retTech = Technology.getCurrent();
            if (!retTech.isLayout()) {
                retTech = Technology.findTechnology(User.getDefaultTechnology());
            }
            if (retTech == null) {
                retTech = Technology.getMocmosTechnology();
            }
        }
        if (bestLayoutTech != null) {
            retTech = bestLayoutTech;
        } else if (bestTech != null) {
            retTech = bestTech;
        }
        return retTech;
    }

    public boolean isLayout() {
        return !(this instanceof Artwork) && !(this instanceof GEM) && !(this instanceof Generic) && !(this instanceof Schematics);
    }

    public boolean isSchematics() {
        return this instanceof Schematics || this instanceof GEM;
    }

    @Override
    public int compareTo(Technology that) {
        return TextUtils.STRING_NUMBER_ORDER.compare(this.getTechName(), that.getTechName());
    }

    public String toString() {
        return "Technology " + this.getTechName();
    }

    private void check() {
        for (TechFactory.Param param : this.techFactory.getTechParams()) {
            String xmlPath = param.xmlPath;
            String xmlPrefix = this.getProjectSettings().getXmlPath();
            assert (xmlPath.startsWith(xmlPrefix));
            xmlPath = xmlPath.substring(xmlPrefix.length());
            Setting setting = this.getSetting(xmlPath);
            assert (setting.getXmlPath().equals(param.xmlPath));
            assert (setting.getPrefPath().equals(param.prefPath));
            assert (setting.getFactoryValue().equals(param.factoryValue));
        }
        for (ArcProto arcProto : this.arcs.values()) {
            arcProto.check();
        }
        if (!this.isNonStandard() && this.isScaleRelevant() && Job.getDebug()) {
            boolean bl;
            Enum fun;
            HashMap<Layer, ArcProto.Function> layToArcFunction = new HashMap<Layer, ArcProto.Function>();
            block2: for (ArcProto ap : this.arcs.values()) {
                for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                    Layer lay = ap.getLayer(i);
                    if (lay == null) {
                        System.out.println("ERROR: Technology " + this.getTechName() + ", arc " + ap.getName() + " - layer not found");
                        continue;
                    }
                    fun = lay.getFunction();
                    if (((Layer.Function)fun).isSubstrate()) continue;
                    ArcProto.Function aFun = ap.getFunction();
                    if (aFun.isDiffusion()) {
                        aFun = ArcProto.Function.DIFF;
                    }
                    if (aFun == ArcProto.Function.WELL && ((Layer.Function)fun).isDiff()) continue block2;
                    layToArcFunction.put(lay, aFun);
                    continue block2;
                }
            }
            Iterator<Layer> iterator = this.getLayers();
            while (iterator.hasNext()) {
                Layer lay = iterator.next();
                ArcProto.Function aFun = (ArcProto.Function)((Object)layToArcFunction.get(lay));
                if (aFun != null) continue;
                Layer.Function lFun = lay.getFunction();
                if (lFun.isDiff()) {
                    aFun = ArcProto.Function.DIFF;
                } else if (lFun.isPoly()) {
                    aFun = ArcProto.Function.getPoly(lFun.getLevel());
                } else if (lFun.isMetal()) {
                    aFun = ArcProto.Function.getMetal(lFun.getLevel());
                }
                if (lFun == null) continue;
                layToArcFunction.put(lay, aFun);
            }
            boolean bl2 = false;
            boolean foundPTrans = false;
            for (PrimitiveNode np : this.nodes.values()) {
                NodeLayer[] eLayers;
                fun = np.getFunction();
                if (((PrimitiveNode.Function)fun).isNTypeTransistor()) {
                    bl = true;
                }
                if (((PrimitiveNode.Function)fun).isPTypeTransistor()) {
                    foundPTrans = true;
                }
                if (((PrimitiveNode.Function)fun).isContact() || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.WELL) {
                    HashMap<ArcProto.Function, Layer> neededArcFunctions = new HashMap<ArcProto.Function, Layer>();
                    NodeLayer[] nodeLayers = np.getNodeLayers();
                    for (int i = 0; i < nodeLayers.length; ++i) {
                        Layer lay = nodeLayers[i].layer;
                        ArcProto.Function aFun = (ArcProto.Function)((Object)layToArcFunction.get(lay));
                        if (aFun == ArcProto.Function.WELL || aFun == null) continue;
                        neededArcFunctions.put(aFun, lay);
                    }
                    HashSet<ArcProto.Function> foundArcFunctions = new HashSet<ArcProto.Function>();
                    Iterator<PrimitivePort> it2 = np.getPrimitivePorts();
                    while (it2.hasNext()) {
                        PrimitivePort pp = it2.next();
                        ArcProto[] connections = pp.getConnections();
                        for (int i = 0; i < connections.length; ++i) {
                            ArcProto ap = connections[i];
                            ArcProto.Function aFun = ap.getFunction();
                            if (aFun == ArcProto.Function.WELL) continue;
                            if (aFun.isDiffusion()) {
                                aFun = ArcProto.Function.DIFF;
                            }
                            if (ap.getTechnology() != this || neededArcFunctions.get((Object)aFun) != null) {
                                foundArcFunctions.add(aFun);
                                continue;
                            }
                            if (aFun.isDiffusion() && fun == PrimitiveNode.Function.WELL) continue;
                            System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + " connects to " + ap.getName() + " but probably should not because that layer is not in the node");
                        }
                    }
                    for (ArcProto.Function aFun : neededArcFunctions.keySet()) {
                        if (foundArcFunctions.contains((Object)aFun) || aFun.isDiffusion() && fun == PrimitiveNode.Function.WELL) continue;
                        if (aFun.isPoly()) {
                            boolean found = false;
                            for (ArcProto.Function f : foundArcFunctions) {
                                if (!f.isPoly()) continue;
                                found = f != aFun;
                            }
                            if (found) continue;
                        }
                        System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + " should connect to layer " + neededArcFunctions.get((Object)aFun) + " because that layer is in the node");
                    }
                    continue;
                }
                if (((PrimitiveNode.Function)fun).isCapacitor()) {
                    if (np.getNumPorts() >= 2) continue;
                    System.out.println("ERROR: Technology " + this.getTechName() + ", node " + np.getName() + " must have at least two ports if defined as capacitor");
                    continue;
                }
                if (!((PrimitiveNode.Function)fun).isFET()) continue;
                ArrayList<PrimitivePort> traPorts = new ArrayList<PrimitivePort>();
                Iterator<PrimitivePort> it3 = np.getPrimitivePorts();
                while (it3.hasNext()) {
                    traPorts.add(it3.next());
                }
                if (traPorts.size() != 4 && traPorts.size() != 5) {
                    System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + " should have 4 or 5 ports but has " + traPorts.size());
                } else {
                    PrimitivePort pLeft = (PrimitivePort)traPorts.get(0);
                    PrimitivePort dTop = (PrimitivePort)traPorts.get(1);
                    PrimitivePort pRight = (PrimitivePort)traPorts.get(2);
                    PrimitivePort dBot = (PrimitivePort)traPorts.get(3);
                    if (!this.getTechName().startsWith("tft")) {
                        if (!this.connectsToPoly(pLeft)) {
                            System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", first port (" + pLeft.getName() + ") should connect to Polysilicon");
                        }
                        if (!this.connectsToActive(dTop)) {
                            System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", second port (" + dTop.getName() + ") should connect to Active");
                        }
                        if (!this.connectsToPoly(pRight)) {
                            System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", third port (" + pRight.getName() + ") should connect to Polysilicon");
                        }
                        if (!this.connectsToActive(dBot)) {
                            System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", fourth port (" + dBot.getName() + ") should connect to Active");
                        }
                    }
                    if (pLeft.getTopology() != pRight.getTopology()) {
                        System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + " should connect its Polysilicon ports");
                    }
                    if (dTop.getTopology() == dBot.getTopology()) {
                        System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + " should not connect its Active ports to each other");
                    }
                    if (pLeft.getTopology() == dBot.getTopology() || pLeft.getTopology() == dTop.getTopology()) {
                        System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + " should not connect its Active ports to its Polysilicon ports");
                    }
                }
                if ((eLayers = np.getElectricalLayers()) == null) continue;
                boolean foundPort1 = false;
                boolean foundPort3 = false;
                int portSize = traPorts.size();
                for (int i = 0; i < eLayers.length; ++i) {
                    int portNum;
                    if (!eLayers[i].getLayer().getFunction().isDiff() || (portNum = eLayers[i].getPortNum()) < 0) continue;
                    if (portNum == 1) {
                        foundPort1 = true;
                        continue;
                    }
                    if (portNum == 3) {
                        foundPort3 = true;
                        continue;
                    }
                    System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", Active layer connected to port " + ((PrimitivePort)traPorts.get(portNum)).getName());
                }
                if (!foundPort1) {
                    System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", no Active layer is connected to port " + (portSize > 1 ? ((PrimitivePort)traPorts.get(1)).getName() : ""));
                }
                if (foundPort3) continue;
                System.out.println("WARNING: Technology " + this.getTechName() + ", node " + np.getName() + ", no Active layer is connected to port " + (portSize > 3 ? ((PrimitivePort)traPorts.get(3)).getName() : ""));
            }
            if (bl != foundPTrans && !this.getTechName().equals("nmos") && !this.getTechName().equals("tft")) {
                String has = bl ? "N" : "P";
                String hasnt = bl ? "P" : "N";
                System.out.println("WARNING: Technology " + this.getTechName() + " has " + has + " transistors but has no " + hasnt + " transistors");
            }
        }
    }

    private boolean connectsToPoly(PrimitivePort pp) {
        ArcProto[] connections = pp.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            if (!connections[i].getFunction().isPoly()) continue;
            return true;
        }
        return false;
    }

    private boolean connectsToActive(PrimitivePort pp) {
        ArcProto[] connections = pp.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            if (!connections[i].getFunction().isDiffusion()) continue;
            return true;
        }
        return false;
    }

    public List<NodeProto> getMetalContactCluster(Layer l1, Layer l2) {
        ArrayList<NodeProto> list = new ArrayList<NodeProto>();
        Xml.MenuPalette menu = this.xmlTech.menuPalette;
        for (List<?> objList : menu.menuBoxes) {
            for (Object obj : objList) {
                PrimitiveNode np;
                if (!(obj instanceof Xml.MenuNodeInst)) continue;
                Xml.MenuNodeInst menuItem = (Xml.MenuNodeInst)obj;
                if (!menuItem.function.isContact() || !((np = this.findNodeProto(((Xml.MenuNodeInst)obj).protoName)) instanceof PrimitiveNode)) continue;
                PrimitiveNode pn = np;
                boolean found1 = false;
                boolean found2 = false;
                for (NodeLayer l : pn.getNodeLayers()) {
                    if (l.getLayer() == l1) {
                        found1 = true;
                    }
                    if (l.getLayer() == l2) {
                        found2 = true;
                    }
                    if (found1 && found2) break;
                }
                if (!found1 || !found2) continue;
                list.add(pn);
            }
        }
        return list;
    }

    protected void loadFactoryMenuPalette(URL menuURL) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(menuURL.openConnection().getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            this.factoryMenuPalette = this.parseComponentMenuXML(sb.toString());
        }
        catch (IOException e) {
            System.out.println("Error parsing XML component menu data");
            e.printStackTrace();
        }
    }

    public Xml.MenuPalette parseComponentMenuXML(String nodeGroupXML) {
        ArrayList<Xml.PrimitiveNodeGroup> xmlNodeGroups = new ArrayList<Xml.PrimitiveNodeGroup>();
        ArrayList<Xml.PrimitiveNode> xmlPureLayerNodes = new ArrayList<Xml.PrimitiveNode>();
        HashSet<PrimitiveNodeGroup> groupsDone = new HashSet<PrimitiveNodeGroup>();
        Iterator<PrimitiveNode> it = this.getNodes();
        while (it.hasNext()) {
            Xml.PrimitiveNodeGroup ng;
            PrimitiveNode pnp = it.next();
            if (pnp.getFunction() == PrimitiveNode.Function.NODE) {
                Xml.PrimitiveNode n = new Xml.PrimitiveNode();
                n.name = pnp.getName();
                n.function = PrimitiveNode.Function.NODE;
                xmlPureLayerNodes.add(n);
                continue;
            }
            PrimitiveNodeGroup group = pnp.getPrimitiveNodeGroup();
            if (group != null) {
                if (groupsDone.contains(group)) continue;
                ng = new Xml.PrimitiveNodeGroup();
                for (PrimitiveNode pn : group.getNodes()) {
                    Xml.PrimitiveNode n = new Xml.PrimitiveNode();
                    n.name = pn.getName();
                    ng.nodes.add(n);
                }
                xmlNodeGroups.add(ng);
                groupsDone.add(group);
                continue;
            }
            ng = new Xml.PrimitiveNodeGroup();
            ng.isSingleton = true;
            Xml.PrimitiveNode n = new Xml.PrimitiveNode();
            n.name = pnp.getName();
            ng.nodes.add(n);
            xmlNodeGroups.add(ng);
        }
        ArrayList<Xml.ArcProto> xmlArcs = new ArrayList<Xml.ArcProto>();
        for (ArcProto ap : this.arcs.values()) {
            Xml.ArcProto xap = new Xml.ArcProto();
            xap.name = ap.getName();
            xmlArcs.add(xap);
        }
        return Xml.parseComponentMenuXMLTechEdit(nodeGroupXML, xmlNodeGroups, xmlArcs, xmlPureLayerNodes);
    }

    public Xml.MenuPalette getFactoryMenuPalette() {
        if (this.factoryMenuPalette == null) {
            this.makeDummyFactoryMenuPalette();
        }
        assert (this.factoryMenuPalette != null);
        return this.factoryMenuPalette;
    }

    private void makeDummyFactoryMenuPalette() {
        List<Xml.ArcProto> list;
        ArrayList<List<Object>> things = new ArrayList<List<Object>>();
        Iterator<ArcProto> it = this.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (ap.isNotUsed()) continue;
            Xml.ArcProto xap = new Xml.ArcProto();
            xap.name = ap.getName();
            list = Collections.singletonList(xap);
            things.add(list);
        }
        HashSet<PrimitiveNodeGroup> groups = new HashSet<PrimitiveNodeGroup>();
        Iterator<PrimitiveNode> it2 = this.getNodes();
        while (it2.hasNext()) {
            PrimitiveNode np = it2.next();
            if (np.isNotUsed() || np.getFunction() == PrimitiveNode.Function.NODE) continue;
            if (np.group != null) {
                if (groups.contains(np.group)) continue;
                groups.add(np.group);
                list = new ArrayList<Xml.ArcProto>();
                for (PrimitiveNode gnp : np.group.getNodes()) {
                    Xml.MenuNodeInst xnp = new Xml.MenuNodeInst();
                    xnp.protoName = gnp.getName();
                    xnp.function = gnp.getFunction();
                    list.add((Xml.ArcProto)((Object)xnp));
                }
                things.add(list);
                continue;
            }
            list = new ArrayList<Xml.ArcProto>();
            Xml.PrimitiveNode xpn = new Xml.PrimitiveNode();
            xpn.name = np.getName();
            list.add((Xml.ArcProto)((Object)xpn));
            things.add(list);
        }
        things.add(Collections.singletonList(SPECIALMENUPURE));
        things.add(Collections.singletonList(SPECIALMENUMISC));
        things.add(Collections.singletonList(SPECIALMENUCELL));
        int columns = (things.size() + 13) / 14;
        int rows = (things.size() + columns - 1) / columns;
        while (things.size() < columns * rows) {
            things.add(null);
        }
        this.factoryMenuPalette = new Xml.MenuPalette();
        this.factoryMenuPalette.numColumns = columns;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                List list2 = (List)things.get(col * rows + row);
                this.factoryMenuPalette.menuBoxes.add(list2);
            }
        }
    }

    public double[] getSpacingDistances(Poly poly1, Poly poly2) {
        double size1 = poly1.getMinSize();
        double size2 = poly2.getMinSize();
        double length = 0.0;
        double wideS = size1 > size2 ? size1 : size2;
        double[] results = new double[]{wideS, length};
        return results;
    }

    public XMLRules getCachedRules() {
        return this.cachedRules;
    }

    public void setCachedRules(XMLRules rules) {
        this.cachedRules = rules;
    }

    public boolean isValidVTPolyRule(DRCTemplate theRule) {
        return false;
    }

    public Setting makeBooleanSetting(String name, String location, String description, String xmlName, boolean factory) {
        return this.getProjectSettings().makeBooleanSetting(name, TECH_NODE, xmlName, location, description, factory);
    }

    public Setting makeIntSetting(String name, String location, String description, String xmlName, int factory, String ... trueMeaning) {
        return this.getProjectSettings().makeIntSetting(name, TECH_NODE, xmlName, location, description, factory, trueMeaning);
    }

    public Setting makeDoubleSetting(String name, String location, String description, String xmlName, double factory) {
        return this.getProjectSettings().makeDoubleSetting(name, TECH_NODE, xmlName, location, description, factory);
    }

    public Setting makeStringSetting(String name, String location, String description, String xmlName, String factory) {
        return this.getProjectSettings().makeStringSetting(name, TECH_NODE, xmlName, location, description, factory);
    }

    public Setting.Group getProjectSettings() {
        return this.settings;
    }

    public Setting.RootGroup getProjectSettingsRoot() {
        return this.rootSettings;
    }

    public Setting getSetting(String xmlPath) {
        return this.getProjectSettings().getSetting(xmlPath);
    }

    public Setting getSetting(TechFactory.Param param) {
        String xmlPath = param.xmlPath;
        if (xmlPath.startsWith(this.settings.xmlPath)) {
            return this.getSetting(xmlPath.substring(this.settings.xmlPath.length()));
        }
        return null;
    }

    static {
        diffLayers = new Layer.Function.Set(Layer.Function.DIFFP, Layer.Function.DIFFN);
    }

    public class SizeCorrector {
        public final HashMap<ArcProtoId, ECoord> arcExtends = new HashMap();
        public final HashMap<PrimitiveNodeId, EPoint> nodeExtends = new HashMap();

        private SizeCorrector(Version version, boolean isJelib) {
            Serializable correction;
            int techVersion = 0;
            if (isJelib) {
                if (version.compareTo(DISK_VERSION_2) >= 0) {
                    techVersion = 2;
                } else if (version.compareTo(DISK_VERSION_1) >= 0) {
                    techVersion = 1;
                }
            }
            for (ArcProto ap : Technology.this.arcs.values()) {
                correction = ECoord.ZERO;
                switch (techVersion) {
                    case 0: {
                        correction = ap.getBaseExtend().add(ECoord.fromLambdaRoundGrid(0.5 * ap.getLambdaElibWidthOffset()));
                        break;
                    }
                    case 1: {
                        correction = ap.getBaseExtend();
                    }
                }
                this.arcExtends.put(ap.getId(), (ECoord)correction);
            }
            for (PrimitiveNode pn : Technology.this.nodes.values()) {
                correction = techVersion == 2 ? EPoint.ORIGIN : pn.getSizeCorrector(techVersion);
                this.nodeExtends.put(pn.getId(), (EPoint)correction);
            }
        }

        public boolean isIdentity() {
            for (ECoord arcExtend : this.arcExtends.values()) {
                if (arcExtend.signum() == 0) continue;
                return false;
            }
            for (EPoint nodeExtend : this.nodeExtends.values()) {
                if (nodeExtend.getX() == 0.0 && nodeExtend.getY() == 0.0) continue;
                return false;
            }
            return true;
        }

        public long getExtendFromDisk(ArcProto ap, double width) {
            return DBMath.lambdaToGrid(0.5 * width) - this.arcExtends.get(ap.getId()).getGrid();
        }

        public long getExtendToDisk(ImmutableArcInst a) {
            return a.getGridExtendOverMin() + this.arcExtends.get(a.protoId).getGrid();
        }

        public long getWidthToDisk(ImmutableArcInst a) {
            return 2L * this.getExtendToDisk(a);
        }

        public EPoint getSizeFromDisk(PrimitiveNode pn, EPoint size) {
            EPoint correction = this.nodeExtends.get(pn.getId());
            return EPoint.fromGrid(size.getGridX() - 2L * correction.getGridX(), size.getGridY() - 2L * correction.getGridY());
        }

        public EPoint getSizeToDisk(ImmutableNodeInst n) {
            EPoint size = n.size;
            EPoint correction = this.nodeExtends.get(n.protoId);
            if (!correction.equals(EPoint.ORIGIN)) {
                size = EPoint.fromLambda(size.getLambdaX() + 2.0 * correction.getLambdaX(), size.getLambdaY() + 2.0 * correction.getLambdaY());
            }
            return size;
        }
    }

    private static class TechnologyKey
    extends EObjectInputStream.Key<Technology> {
        public TechnologyKey() {
        }

        private TechnologyKey(Technology tech) {
            super(tech);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, Technology tech) throws IOException {
            TechId techId = tech.getId();
            if (techId.idManager != out.getIdManager()) {
                throw new NotSerializableException(tech + " from other IdManager");
            }
            if (out.getDatabase().getTechPool().getTech(techId) != tech) {
                throw new NotSerializableException(tech + " not linked");
            }
            out.writeInt(techId.techIndex);
        }

        @Override
        public Technology readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int techIndex = in.readInt();
            TechId techId = in.getIdManager().getTechId(techIndex);
            Technology tech = in.getDatabase().getTech(techId);
            if (tech == null) {
                throw new InvalidObjectException(techId + " not linked");
            }
            return tech;
        }
    }

    public static class ArcLayer {
        private final Layer layer;
        private final Poly.Type style;
        private ECoord extend;

        public ArcLayer(Layer layer, double arcLayerWidth, Poly.Type style) {
            this(layer, style, 0.5 * arcLayerWidth);
        }

        public ArcLayer(Layer layer, Poly.Type style, double lambdaExtend) {
            this.layer = layer;
            this.style = style;
            this.extend = ECoord.fromLambdaRoundGrid(lambdaExtend);
            if (this.extend.getGrid() < 0L || this.extend.getGrid() >= 0xFFFFFFFL) {
                throw new IllegalArgumentException("extend=" + this.extend);
            }
        }

        public Layer getLayer() {
            return this.layer;
        }

        public ECoord getExtend() {
            return this.extend;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        void dump(PrintWriter out) {
            out.println("\t\tarcLayer layer=" + this.layer.getName() + " style=" + this.style.name() + " extend=" + this.extend);
        }

        Xml.ArcLayer makeXml() {
            Xml.ArcLayer al = new Xml.ArcLayer();
            al.layer = this.layer.getName();
            al.style = this.style;
            al.extend.addLambda(this.extend.getLambda());
            return al;
        }
    }

    public static class TechPoint
    implements Serializable {
        private final EdgeH x;
        private final EdgeV y;

        public TechPoint(EdgeH x, EdgeV y) {
            if (x == null || y == null) {
                throw new NullPointerException();
            }
            this.x = x;
            this.y = y;
        }

        public static TechPoint[] makeCenterBox() {
            return new TechPoint[]{new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0)), new TechPoint(EdgeH.fromCenter(0.0), EdgeV.fromCenter(0.0))};
        }

        public static TechPoint[] makeIndentedFromCenter(double amountX, double amountY) {
            return new TechPoint[]{new TechPoint(EdgeH.fromCenter(-amountX), EdgeV.fromCenter(-amountY)), new TechPoint(EdgeH.fromCenter(amountX), EdgeV.fromCenter(amountY))};
        }

        public EdgeH getX() {
            return this.x;
        }

        public TechPoint withX(EdgeH x) {
            if (x.equals(this.x)) {
                return this;
            }
            return new TechPoint(x, this.y);
        }

        public EdgeV getY() {
            return this.y;
        }

        public TechPoint withY(EdgeV y) {
            if (y.equals(this.y)) {
                return this;
            }
            return new TechPoint(this.x, y);
        }
    }

    public static class NodeLayer {
        private final Layer layer;
        private final int portNum;
        private final Poly.Type style;
        private final int representation;
        private final TechPoint[] points;
        private String message;
        private TextDescriptor descriptor;
        private ECoord lWidth;
        private ECoord rWidth;
        private ECoord extentT;
        private ECoord extendB;
        private ECoord cutSizeX = ECoord.ZERO;
        private ECoord cutSizeY = ECoord.ZERO;
        private ECoord cutSep1D = ECoord.ZERO;
        private ECoord cutSep2D = ECoord.ZERO;
        public static final int POINTS = 0;
        public static final int BOX = 1;
        public static final int MULTICUTBOX = 3;
        public static final Variable.Key CUT_SPACING = Variable.newKey("CUT_spacing");
        public static final Variable.Key CUT_ALIGNMENT = Variable.newKey("CUT_alignment");
        public static final Variable.Key METAL_OFFSETS = Variable.newKey("METAL_offsets");
        public static final Variable.Key CARBON_NANOTUBE_COUNT = Variable.newKey("CARBON_NANOTUBE_count");
        public static final Variable.Key CARBON_NANOTUBE_PITCH = Variable.newKey("CARBON_NANOTUBE_pitch");
        public static final int MULTICUT_CENTERED = 0;
        public static final int MULTICUT_SPREAD = 1;
        public static final int MULTICUT_CORNER = 2;

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = (TechPoint[])points.clone();
            this.descriptor = TextDescriptor.EMPTY;
            this.extentT = this.extendB = ECoord.ZERO;
            this.rWidth = this.extendB;
            this.lWidth = this.extendB;
        }

        public NodeLayer(Layer layer, int portNum, Poly.Type style, int representation, TechPoint[] points, ECoord lWidth, ECoord rWidth, ECoord extentT, ECoord extendB) {
            this.layer = layer;
            this.portNum = portNum;
            this.style = style;
            this.representation = representation;
            this.points = (TechPoint[])points.clone();
            this.descriptor = TextDescriptor.EMPTY;
            this.lWidth = lWidth;
            this.rWidth = rWidth;
            this.extentT = extentT;
            this.extendB = extendB;
        }

        public NodeLayer(NodeLayer node) {
            this.layer = node.getLayer();
            this.portNum = node.getPortNum();
            this.style = node.getStyle();
            this.representation = node.getRepresentation();
            this.descriptor = TextDescriptor.EMPTY;
            this.points = (TechPoint[])node.getPoints().clone();
            this.extentT = this.extendB = ECoord.ZERO;
            this.rWidth = this.extendB;
            this.lWidth = this.extendB;
        }

        public static NodeLayer makeMulticut(Layer layer, int portNum, Poly.Type style, TechPoint[] techPoints, double sizeX, double sizeY, double sep1d, double sep2d) {
            NodeLayer nl = new NodeLayer(layer, portNum, style, 3, techPoints);
            nl.cutSizeX = ECoord.fromLambdaRoundGrid(sizeX);
            nl.cutSizeY = ECoord.fromLambdaRoundGrid(sizeY);
            nl.cutSep1D = ECoord.fromLambdaRoundGrid(sep1d);
            nl.cutSep2D = ECoord.fromLambdaRoundGrid(sep2d);
            return nl;
        }

        public static NodeLayer makeMulticut(Layer layer, int portNum, Poly.Type style, TechPoint[] techPoints, ECoord sizeX, ECoord sizeY, ECoord sep1d, ECoord sep2d) {
            NodeLayer nl = new NodeLayer(layer, portNum, style, 3, techPoints);
            nl.cutSizeX = sizeX;
            nl.cutSizeY = sizeY;
            nl.cutSep1D = sep1d;
            nl.cutSep2D = sep2d;
            return nl;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public int getPortNum() {
            return this.portNum;
        }

        public PrimitivePort getPort(PrimitiveNode pn) {
            return this.portNum >= 0 ? pn.getPort(this.portNum) : null;
        }

        public Poly.Type getStyle() {
            return this.style;
        }

        public int getRepresentation() {
            return this.representation;
        }

        public static String getRepresentationName(int rep) {
            if (rep == 0) {
                return "points";
            }
            if (rep == 1) {
                return "box";
            }
            if (rep == 3) {
                return "multi-cut-box";
            }
            return "?";
        }

        public TechPoint[] getPoints() {
            return this.points;
        }

        public EdgeH getLeftEdge() {
            return this.points[0].getX();
        }

        public EdgeV getBottomEdge() {
            return this.points[0].getY();
        }

        public EdgeH getRightEdge() {
            return this.points[1].getX();
        }

        public EdgeV getTopEdge() {
            return this.points[1].getY();
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public TextDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(TextDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public ECoord getSerpentineLWidth() {
            return this.lWidth;
        }

        public void setSerpentineLWidth(double lWidth) {
            this.lWidth = ECoord.fromLambdaRoundGrid(lWidth);
        }

        public ECoord getSerpentineRWidth() {
            return this.rWidth;
        }

        public void setSerpentineRWidth(double rWidth) {
            this.rWidth = ECoord.fromLambdaRoundGrid(rWidth);
        }

        public ECoord getSerpentineExtentT() {
            return this.extentT;
        }

        public void setSerpentineExtentT(double extentT) {
            this.extentT = ECoord.fromLambdaRoundGrid(extentT);
        }

        public ECoord getSerpentineExtentB() {
            return this.extendB;
        }

        public void setSerpentineExtentB(double extendB) {
            this.extendB = ECoord.fromLambdaRoundGrid(extendB);
        }

        public ECoord getMulticutSizeX() {
            return this.cutSizeX;
        }

        public ECoord getMulticutSizeY() {
            return this.cutSizeY;
        }

        public ECoord getMulticutSep1D() {
            return this.cutSep1D;
        }

        public ECoord getMulticutSep2D() {
            return this.cutSep2D;
        }

        void dump(PrintWriter out, EPoint correction, boolean isSerp) {
            out.println("\tlayer=" + this.getLayer().getName() + " port=" + this.getPortNum() + " style=" + this.getStyle().name() + " repr=" + this.getRepresentation());
            if (this.getMessage() != null) {
                TextDescriptor td = this.getDescriptor();
                out.println("\t\tmessage=\"" + this.getMessage() + "\" td=" + Long.toHexString(td.lowLevelGet()) + " colorIndex=" + td.getColorIndex() + " disp=" + td.isDisplay());
            }
            if (this.getMulticutSizeX().signum() != 0 || this.getMulticutSizeY().signum() != 0 || this.getMulticutSep1D().signum() != 0 || this.getMulticutSep2D().signum() != 0) {
                out.println("\t\tmultiSizeX=" + this.getMulticutSizeX() + " multiSizeY=" + this.getMulticutSizeY() + " multiSep=" + this.getMulticutSep1D() + " multiSpe2D=" + this.getMulticutSep2D());
            }
            if (isSerp) {
                out.println("\t\tLWidth=" + this.getSerpentineLWidth() + " rWidth=" + this.getSerpentineRWidth() + " bExtend=" + this.getSerpentineExtentB() + " tExtend=" + this.getSerpentineExtentT());
            }
            for (TechPoint p : this.getPoints()) {
                out.println("\t\tpoint xm=" + p.getX().getMultiplier() + " xa=" + DBMath.round(p.getX().getAdder().getLambda() - p.getX().getMultiplier() * correction.getLambdaX()) + " ym=" + p.getY().getMultiplier() + " ya=" + DBMath.round(p.getY().getAdder().getLambda() - p.getY().getMultiplier() * correction.getLambdaY()));
            }
        }

        public Xml.NodeLayer makeXml(boolean isSerp, boolean inLayers, boolean inElectricalLayers, Map<Object, Map<String, Object>> additionalAttributes) {
            Xml.NodeLayer nld = new Xml.NodeLayer();
            nld.layer = this.getLayer().getName();
            nld.style = this.getStyle();
            nld.portNum = this.getPortNum();
            nld.inLayers = inLayers;
            nld.inElectricalLayers = inElectricalLayers;
            nld.representation = this.getRepresentation();
            TechPoint[] points = this.getPoints();
            if (nld.representation == 1 || nld.representation == 3) {
                nld.lx.k = points[0].getX().getMultiplier() * 2.0;
                nld.lx.addLambda(DBMath.round(points[0].getX().getAdder().getLambda()));
                nld.hx.k = points[1].getX().getMultiplier() * 2.0;
                nld.hx.addLambda(DBMath.round(points[1].getX().getAdder().getLambda()));
                nld.ly.k = points[0].getY().getMultiplier() * 2.0;
                nld.ly.addLambda(DBMath.round(points[0].getY().getAdder().getLambda()));
                nld.hy.k = points[1].getY().getMultiplier() * 2.0;
                nld.hy.addLambda(DBMath.round(points[1].getY().getAdder().getLambda()));
            } else {
                for (TechPoint p : points) {
                    nld.techPoints.add(p);
                }
            }
            if (nld.representation == 3) {
                nld.sizex = this.getMulticutSizeX().getLambda();
                nld.sizey = this.getMulticutSizeY().getLambda();
                nld.sep1d = this.getMulticutSep1D().getLambda();
                nld.sep2d = this.getMulticutSep2D().getLambda();
            }
            if (isSerp) {
                nld.lWidth = this.getSerpentineLWidth().getLambda();
                nld.rWidth = this.getSerpentineRWidth().getLambda();
                nld.tExtent = this.getSerpentineExtentT().getLambda();
                nld.bExtent = this.getSerpentineExtentB().getLambda();
            }
            if (additionalAttributes != null && this.getMessage() != null) {
                LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
                attrs.put("message", this.getMessage());
                attrs.put("relSize", this.getDescriptor().getSize().getSize());
                additionalAttributes.put(nld, attrs);
            }
            return nld;
        }
    }

    public static class MultiCutData {
        private long cutSizeX;
        private long cutSizeY;
        private long cutSep1D;
        private long cutSep2D;
        private int cutsX;
        private int cutsY;
        private int cutsTotal;

        public MultiCutData(ImmutableNodeInst niD, TechPool techPool) {
            this.calculateInternalData(niD, techPool.getPrimitiveNode((PrimitiveNodeId)niD.protoId).findMulticut());
        }

        private void calculateInternalData(ImmutableNodeInst niD, NodeLayer cutLayer) {
            double spacingD;
            Variable var;
            EPoint size = niD.size;
            assert (cutLayer.representation == 3);
            long gridWidth = size.getGridX();
            long gridHeight = size.getGridY();
            TechPoint[] techPoints = cutLayer.points;
            long lx = techPoints[0].getX().getAdder().getGrid() + (long)((double)gridWidth * techPoints[0].getX().getMultiplier());
            long hx = techPoints[1].getX().getAdder().getGrid() + (long)((double)gridWidth * techPoints[1].getX().getMultiplier());
            long ly = techPoints[0].getY().getAdder().getGrid() + (long)((double)gridHeight * techPoints[0].getY().getMultiplier());
            long hy = techPoints[1].getY().getAdder().getGrid() + (long)((double)gridHeight * techPoints[1].getY().getMultiplier());
            this.cutSizeX = cutLayer.cutSizeX.getGrid();
            this.cutSizeY = cutLayer.cutSizeY.getGrid();
            this.cutSep1D = cutLayer.cutSep1D.getGrid();
            this.cutSep2D = cutLayer.cutSep2D.getGrid();
            if (!niD.isEasyShape() && (var = niD.getVar(NodeLayer.CUT_SPACING)) != null && (spacingD = VarContext.objectToDouble(var.getObject(), -1.0)) != -1.0) {
                this.cutSep1D = this.cutSep2D = DBMath.lambdaToGrid(spacingD);
            }
            long cutAreaWidth = hx - lx;
            long cutAreaHeight = hy - ly;
            int oneDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep1D));
            int oneDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep1D));
            this.cutsX = oneDcutsX;
            this.cutsY = oneDcutsY;
            if (this.cutsX > 1 && this.cutsY > 1) {
                int twoDcutsX = 1 + (int)(cutAreaWidth / (this.cutSizeX + this.cutSep2D));
                int twoDcutsY = 1 + (int)(cutAreaHeight / (this.cutSizeY + this.cutSep2D));
                this.cutsX = twoDcutsX;
                this.cutsY = twoDcutsY;
                if (this.cutsX == 1 || this.cutsY == 1) {
                    if (cutAreaWidth > cutAreaHeight) {
                        this.cutsX = oneDcutsX;
                    } else {
                        this.cutsY = oneDcutsY;
                    }
                }
            }
            if (this.cutsX <= 0) {
                this.cutsX = 1;
            }
            if (this.cutsY <= 0) {
                this.cutsY = 1;
            }
            this.cutsTotal = this.cutsX * this.cutsY;
        }

        public int numCuts() {
            return this.cutsTotal;
        }

        public int numCutsX() {
            return this.cutsX;
        }

        public int numCutsY() {
            return this.cutsY;
        }

        public long getCutSep1D() {
            return this.cutSep1D;
        }

        public long getCutSep2D() {
            return this.cutSep2D;
        }

        public long getCutSizeX() {
            return this.cutSizeX;
        }

        public long getCutSizeY() {
            return this.cutSizeY;
        }
    }

    public static class ExtraField
    implements Serializable {
        private String primitiveName;
        private Variable.Key varKey;
        private String description;

        public ExtraField(PrimitiveNode np, Variable.Key key, String desc) {
            this.primitiveName = np.getName();
            this.varKey = key;
            this.description = desc;
            List<ExtraField> fields = extraFields.get(np);
            if (fields == null) {
                fields = new ArrayList<ExtraField>();
                extraFields.put(np, fields);
            }
            fields.add(this);
        }

        public String getPrimName() {
            return this.primitiveName;
        }

        public Variable.Key getKey() {
            return this.varKey;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

