/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk.event;

/**
 * @author Ismael Juma <ismael@juma.me.uk>
 */

import org.gnu.gdk.DragContext;
import org.gnu.glib.EventType;
import org.gnu.gtk.Widget;

public class DragEvent extends GtkEvent {
    private final DragContext context;

    public DragEvent(Widget source, EventType type, DragContext context) {
        super(source, type);
        this.context = context;
    }

    protected DragEvent(DragEvent event) {
        this((Widget) event.getSource(), event.getType(), event
                .getDragContext());
    }

    public DragContext getDragContext() {
        return context;
    }
}
