/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;

import org.gnu.glib.Type;
import org.gnu.gtk.VBox;
import org.gnu.glib.Handle;

/**
 * 
 */
public class IconSelection extends VBox {

    /**
     * Construct a new IconSelection object.
     */
    public IconSelection() {
        super(gnome_icon_selection_new());
    }

    /**
     * Construct a new IconSelection from a handle to a native resource.
     */
    public IconSelection(Handle handle) {
        super(handle);
    }

    /**
     * Add the default Gnome icon directories.
     */
    public void addDefaults() {
        gnome_icon_selection_add_defaults(getHandle());
    }

    /**
     * Add icons from the specified directory.
     * 
     * @param dir
     *            The director to add.
     */
    public void addDirectory(String dir) {
        gnome_icon_selection_add_directory(getHandle(), dir);
    }

    /**
     * Load and display the icons.
     */
    public void showIcons() {
        gnome_icon_selection_show_icons(getHandle());
    }

    /**
     * Clear all icons (even the icons that are not shown if <i>notShown</i> is
     * true.
     */
    public void clear(boolean notShown) {
        gnome_icon_selection_clear(getHandle(), notShown);
    }

    /**
     * Get the filename of the selected icon. If <i>fullPath</i> is true the
     * full path of the filename is returned.
     */
    public String getIcon(boolean fullPath) {
        return gnome_icon_selection_get_icon(getHandle(), fullPath);
    }

    /**
     * Select the icon specified by the filename provided. The filename is not
     * the full path, just the last component.
     */
    public void selectIcon(String filename) {
        gnome_icon_selection_select_icon(getHandle(), filename);
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     */
    public static Type getType() {
        return new Type(gnome_icon_selection_get_type());
    }

    native static final protected int gnome_icon_selection_get_type();

    native static final protected Handle gnome_icon_selection_new();

    native static final protected void gnome_icon_selection_add_defaults(
            Handle gis);

    native static final protected void gnome_icon_selection_add_directory(
            Handle gis, String dir);

    native static final protected void gnome_icon_selection_show_icons(
            Handle gis);

    native static final protected void gnome_icon_selection_clear(Handle gis,
            boolean notShown);

    native static final protected String gnome_icon_selection_get_icon(
            Handle gis, boolean fullPath);

    native static final protected void gnome_icon_selection_select_icon(
            Handle gis, String filename);

    native static final protected void gnome_icon_selection_stop_loading(
            Handle gis);

    native static final protected Handle gnome_icon_selection_get_gil(Handle gis);

    native static final protected Handle gnome_icon_selection_get_box(Handle gis);

}
