/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gconf;

import java.util.Date;

import org.gnu.glib.Boxed;

public class ConfMetaInfo extends Boxed {
	
	public ConfMetaInfo() {
		handle = gconf_meta_info_new();
	}
	
	public String getSchema() {
		return gconf_meta_info_get_schema(handle);
	}
	
	public String getModUser() {
		return gconf_meta_info_get_mod_user(handle);
	}
	
	public Date getModTime() {
		long time = gconf_meta_info_get_mod_time(handle);
		return new Date(time);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
		gconf_meta_info_free(handle);
	}

	/****************************************
	 * BEGINNING OF NATIVE CODE
	 ****************************************/
	native static final protected int gconf_meta_info_new();
	native static final protected void gconf_meta_info_free(int info);
	native static final protected String gconf_meta_info_get_schema(int info);
	native static final protected String gconf_meta_info_get_mod_user(int info);
	native static final protected long gconf_meta_info_get_mod_time(int info);
	native static final protected void gconf_meta_info_set_schema(int info, String schema);
	native static final protected void gconf_meta_info_set_mod_user(int info, String user);
	native static final protected void gconf_meta_info_set_mod_time(int info, long time);
	/****************************************
	 * END OF NATIVE CODE
	 ****************************************/
}
