/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.MemStruct;
import org.gnu.javagnome.Handle;
/**
 * Read only text appearance properties, as returned by methods relating to the
 * text view widgets. 
 */
public class TextAppearance extends MemStruct 
{

	protected TextAppearance(Handle handle){
		super(handle);
	}

	/**
	 */
	public org.gnu.gdk.Color getBgColor(){
		return new org.gnu.gdk.Color( getBgColor(getHandle()) );
	}

	/**
	 */
	public org.gnu.gdk.Color getFgColor(){
		return new org.gnu.gdk.Color( getFgColor(getHandle()) );
	}

	/**
	 */
	public org.gnu.gdk.Bitmap getBgStipple(){
		return new org.gnu.gdk.Bitmap( getBgStipple(getHandle()) );
	}

	/**
	 */
	public org.gnu.gdk.Bitmap getFgStipple(){
		return new org.gnu.gdk.Bitmap( getFgStipple(getHandle()) );
	}

	/**
	 * returns super/subscript rise, can be negative
	 */
	public int getRise(){
		return getRise(getHandle());
	}

	/**
	 */
	public org.gnu.pango.Underline getUnderline(){
		return org.gnu.pango.Underline.intern( getUnderline(getHandle()) );
	}

	/**
	 * 
	 */
	public boolean getStrikethrough(){
		return getStrikethrough(getHandle());
	}

	/**
	 */
	public boolean getDrawBg(){
		return getDrawBg(getHandle());
	}

    native static final protected Handle getBgColor (Handle cptr);
    native static final protected Handle getFgColor (Handle cptr);
    native static final protected Handle getBgStipple (Handle cptr);
    native static final protected Handle getFgStipple (Handle cptr);
    native static final protected int getRise (Handle cptr);
    native static final protected int getUnderline (Handle cptr);
    native static final protected boolean getStrikethrough (Handle cptr);
    native static final protected boolean getDrawBg (Handle cptr);
    native static final protected boolean getInsideSelection (Handle cptr);
    native static final protected boolean getIsText (Handle cptr);
}

