/*
 * Java-Gnome Bindings Library
*
* Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
*
* The Java-Gnome bindings library is free software distributed under
* the terms of the GNU Library General Public License version 2.
*/
package org.freedesktop.cairo;

import org.gnu.glib.Handle;

/**
 * A FontFace specifies all aspects of a font other than the size 
 * or font matrix (a font matrix is used to distort a font by 
 * sheering it or scaling it unequally in the two directions). 
 */
public class FontFace extends CairoObject {

	FontFace(Handle hndl) {
		super(hndl);
	}
	
    protected void finalize() throws Throwable {
        cairo_font_face_destroy(getHandle());
        super.finalize();
    }

    /*
     * Native calls
     */
	native static final private void cairo_font_face_destroy(Handle obj);

}
