/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gconf/gconf.h>

#ifndef _Included_org_gnu_gconf_ConfSchema
#define _Included_org_gnu_gconf_ConfSchema
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1new
  (JNIEnv *env, jclass cls)
{
	return (jint)gconf_schema_new();
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1free
  (JNIEnv *env, jclass cls, jint schema)
{
	gconf_schema_free((GConfSchema*)schema);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_type
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1type
  (JNIEnv *env, jclass cls, jint schema, jint type)
{
	gconf_schema_set_type((GConfSchema*)schema, (GConfValueType)type);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_list_type
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1list_1type
  (JNIEnv *env, jclass cls, jint schema, jint type)
{
	gconf_schema_set_list_type((GConfSchema*)schema, (GConfValueType)type);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_car_type
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1car_1type
  (JNIEnv *env, jclass cls, jint schema, jint type)
{
	gconf_schema_set_car_type((GConfSchema*)schema, (GConfValueType)type);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_cdr_type
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1cdr_1type
  (JNIEnv *env, jclass cls, jint schema, jint type)
{
	gconf_schema_set_cdr_type((GConfSchema*)schema, (GConfValueType)type);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_locale
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1locale
  (JNIEnv *env, jclass cls, jint schema, jstring locale)
{
	gchar* str = (gchar*)(*env)->GetStringUTFChars(env, locale, NULL);
	gconf_schema_set_locale((GConfSchema*)schema, str);
	(*env)->ReleaseStringUTFChars(env, locale, str);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_short_desc
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1short_1desc
  (JNIEnv *env, jclass cls, jint schema, jstring desc)
{
	gchar* str = (gchar*)(*env)->GetStringUTFChars(env, desc, NULL);
	gconf_schema_set_short_desc((GConfSchema*)schema, str);
	(*env)->ReleaseStringUTFChars(env, desc, str);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_long_desc
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1long_1desc
  (JNIEnv *env, jclass cls, jint schema, jstring desc)
{
	gchar* str = (gchar*)(*env)->GetStringUTFChars(env, desc, NULL);
	gconf_schema_set_long_desc((GConfSchema*)schema, str);
	(*env)->ReleaseStringUTFChars(env, desc, str);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_owner
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1owner
  (JNIEnv *env, jclass cls, jint schema, jstring owner)
{
	gchar* str = (gchar*)(*env)->GetStringUTFChars(env, owner, NULL);
	gconf_schema_set_owner((GConfSchema*)schema, str);
	(*env)->ReleaseStringUTFChars(env, owner, str);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_default_value
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1default_1value
  (JNIEnv *env, jclass cls, jint schema, jint value)
{
	gconf_schema_set_default_value((GConfSchema*)schema, (GConfValue*)value);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_set_default_value_nocopy
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1set_1default_1value_1nocopy
  (JNIEnv *env, jclass cls, jint schema, jint value)
{
	gconf_schema_set_default_value_nocopy((GConfSchema*)schema, (GConfValue*)value);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_type
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1type
  (JNIEnv *env, jclass cls, jint schema)
{
	return (jint)gconf_schema_get_type((GConfSchema*)schema);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_list_type
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1list_1type
  (JNIEnv *env, jclass cls, jint schema)
{
	return (jint)gconf_schema_get_list_type((GConfSchema*)schema);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_car_type
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1car_1type
  (JNIEnv *env, jclass cls, jint schema)
{
	return (jint)gconf_schema_get_car_type((GConfSchema*)schema);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_cdr_type
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1cdr_1type
  (JNIEnv *env, jclass cls, jint schema)
{
	return (jint)gconf_schema_get_cdr_type((GConfSchema*)schema);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_locale
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1locale
  (JNIEnv *env, jclass cls, jint schema)
{
	const char* locale = gconf_schema_get_locale((GConfSchema*)schema);
	return (*env)->NewStringUTF(env, locale);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_short_desc
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1short_1desc
  (JNIEnv *env, jclass cls, jint schema)
{
	const char* desc = gconf_schema_get_short_desc((GConfSchema*)schema);
	return (*env)->NewStringUTF(env, desc);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_long_desc
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1long_1desc
  (JNIEnv *env, jclass cls, jint schema)
{
	const char* desc = gconf_schema_get_long_desc((GConfSchema*)schema);
	return (*env)->NewStringUTF(env, desc);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_owner
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1owner
  (JNIEnv *env, jclass cls, jint schema)
{
	const char* owner = gconf_schema_get_owner((GConfSchema*)schema);
	return (*env)->NewStringUTF(env, owner);
}

/*
 * Class:     org_gnu_gconf_ConfSchema
 * Method:    gconf_schema_get_default_value
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfSchema_gconf_1schema_1get_1default_1value
  (JNIEnv *env, jclass cls, jint schema)
{
	return (jint)gconf_schema_get_default_value((GConfSchema*)schema);
}

#ifdef __cplusplus
}
#endif
#endif
