/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 * The Progress widget is the base class of {@link ProgressBar}. The Progress
 * class exists in Gtk for compatibility with programs written prior to Gtk2.
 * All methods have been deprecated and so are not present in Java-Gnome
 * @see ProgressBar
 */
public class Progress extends Widget 
{	
	Progress(Handle handle) {
	    super(handle);
	}
    
    /**
     * Internal static factory method to be used by Java-Gnome only.
     */
    static Progress getProgress(Handle handle) {
        if (handle == null)
            return null;
        
        Progress obj = (Progress) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new Progress(handle);
        
        return obj;
    }

	//
	// This class is all deprecated as of Gnome 2
	//
	
    native static final protected double getXAlign (Handle cptr);
    native static final protected double getYAlign (Handle cptr);
    native static final protected boolean getShowText (Handle cptr);
    native static final protected boolean getActivityMode (Handle cptr);
    native static final protected boolean getUseTextFormat (Handle cptr);
    native static final protected String getFormat (Handle cptr);
    native static final protected Handle getAdjustment (Handle cptr);
    native static final protected Handle getOffscreenPixmap (Handle cptr);
}

