#!/usr/local/bin/perl

my ($cflags, $platform) = @ARGV;

$cflags = "compiler: $cflags";
$date = localtime();
print <<"END_OUTPUT";
/* auto-generated by util/mkbuildinf.pl for crypto/cversion.c */
#define CFLAGS cflags
/*
 * Generate CFLAGS as an array of individual characters. This is a
 * workaround for the situation where CFLAGS gets too long for a C90 string
 * literal
 */
static const char cflags[] = {
END_OUTPUT
my $ctr = 0;
foreach my $c (split //, $cflags) {
    $c =~ s|([\\'])|\\$1|;
    # Max 16 characters per line
    if  (($ctr++ % 16) == 0) {
        if ($ctr != 1) {
            print "\n";
        }
        print "    ";
    }
    print "'$c',";
}
print <<"END_OUTPUT";
'\\0'
};
#define PLATFORM "platform: $platform"
#define DATE "built on: $date"
END_OUTPUT
