/* ====================================================================
 * Copyright (c) 1999-2016 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.OpenSSL.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@OpenSSL.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.OpenSSL.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

/*
 * NOTE: this file was auto generated by the mkerr.pl script: any changes
 * made to it will be overwritten when the script next updates this file,
 * only reason strings will be preserved.
 */

#include <stdio.h>
#include <openssl/err.h>
#include "e_afalg_err.h"

/* BEGIN ERROR CODES */
#ifndef OPENSSL_NO_ERR

# define ERR_FUNC(func) ERR_PACK(0,func,0)
# define ERR_REASON(reason) ERR_PACK(0,0,reason)

static ERR_STRING_DATA AFALG_str_functs[] = {
    {ERR_FUNC(AFALG_F_AFALG_CHK_PLATFORM), "afalg_chk_platform"},
    {ERR_FUNC(AFALG_F_AFALG_CREATE_BIND_SK), "afalg_create_bind_sk"},
    {ERR_FUNC(AFALG_F_AFALG_CREATE_BIND_SOCKET), "afalg_create_bind_sk"},
    {ERR_FUNC(AFALG_F_AFALG_CREATE_SK), "afalg_create_sk"},
    {ERR_FUNC(AFALG_F_AFALG_INIT_AIO), "afalg_init_aio"},
    {ERR_FUNC(AFALG_F_AFALG_SETUP_ASYNC_EVENT_NOTIFICATION),
     "afalg_setup_async_event_notification"},
    {ERR_FUNC(AFALG_F_AFALG_SET_KEY), "afalg_set_key"},
    {ERR_FUNC(AFALG_F_AFALG_SOCKET), "afalg_socket"},
    {ERR_FUNC(AFALG_F_AFALG_START_CIPHER_SK), "afalg_start_cipher_sk"},
    {ERR_FUNC(AFALG_F_BIND_AFALG), "bind_afalg"},
    {0, NULL}
};

static ERR_STRING_DATA AFALG_str_reasons[] = {
    {ERR_REASON(AFALG_R_EVENTFD_FAILED), "eventfd failed"},
    {ERR_REASON(AFALG_R_FAILED_TO_GET_PLATFORM_INFO),
     "failed to get platform info"},
    {ERR_REASON(AFALG_R_INIT_FAILED), "init failed"},
    {ERR_REASON(AFALG_R_IO_SETUP_FAILED), "io setup failed"},
    {ERR_REASON(AFALG_R_KERNEL_DOES_NOT_SUPPORT_AFALG),
     "kernel does not support afalg"},
    {ERR_REASON(AFALG_R_KERNEL_DOES_NOT_SUPPORT_ASYNC_AFALG),
     "kernel does not support async afalg"},
    {ERR_REASON(AFALG_R_MEM_ALLOC_FAILED), "mem alloc failed"},
    {ERR_REASON(AFALG_R_SOCKET_ACCEPT_FAILED), "socket accept failed"},
    {ERR_REASON(AFALG_R_SOCKET_BIND_FAILED), "socket bind failed"},
    {ERR_REASON(AFALG_R_SOCKET_CREATE_FAILED), "socket create failed"},
    {ERR_REASON(AFALG_R_SOCKET_OPERATION_FAILED), "socket operation failed"},
    {ERR_REASON(AFALG_R_SOCKET_SET_KEY_FAILED), "socket set key failed"},
    {0, NULL}
};

#endif

#ifdef AFALG_LIB_NAME
static ERR_STRING_DATA AFALG_lib_name[] = {
    {0, AFALG_LIB_NAME},
    {0, NULL}
};
#endif

static int AFALG_lib_error_code = 0;
static int AFALG_error_init = 1;

void ERR_load_AFALG_strings(void)
{
    if (AFALG_lib_error_code == 0)
        AFALG_lib_error_code = ERR_get_next_error_library();

    if (AFALG_error_init) {
        AFALG_error_init = 0;
#ifndef OPENSSL_NO_ERR
        ERR_load_strings(AFALG_lib_error_code, AFALG_str_functs);
        ERR_load_strings(AFALG_lib_error_code, AFALG_str_reasons);
#endif

#ifdef AFALG_LIB_NAME
        AFALG_lib_name->error = ERR_PACK(AFALG_lib_error_code, 0, 0);
        ERR_load_strings(0, AFALG_lib_name);
#endif
    }
}

void ERR_unload_AFALG_strings(void)
{
    if (AFALG_error_init == 0) {
#ifndef OPENSSL_NO_ERR
        ERR_unload_strings(AFALG_lib_error_code, AFALG_str_functs);
        ERR_unload_strings(AFALG_lib_error_code, AFALG_str_reasons);
#endif

#ifdef AFALG_LIB_NAME
        ERR_unload_strings(0, AFALG_lib_name);
#endif
        AFALG_error_init = 1;
    }
}

void ERR_AFALG_error(int function, int reason, char *file, int line)
{
    if (AFALG_lib_error_code == 0)
        AFALG_lib_error_code = ERR_get_next_error_library();
    ERR_PUT_error(AFALG_lib_error_code, function, reason, file, line);
}
