#include <sys/param.h>
#include <sys/event.h>
#include <sys/ioctl.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

int
main(int argc, char **argv)
{
	struct kfilter_mapping	km;
	int	kq, op;

	if (argc < 2 || argc > 3)
		errx(1, "Usage: %s filter [oldfilter]", argv[0]);
	
        kq = kqueue();
        if (kq < 0)
                err(1, "kqueue");

	if (argc == 3) {
		km.name = argv[2];
		if (ioctl(kq, KFILTER_BYNAME, &km) == -1)
			err(1, "can't find oldfilter `%s'", km.name);
		printf("oldfilter %s -> %d\n", km.name, km.filter);
			/* km.filter contains what we want */
		op = KFILTER_REGISTER;
	} else
		op = KFILTER_UNREGISTER;
	km.name = argv[1];
	if (ioctl(kq, op, &km) == -1)
		err(1, "KFILTER_%sREGISTER `%s'",
		    op == KFILTER_UNREGISTER ? "UN" : "" , km.name);
	if (op == KFILTER_REGISTER)
		printf("kfilter_register: %s is %d\n", km.name, km.filter);
	else
		printf("kfilter_unregister: succeeded\n");

	return (0);
}
