/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sbt.pgp;

import com.typesafe.sbt.pgp.GetSignaturesConfiguration;
import com.typesafe.sbt.pgp.PgpVerifierFactory;
import com.typesafe.sbt.pgp.SignatureCheck;
import com.typesafe.sbt.pgp.SignatureCheckReport;
import com.typesafe.sbt.pgp.SignatureCheckResult;
import com.typesafe.sbt.pgp.SignatureCheckResult$MISSING$;
import com.typesafe.sbt.pgp.SignatureCheckResult$OK$;
import com.typesafe.sbt.pgp.package$;
import java.io.File;
import java.io.Serializable;
import sbt.internal.librarymanagement.IvySbt;
import sbt.internal.util.Init;
import sbt.librarymanagement.Artifact;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.ModuleSettings;
import sbt.librarymanagement.UnresolvedWarning;
import sbt.librarymanagement.UpdateConfiguration;
import sbt.librarymanagement.UpdateReport;
import sbt.sbtpgp.Compat$;
import sbt.std.TaskStreams;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PgpSignatureCheck$ {
    public static PgpSignatureCheck$ MODULE$;

    static {
        new PgpSignatureCheck$();
    }

    public UpdateReport resolveSignatures(IvySbt ivySbt, GetSignaturesConfiguration config, Logger log) {
        UpdateReport r;
        UpdateConfiguration upConf;
        Seq baseModules = (Seq)config.module().modules().map((Function1 & Serializable & scala.Serializable)m -> PgpSignatureCheck$.restrictedCopy$1(m, false), Seq$.MODULE$.canBuildFrom());
        Vector deps = ((TraversableOnce)((TraversableLike)baseModules.distinct()).flatMap((Function1 & Serializable & scala.Serializable)m -> Option$.MODULE$.option2Iterable(PgpSignatureCheck$.signatureArtifacts$1(m)), Seq$.MODULE$.canBuildFrom())).toVector();
        ModuleID base = PgpSignatureCheck$.restrictedCopy$1(config.module().id(), true);
        IvySbt.Module module = new IvySbt.Module(ivySbt, (ModuleSettings)Compat$.MODULE$.mkInlineConfiguration(base, (Vector<ModuleID>)deps, config.ivyScala(), (Vector<Configuration>)config.module().configurations().toVector()));
        Either<UnresolvedWarning, UpdateReport> either = Compat$.MODULE$.updateEither(module, upConf = Compat$.MODULE$.subMissingOk(config.configuration(), true), Compat$.MODULE$.UnresolvedWarningConfiguration().apply(), sbt.package$.MODULE$.LogicalClock().unknown(), (Option<File>)None$.MODULE$, log);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                UnresolvedWarning w = (UnresolvedWarning)left.value();
                throw w.resolveException();
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        UpdateReport updateReport = r = (UpdateReport)right.value();
        return updateReport;
    }

    public SignatureCheckReport checkSignaturesTask(UpdateReport update, PgpVerifierFactory pgp, TaskStreams<Init.ScopedKey<?>> s) {
        SignatureCheckReport report = new SignatureCheckReport((Seq<SignatureCheck>)((Seq)this.checkArtifactSignatures(update, pgp, s).$plus$plus(this.missingSignatures(update, s), Seq$.MODULE$.canBuildFrom())));
        this.prettyPrintSingatureReport(report, s);
        if (report.results().exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)PgpSignatureCheck$.$anonfun$checkSignaturesTask$1(x)))) {
            throw scala.sys.package$.MODULE$.error("Some artifacts have bad signatures or are signed by untrusted sources!");
        }
        return report;
    }

    public void prettyPrintSingatureReport(SignatureCheckReport report, TaskStreams<Init.ScopedKey<?>> s) {
        if (report.results().isEmpty()) {
            s.log().info((Function0 & Serializable & scala.Serializable)() -> "----- No Dependencies for PGP check -----");
        } else {
            s.log().info((Function0 & Serializable & scala.Serializable)() -> "----- PGP Signature Results -----");
            int maxOrgWidth = BoxesRunTime.unboxToInt((Object)((TraversableOnce)report.results().view().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PgpSignatureCheck$.$anonfun$prettyPrintSingatureReport$3(x0$1)), SeqView$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            int maxNameWidth = BoxesRunTime.unboxToInt((Object)((TraversableOnce)report.results().view().map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)PgpSignatureCheck$.$anonfun$prettyPrintSingatureReport$4(x0$2)), SeqView$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            int maxVersionWidth = BoxesRunTime.unboxToInt((Object)((TraversableOnce)report.results().view().map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)PgpSignatureCheck$.$anonfun$prettyPrintSingatureReport$5(x0$3)), SeqView$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            int maxTypeWidth = BoxesRunTime.unboxToInt((Object)((TraversableOnce)report.results().view().map((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToInteger((int)PgpSignatureCheck$.$anonfun$prettyPrintSingatureReport$6(x0$4)), SeqView$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            String formatString = "  %" + maxOrgWidth + "s : %" + maxNameWidth + "s : %" + maxVersionWidth + "s : %" + maxTypeWidth + "s   [%s]";
            ((IterableLike)report.results().sortWith((Function2 & Serializable & scala.Serializable)(x0$5, x1$1) -> BoxesRunTime.boxToBoolean((boolean)PgpSignatureCheck$.$anonfun$prettyPrintSingatureReport$7(x0$5, x1$1)))).foreach((Function1 & Serializable & scala.Serializable)x -> {
                PgpSignatureCheck$.$anonfun$prettyPrintSingatureReport$8(s, formatString, x);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Seq<SignatureCheck> missingSignatures(UpdateReport update, TaskStreams<Init.ScopedKey<?>> s) {
        return (Seq)update.configurations().flatMap((Function1 & Serializable & scala.Serializable)config -> (Vector)config.modules().flatMap((Function1 & Serializable & scala.Serializable)module -> (Vector)module.missingArtifacts().withFilter((Function1 & Serializable & scala.Serializable)artifact -> BoxesRunTime.boxToBoolean((boolean)PgpSignatureCheck$.$anonfun$missingSignatures$3(artifact))).map((Function1 & Serializable & scala.Serializable)artifact -> new SignatureCheck(module.module(), (Artifact)artifact, SignatureCheckResult$MISSING$.MODULE$), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom());
    }

    private Seq<SignatureCheck> checkArtifactSignatures(UpdateReport update, PgpVerifierFactory pgp2, TaskStreams<Init.ScopedKey<?>> s) {
        return (Seq)pgp2.withVerifier((Function1 & Serializable & scala.Serializable)pgp -> (Seq)update.configurations().flatMap((Function1 & Serializable & scala.Serializable)config -> (Vector)config.modules().flatMap((Function1 & Serializable & scala.Serializable)module -> (Vector)module.artifacts().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PgpSignatureCheck$.$anonfun$checkArtifactSignatures$4(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PgpSignatureCheck$.$anonfun$checkArtifactSignatures$5(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Artifact artifact = (Artifact)tuple2._1();
            File file = (File)tuple2._2();
            SignatureCheck signatureCheck = new SignatureCheck(module.module(), artifact, pgp.verifySignature(file, s));
            return signatureCheck;
        }, Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom()), Vector$.MODULE$.canBuildFrom()));
    }

    private static final ModuleID restrictedCopy$1(ModuleID m, boolean confs) {
        return Compat$.MODULE$.subConfiguration(m, confs);
    }

    private static final Seq signatureFor$1(Artifact artifact) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{artifact, Compat$.MODULE$.subExtension(artifact, artifact.extension() + package$.MODULE$.gpgExtension())}));
    }

    private static final Option signatureArtifacts$1(ModuleID m) {
        return m.explicitArtifacts().isEmpty() ? new Some((Object)Compat$.MODULE$.subExplicitArtifacts(m, (Vector<Artifact>)((Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Artifact[]{sbt.package$.MODULE$.Artifact().apply(m.name(), "jar", "jar"), sbt.package$.MODULE$.Artifact().apply(m.name(), "jar", "jar" + package$.MODULE$.gpgExtension())}))))) : new Some((Object)Compat$.MODULE$.subExplicitArtifacts(m, (Vector<Artifact>)((Vector)m.explicitArtifacts().toVector().flatMap((Function1 & Serializable & scala.Serializable)artifact -> PgpSignatureCheck$.signatureFor$1(artifact), Vector$.MODULE$.canBuildFrom()))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkSignaturesTask$1(SignatureCheck x) {
        SignatureCheckResult signatureCheckResult = x.result();
        SignatureCheckResult$OK$ signatureCheckResult$OK$ = SignatureCheckResult$OK$.MODULE$;
        if (signatureCheckResult == null) {
            if (signatureCheckResult$OK$ == null) return false;
        } else if (signatureCheckResult.equals(signatureCheckResult$OK$)) return false;
        SignatureCheckResult signatureCheckResult2 = x.result();
        SignatureCheckResult$MISSING$ signatureCheckResult$MISSING$ = SignatureCheckResult$MISSING$.MODULE$;
        if (signatureCheckResult2 == null) {
            if (signatureCheckResult$MISSING$ == null) return false;
            return true;
        } else if (signatureCheckResult2.equals(signatureCheckResult$MISSING$)) return false;
        return true;
    }

    public static final /* synthetic */ int $anonfun$prettyPrintSingatureReport$3(SignatureCheck x0$1) {
        SignatureCheck signatureCheck = x0$1;
        if (signatureCheck == null) {
            throw new MatchError((Object)signatureCheck);
        }
        ModuleID m = signatureCheck.module();
        int n = new StringOps(Predef$.MODULE$.augmentString(m.organization())).size();
        return n;
    }

    public static final /* synthetic */ int $anonfun$prettyPrintSingatureReport$4(SignatureCheck x0$2) {
        SignatureCheck signatureCheck = x0$2;
        if (signatureCheck == null) {
            throw new MatchError((Object)signatureCheck);
        }
        ModuleID m = signatureCheck.module();
        int n = new StringOps(Predef$.MODULE$.augmentString(m.name())).size();
        return n;
    }

    public static final /* synthetic */ int $anonfun$prettyPrintSingatureReport$5(SignatureCheck x0$3) {
        SignatureCheck signatureCheck = x0$3;
        if (signatureCheck == null) {
            throw new MatchError((Object)signatureCheck);
        }
        ModuleID m = signatureCheck.module();
        int n = new StringOps(Predef$.MODULE$.augmentString(m.revision())).size();
        return n;
    }

    public static final /* synthetic */ int $anonfun$prettyPrintSingatureReport$6(SignatureCheck x0$4) {
        SignatureCheck signatureCheck = x0$4;
        if (signatureCheck == null) {
            throw new MatchError((Object)signatureCheck);
        }
        Artifact a = signatureCheck.artifact();
        int n = new StringOps(Predef$.MODULE$.augmentString(a.type())).size();
        return n;
    }

    private static final String prettify$1(SignatureCheck s, String formatString$1) {
        return new StringOps(Predef$.MODULE$.augmentString(formatString$1)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.module().organization(), s.module().name(), s.module().revision(), s.artifact().type(), s.result()}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$prettyPrintSingatureReport$7(SignatureCheck x0$5, SignatureCheck x1$1) {
        SignatureCheckResult signatureCheckResult;
        SignatureCheck signatureCheck;
        SignatureCheckResult signatureCheckResult2;
        SignatureCheck signatureCheck2;
        SignatureCheckResult signatureCheckResult3;
        SignatureCheck signatureCheck3;
        SignatureCheckResult signatureCheckResult4;
        SignatureCheck signatureCheck4;
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$1);
        if (tuple2 != null) {
            SignatureCheck a = (SignatureCheck)tuple2._1();
            SignatureCheck b = (SignatureCheck)tuple2._2();
            SignatureCheckResult signatureCheckResult5 = a.result();
            SignatureCheckResult signatureCheckResult6 = b.result();
            if (signatureCheckResult5 == null) {
                if (signatureCheckResult6 == null) return new StringOps(Predef$.MODULE$.augmentString(a.toString())).$less((Object)b.toString());
            } else if (signatureCheckResult5.equals(signatureCheckResult6)) {
                return new StringOps(Predef$.MODULE$.augmentString(a.toString())).$less((Object)b.toString());
            }
        }
        if (tuple2 != null && (signatureCheck4 = (SignatureCheck)tuple2._1()) != null && SignatureCheckResult$OK$.MODULE$.equals(signatureCheckResult4 = signatureCheck4.result())) {
            return true;
        }
        if (tuple2 != null && (signatureCheck3 = (SignatureCheck)tuple2._2()) != null && SignatureCheckResult$OK$.MODULE$.equals(signatureCheckResult3 = signatureCheck3.result())) {
            return false;
        }
        if (tuple2 != null && (signatureCheck2 = (SignatureCheck)tuple2._1()) != null && SignatureCheckResult$MISSING$.MODULE$.equals(signatureCheckResult2 = signatureCheck2.result())) {
            return true;
        }
        if (tuple2 != null && (signatureCheck = (SignatureCheck)tuple2._2()) != null && SignatureCheckResult$MISSING$.MODULE$.equals(signatureCheckResult = signatureCheck.result())) {
            return false;
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        SignatureCheck a = (SignatureCheck)tuple2._1();
        SignatureCheck b = (SignatureCheck)tuple2._2();
        return new StringOps(Predef$.MODULE$.augmentString(a.toString())).$less((Object)b.toString());
    }

    public static final /* synthetic */ void $anonfun$prettyPrintSingatureReport$8(TaskStreams s$2, String formatString$1, SignatureCheck x) {
        s$2.log().info((Function0 & Serializable & scala.Serializable)() -> PgpSignatureCheck$.prettify$1(x, formatString$1));
    }

    public static final /* synthetic */ boolean $anonfun$missingSignatures$3(Artifact artifact) {
        return artifact.extension().endsWith(package$.MODULE$.gpgExtension());
    }

    public static final /* synthetic */ boolean $anonfun$checkArtifactSignatures$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$checkArtifactSignatures$5(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._2();
        boolean bl = file.getName().endsWith(package$.MODULE$.gpgExtension());
        return bl;
    }

    private PgpSignatureCheck$() {
        MODULE$ = this;
    }
}

