/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LOOKUPSWITCH;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.util.ByteSequence;

public class DuplicateBranches
extends PreorderVisitor
implements Detector {
    private ClassContext classContext;
    private final BugReporter bugReporter;
    private final Collection<BugInstance> pendingBugs = new LinkedList<BugInstance>();

    public DuplicateBranches(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        classContext.getJavaClass().accept((Visitor)this);
    }

    @Override
    public void visitMethod(Method method) {
        try {
            if (method.getCode() == null) {
                return;
            }
            CFG cfg = this.classContext.getCFG(method);
            Iterator<BasicBlock> bbi = cfg.blockIterator();
            while (bbi.hasNext()) {
                BasicBlock bb = bbi.next();
                int numOutgoing = cfg.getNumOutgoingEdges(bb);
                if (numOutgoing == 2) {
                    this.findIfElseDuplicates(cfg, method, bb);
                    continue;
                }
                if (numOutgoing <= 2) continue;
                this.findSwitchDuplicates(cfg, method, bb);
            }
        }
        catch (MethodUnprofitableException mue) {
            if (SystemProperties.getBoolean("unprofitable.debug")) {
                this.bugReporter.logError("skipping unprofitable method in " + this.getClass().getName());
            }
        }
        catch (Exception e) {
            this.bugReporter.logError("Failure examining basic blocks in Duplicate Branches detector", e);
        }
        if (this.pendingBugs.size() <= 2) {
            for (BugInstance b : this.pendingBugs) {
                this.bugReporter.reportBug(b);
            }
        }
        this.pendingBugs.clear();
    }

    private void findIfElseDuplicates(CFG cfg, Method method, BasicBlock bb) {
        byte[] elseBytes;
        BasicBlock thenBB = null;
        BasicBlock elseBB = null;
        Iterator iei = cfg.outgoingEdgeIterator(bb);
        while (iei.hasNext()) {
            Edge e = (Edge)iei.next();
            if (e.getType() == 1) {
                elseBB = (BasicBlock)e.getTarget();
                continue;
            }
            if (e.getType() != 0) continue;
            thenBB = (BasicBlock)e.getTarget();
        }
        if (thenBB == null || elseBB == null) {
            return;
        }
        InstructionHandle thenStartHandle = DuplicateBranches.getDeepFirstInstruction(cfg, thenBB);
        InstructionHandle elseStartHandle = DuplicateBranches.getDeepFirstInstruction(cfg, elseBB);
        if (thenStartHandle == null || elseStartHandle == null) {
            return;
        }
        int thenStartPos = thenStartHandle.getPosition();
        int elseStartPos = elseStartHandle.getPosition();
        InstructionHandle thenFinishIns = this.findThenFinish(cfg, thenBB, elseStartPos);
        int thenFinishPos = thenFinishIns.getPosition();
        if (!(thenFinishIns.getInstruction() instanceof GotoInstruction)) {
            return;
        }
        InstructionHandle elseFinishHandle = ((GotoInstruction)thenFinishIns.getInstruction()).getTarget();
        int elseFinishPos = elseFinishHandle.getPosition();
        if (thenFinishPos >= elseStartPos) {
            return;
        }
        if (thenFinishPos - thenStartPos != elseFinishPos - elseStartPos) {
            return;
        }
        if (thenFinishPos <= thenStartPos) {
            return;
        }
        byte[] thenBytes = this.getCodeBytes(method, thenStartPos, thenFinishPos);
        if (!Arrays.equals(thenBytes, elseBytes = this.getCodeBytes(method, elseStartPos, elseFinishPos))) {
            return;
        }
        InstructionHandle elseLastIns = elseFinishHandle.getPrev();
        if (elseLastIns != null) {
            elseFinishPos = elseLastIns.getPosition();
        }
        this.pendingBugs.add(new BugInstance(this, "DB_DUPLICATE_BRANCHES", 2).addClassAndMethod(this.classContext.getJavaClass(), method).addSourceLineRange(this.classContext, this, thenStartPos, thenFinishPos).addSourceLineRange(this.classContext, this, elseStartPos, elseFinishPos));
    }

    private static InstructionHandle getDeepFirstInstruction(CFG cfg, BasicBlock bb) {
        InstructionHandle ih = bb.getFirstInstruction();
        if (ih != null) {
            return ih;
        }
        Iterator iei = cfg.outgoingEdgeIterator(bb);
        while (iei.hasNext()) {
            Edge e = (Edge)iei.next();
            String edgeString = e.toString();
            if (0 != e.getType()) continue;
            return DuplicateBranches.getDeepFirstInstruction(cfg, (BasicBlock)e.getTarget());
        }
        return null;
    }

    private void findSwitchDuplicates(CFG cfg, Method method, BasicBlock bb) {
        int[] switchPos = new int[cfg.getNumOutgoingEdges(bb) + 1];
        HashMap<Integer, InstructionHandle> prevHandle = new HashMap<Integer, InstructionHandle>();
        Iterator iei = cfg.outgoingEdgeIterator(bb);
        int idx = 0;
        while (iei.hasNext()) {
            Edge e = (Edge)iei.next();
            int eType = e.getType();
            if (eType == 2 || eType == 3) {
                BasicBlock target = (BasicBlock)e.getTarget();
                InstructionHandle firstIns = DuplicateBranches.getDeepFirstInstruction(cfg, target);
                if (firstIns == null) continue;
                int firstInsPosition = firstIns.getPosition();
                switchPos[idx++] = firstInsPosition;
                InstructionHandle prevIns = firstIns.getPrev();
                if (prevIns == null) continue;
                prevHandle.put(firstInsPosition, prevIns);
                continue;
            }
            return;
        }
        if (idx < 2) {
            return;
        }
        Arrays.sort(switchPos, 0, idx);
        switchPos[idx] = DuplicateBranches.getFinalTarget(cfg, switchPos[idx - 1], prevHandle.values());
        HashMap<BigInteger, Collection<Integer>> map = new HashMap<BigInteger, Collection<Integer>>();
        for (int i = 0; i < idx; ++i) {
            if (switchPos[i] + 7 >= switchPos[i + 1]) continue;
            int endPos = switchPos[i + 1];
            InstructionHandle last = (InstructionHandle)prevHandle.get(switchPos[i + 1]);
            if (last != null) {
                if (last.getInstruction() instanceof GotoInstruction) {
                    endPos = last.getPosition();
                } else if (!(last.getInstruction() instanceof ReturnInstruction) && (i + 2 < idx || i + 1 < idx && switchPos[idx] != switchPos[idx - 1])) continue;
            }
            BigInteger clauseAsInt = this.getCodeBytesAsBigInt(method, switchPos, i, endPos);
            this.updateMap(map, i, clauseAsInt);
        }
        for (Collection clauses : map.values()) {
            if (clauses.size() <= 1) continue;
            BugInstance bug = new BugInstance(this, "DB_DUPLICATE_SWITCH_CLAUSES", 3).addClassAndMethod(this.classContext.getJavaClass(), method);
            Iterator i$ = clauses.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                bug.addSourceLineRange(this.classContext, this, switchPos[i], switchPos[i + 1] - 1);
            }
            this.pendingBugs.add(bug);
        }
    }

    private void updateMap(HashMap<BigInteger, Collection<Integer>> map, int i, BigInteger clauseAsInt) {
        Collection<Integer> values = map.get(clauseAsInt);
        if (values == null) {
            values = new LinkedList<Integer>();
            map.put(clauseAsInt, values);
        }
        values.add(i);
    }

    private BigInteger getCodeBytesAsBigInt(Method method, int[] switchPos, int i, int endPos) {
        byte[] clause = this.getCodeBytes(method, switchPos[i], endPos);
        BigInteger clauseAsInt = clause.length == 0 ? BigInteger.ZERO : new BigInteger(clause);
        return clauseAsInt;
    }

    private static int getFinalTarget(CFG cfg, int myPos, Collection<InstructionHandle> prevs) {
        InstructionHandle last;
        int maxGoto = 0;
        BasicBlock myBB = null;
        Iterator<BasicBlock> bbi = cfg.blockIterator();
        while (bbi.hasNext()) {
            BasicBlock bb = bbi.next();
            InstructionHandle last2 = bb.getLastInstruction();
            if (prevs.contains(last2)) {
                Iterator iei = cfg.outgoingEdgeIterator(bb);
                while (iei.hasNext()) {
                    int targetPos;
                    BasicBlock target;
                    InstructionHandle targetFirst;
                    Edge e = (Edge)iei.next();
                    int eType = e.getType();
                    String aab = e.toString();
                    if (eType != 6 || (targetFirst = DuplicateBranches.getDeepFirstInstruction(cfg, target = (BasicBlock)e.getTarget())) == null || (targetPos = targetFirst.getPosition()) <= maxGoto) continue;
                    maxGoto = targetPos;
                }
                continue;
            }
            if (last2 == null || myPos != bb.getFirstInstruction().getPosition()) continue;
            myBB = bb;
        }
        if (maxGoto < myPos && myBB != null && (last = myBB.getLastInstruction()) != null) {
            return last.getPosition() + last.getInstruction().getLength();
        }
        return maxGoto;
    }

    private byte[] getCodeBytes(Method m, int start, int end) {
        byte[] code = m.getCode().getCode();
        byte[] bytes = new byte[end - start];
        System.arraycopy(code, start, bytes, 0, end - start);
        try {
            int pos;
            ByteSequence sequence = new ByteSequence(code);
            while (sequence.available() > 0 && sequence.getIndex() < start) {
                Instruction.readInstruction((ByteSequence)sequence);
            }
            while (sequence.available() > 0 && (pos = sequence.getIndex()) < end) {
                BranchInstruction bi;
                int offset;
                int target;
                Instruction ins = Instruction.readInstruction((ByteSequence)sequence);
                if (!(ins instanceof BranchInstruction) || ins instanceof TABLESWITCH || ins instanceof LOOKUPSWITCH || (target = (offset = (bi = (BranchInstruction)ins).getIndex()) + pos) < end) continue;
                byte hiByte = (byte)(target >> 8 & 0xFF);
                byte loByte = (byte)(target & 0xFF);
                bytes[pos + bi.getLength() - 2 - start] = hiByte;
                bytes[pos + bi.getLength() - 1 - start] = loByte;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return bytes;
    }

    private InstructionHandle findThenFinish(CFG cfg, BasicBlock thenBB, int elsePos) {
        InstructionHandle inst = thenBB.getFirstInstruction();
        while (inst == null) {
            Iterator ie = cfg.outgoingEdgeIterator(thenBB);
            while (ie.hasNext()) {
                Edge e = (Edge)ie.next();
                if (e.getType() != 0) continue;
                thenBB = (BasicBlock)e.getTarget();
                break;
            }
            inst = thenBB.getFirstInstruction();
        }
        InstructionHandle lastIns = inst;
        while (inst.getPosition() < elsePos) {
            lastIns = inst;
            inst = inst.getNext();
        }
        return lastIns;
    }

    @Override
    public void report() {
    }
}

