/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud;

import edu.umd.cs.findbugs.cloud.Cloud;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MutableCloudTask
implements Cloud.CloudTask {
    private final String name;
    private final CopyOnWriteArrayList<Cloud.CloudTaskListener> listeners = new CopyOnWriteArrayList();
    private String substatus = "";
    private double percentDone = 0.0;
    private Cloud.CloudTaskListener defaultListener;
    private boolean finished = false;
    private boolean useDefaultListener = true;

    public MutableCloudTask(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStatusLine() {
        return this.substatus;
    }

    @Override
    public double getPercentCompleted() {
        return this.percentDone;
    }

    @Override
    public void addListener(Cloud.CloudTaskListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void removeListener(Cloud.CloudTaskListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void setUseDefaultListener(boolean enabled) {
        this.useDefaultListener = enabled;
    }

    public void update(String substatus, double percentDone) {
        this.substatus = substatus;
        this.percentDone = percentDone;
        for (Cloud.CloudTaskListener listener : this.getListeners()) {
            listener.taskStatusUpdated(substatus, percentDone);
        }
    }

    public void finished() {
        this.finished = true;
        for (Cloud.CloudTaskListener listener : this.getListeners()) {
            listener.taskFinished();
        }
        this.clearListeners();
    }

    public void failed(String message) {
        this.finished = true;
        for (Cloud.CloudTaskListener listener : this.getListeners()) {
            listener.taskFailed(message);
        }
        this.clearListeners();
    }

    public void setDefaultListener(Cloud.CloudTaskListener defaultListener) {
        this.defaultListener = defaultListener;
    }

    private List<Cloud.CloudTaskListener> getListeners() {
        ArrayList<Cloud.CloudTaskListener> myListeners = new ArrayList<Cloud.CloudTaskListener>(this.listeners);
        if (this.useDefaultListener && myListeners.isEmpty() && this.defaultListener != null) {
            myListeners.add(this.defaultListener);
        }
        return myListeners;
    }

    private void clearListeners() {
        this.listeners.clear();
        this.defaultListener = null;
    }

    public boolean isUsingDefaultListener() {
        return this.listeners.isEmpty();
    }
}

