/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.FieldAccess;
import edu.umd.cs.findbugs.ba.bcp.FieldVariable;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.Variable;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public class Load
extends FieldAccess {
    public Load(String fieldVarName, String resultVarName) {
        super(fieldVarName, resultVarName);
    }

    @Override
    public MatchResult match(InstructionHandle handle, ConstantPoolGen cpg, ValueNumberFrame before, ValueNumberFrame after, BindingSet bindingSet) throws DataflowAnalysisException {
        FieldVariable field;
        GETFIELD fieldIns;
        Instruction ins = handle.getInstruction();
        if (ins instanceof GETFIELD) {
            fieldIns = (GETFIELD)ins;
            ValueNumber ref = (ValueNumber)before.getTopValue();
            field = new FieldVariable(ref, fieldIns.getClassName(cpg), fieldIns.getFieldName(cpg), fieldIns.getSignature(cpg));
        } else if (ins instanceof GETSTATIC) {
            fieldIns = (GETSTATIC)ins;
            field = new FieldVariable(fieldIns.getClassName(cpg), fieldIns.getFieldName(cpg), fieldIns.getSignature(cpg));
        } else {
            return null;
        }
        Variable result = Load.snarfFieldValue((FieldInstruction)fieldIns, cpg, after);
        return this.checkConsistent(field, result, bindingSet);
    }
}

