/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.bcp;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.bcp.BindingSet;
import edu.umd.cs.findbugs.ba.bcp.LocalVariable;
import edu.umd.cs.findbugs.ba.bcp.MatchResult;
import edu.umd.cs.findbugs.ba.bcp.OneVariableInstruction;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public class IfNull
extends OneVariableInstruction
implements EdgeTypes {
    public IfNull(String varName) {
        super(varName);
    }

    @Override
    public MatchResult match(InstructionHandle handle, ConstantPoolGen cpg, ValueNumberFrame before, ValueNumberFrame after, BindingSet bindingSet) throws DataflowAnalysisException {
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof IFNULL) && !(ins instanceof IFNONNULL)) {
            return null;
        }
        LocalVariable ref = new LocalVariable((ValueNumber)before.getTopValue());
        return this.addOrCheckDefinition(ref, bindingSet);
    }

    @Override
    public boolean acceptBranch(Edge edge, InstructionHandle source) {
        boolean isIfNull = source.getInstruction() instanceof IFNULL;
        return edge.getType() == (isIfNull ? 1 : 0);
    }
}

