/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.ElementValue;

public class JCIPAnnotationDatabase {
    Map<ClassMember, Map<String, ElementValue>> memberAnnotations = new HashMap<ClassMember, Map<String, ElementValue>>();
    Map<String, Map<String, ElementValue>> classAnnotations = new HashMap<String, Map<String, ElementValue>>();

    @CheckForNull
    public ElementValue getClassAnnotation(@DottedClassName String dottedClassName, String annotationClass) {
        Map<String, ElementValue> map = this.getEntryForClass(dottedClassName);
        return map == null ? null : map.get(annotationClass);
    }

    public boolean hasClassAnnotation(@DottedClassName String dottedClassName, String annotationClass) {
        assert (dottedClassName.indexOf(47) == -1);
        Map<String, ElementValue> map = this.getEntryForClass(dottedClassName);
        return map != null && map.containsKey(annotationClass);
    }

    @CheckForNull
    public ElementValue getFieldAnnotation(XField field, String annotationClass) {
        Map<String, ElementValue> map = this.getEntryForClassMember(field);
        return map == null ? null : map.get(annotationClass);
    }

    public boolean hasFieldAnnotation(XField field, String annotationClass) {
        Map<String, ElementValue> map = this.getEntryForClassMember(field);
        return map != null && map.containsKey(annotationClass);
    }

    @CheckForNull
    public ElementValue getMethodAnnotation(XMethod method, String annotationClass) {
        Map<String, ElementValue> map = this.getEntryForClassMember(method);
        return map == null ? null : map.get(annotationClass);
    }

    public boolean hasMethodAnnotation(XMethod method, String annotationClass) {
        Map<String, ElementValue> map = this.getEntryForClassMember(method);
        return map != null && map.containsKey(annotationClass);
    }

    @CheckForNull
    private Map<String, ElementValue> getEntryForClassMember(ClassMember member) {
        return this.memberAnnotations.get(member);
    }

    public void addEntryForClassMember(ClassMember member, String annotationClass, ElementValue value) {
        Map<String, ElementValue> map = this.memberAnnotations.get(member);
        if (map == null) {
            map = new HashMap<String, ElementValue>();
            this.memberAnnotations.put(member, map);
        }
        map.put(annotationClass, value);
    }

    @CheckForNull
    private Map<String, ElementValue> getEntryForClass(@DottedClassName String dottedClassName) {
        assert (dottedClassName.indexOf(47) == -1);
        return this.classAnnotations.get(dottedClassName);
    }

    public void addEntryForClass(@DottedClassName String dottedClassName, String annotationClass, ElementValue value) {
        Map<String, ElementValue> map = this.getEntryForClass(dottedClassName);
        if (map == null) {
            map = new HashMap<String, ElementValue>(3);
            this.classAnnotations.put(dottedClassName, map);
        }
        map.put(annotationClass, value);
    }
}

