/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.tree;

import org.xerial.core.XerialException;
import org.xerial.util.ArrayDeque;
import org.xerial.util.Deque;
import org.xerial.util.log.Logger;
import org.xerial.util.tree.TreeEvent;
import org.xerial.util.tree.TreeNode;
import org.xerial.util.tree.TreeStreamReader;
import org.xerial.util.tree.TreeVisitor;
import org.xerial.util.tree.TreeWalker;
import org.xerial.util.tree.impl.TreeNodeImpl;

public class TreeWalkerImpl
implements TreeWalker {
    private static Logger _logger = Logger.getLogger(TreeWalkerImpl.class);
    private final TreeStreamReader walker;
    private final Deque<TreeEvent> eventQueue = new ArrayDeque<TreeEvent>();
    private TreeEvent last;
    private int currentLevel = 0;

    public TreeWalkerImpl(TreeStreamReader treeStreamReader) {
        this.walker = treeStreamReader;
    }

    @Override
    public TreeNode getSubTree() throws XerialException {
        if (_logger.isTraceEnabled()) {
            _logger.trace("get subtree");
        }
        int n = this.currentLevel;
        TreeBuilder treeBuilder = new TreeBuilder(this.last);
        TreeEvent treeEvent = null;
        while ((treeEvent = this.walker.peekNext()) != null) {
            switch (treeEvent.event) {
                case VISIT: {
                    ++this.currentLevel;
                    treeBuilder.startNode(treeEvent);
                    break;
                }
                case LEAVE: {
                    --this.currentLevel;
                    if (this.currentLevel < n) {
                        return treeBuilder.root;
                    }
                    treeBuilder.endNode(treeEvent);
                    break;
                }
                case TEXT: {
                    treeBuilder.text(treeEvent);
                }
            }
            this.walker.next();
        }
        return treeBuilder.root;
    }

    @Override
    public void skipDescendants() throws XerialException {
        if (_logger.isTraceEnabled()) {
            _logger.trace("skip descendants");
        }
        int n = this.currentLevel;
        TreeEvent treeEvent = null;
        while ((treeEvent = this.walker.next()) != null) {
            switch (treeEvent.event) {
                case VISIT: {
                    ++this.currentLevel;
                    break;
                }
                case LEAVE: {
                    if (this.currentLevel == n) {
                        this.eventQueue.addLast(treeEvent);
                        return;
                    }
                    --this.currentLevel;
                }
            }
        }
    }

    @Override
    public void walk(TreeVisitor treeVisitor) throws XerialException {
        treeVisitor.init(this);
        while (this.hasNext()) {
            this.processEvent(this.eventQueue.removeFirst(), treeVisitor);
        }
        treeVisitor.finish(this);
    }

    private boolean hasNext() throws XerialException {
        if (this.eventQueue.isEmpty()) {
            TreeEvent treeEvent = this.walker.next();
            if (treeEvent == null) {
                return false;
            }
            this.eventQueue.addLast(treeEvent);
            return true;
        }
        return true;
    }

    private void processEvent(TreeEvent treeEvent, TreeVisitor treeVisitor) throws XerialException {
        if (_logger.isTraceEnabled()) {
            _logger.trace(treeEvent);
        }
        this.last = treeEvent;
        switch (treeEvent.event) {
            case VISIT: {
                treeVisitor.visitNode(treeEvent.nodeName, treeEvent.nodeValue, this);
                ++this.currentLevel;
                break;
            }
            case LEAVE: {
                treeVisitor.leaveNode(treeEvent.nodeName, this);
                --this.currentLevel;
                break;
            }
            case TEXT: {
                treeVisitor.text(treeEvent.nodeName, treeEvent.nodeValue, this);
            }
        }
    }

    private static class TreeBuilder {
        public final TreeNodeImpl root;
        public Deque<TreeNodeImpl> nodeStack = new ArrayDeque<TreeNodeImpl>();

        public TreeBuilder(TreeEvent treeEvent) {
            this.root = new TreeNodeImpl(treeEvent.nodeName, treeEvent.nodeValue);
            this.nodeStack.add(this.root);
        }

        public void startNode(TreeEvent treeEvent) {
            TreeNodeImpl treeNodeImpl = new TreeNodeImpl(treeEvent.nodeName, treeEvent.nodeValue);
            TreeNodeImpl treeNodeImpl2 = this.nodeStack.getLast();
            treeNodeImpl2.addNode(treeNodeImpl);
            this.nodeStack.addLast(treeNodeImpl);
        }

        public void endNode(TreeEvent treeEvent) {
            this.nodeStack.removeLast();
        }

        public void text(TreeEvent treeEvent) {
            TreeNodeImpl treeNodeImpl = this.nodeStack.getLast();
            if (treeNodeImpl.getNodeValue() == null) {
                treeNodeImpl.setNodeValue(treeEvent.nodeValue);
            } else {
                treeNodeImpl.setNodeValue(treeNodeImpl.getNodeValue() + treeEvent.nodeValue);
            }
        }
    }
}

