/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.opt.impl;

import java.lang.reflect.Field;
import org.xerial.core.XerialException;
import org.xerial.util.ReflectionUtil;
import org.xerial.util.TypeInfo;
import org.xerial.util.opt.OptionParserException;
import org.xerial.util.opt.impl.OptionSetter;

public class OptionSetterViaField
implements OptionSetter {
    private final Field field;

    public OptionSetterViaField(Field field) {
        this.field = field;
    }

    @Override
    public Class<?> getOptionDataType() {
        return this.field.getType();
    }

    @Override
    public void setOption(Object object, Object object2) throws XerialException {
        ReflectionUtil.setFieldValue(object, this.field, object2);
    }

    @Override
    public boolean takesArgument() {
        Class<?> clazz = this.getOptionDataType();
        return !TypeInfo.isBoolean(clazz);
    }

    @Override
    public void initialize(Object object) throws OptionParserException {
        try {
            ReflectionUtil.initializeCollectionField(object, this.field);
        }
        catch (XerialException xerialException) {
            throw new OptionParserException(xerialException);
        }
    }

    @Override
    public String getParameterName() {
        return this.field.getName();
    }
}

