/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.xerial.util.ArrayDeque;
import org.xerial.util.UTF8String;

public class BufferedScanner {
    private static final Charset UTF8 = Charset.forName("UTF8");
    public static final int EOF = -1;
    private Buffer buffer;
    private int bufferLimit = 0;
    private boolean reachedEOF = false;
    private ArrayDeque<ScannerState> markQueue = new ArrayDeque();
    private ScannerState current;

    public BufferedScanner(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public BufferedScanner(InputStream inputStream, int n) {
        this(new ByteBuffer(inputStream, n));
        if (inputStream == null) {
            throw new NullPointerException("input is null");
        }
    }

    public BufferedScanner(Reader reader) {
        this(reader, 8192);
    }

    public BufferedScanner(Reader reader, int n) {
        this(new CharBuffer(reader, n));
        if (reader == null) {
            throw new NullPointerException("input is null");
        }
    }

    public BufferedScanner(Buffer buffer) {
        this.buffer = buffer;
        this.current = new ScannerState();
    }

    public BufferedScanner(CharSequence charSequence) {
        this.buffer = charSequence.getClass() == UTF8String.class ? new ByteBuffer(((UTF8String)charSequence).getBytes()) : new CharBuffer(charSequence);
        this.bufferLimit = this.buffer.length();
        this.current = new ScannerState();
        this.reachedEOF = true;
    }

    public BufferedScanner(String string) {
        this(new ByteBuffer(string.getBytes()));
        this.bufferLimit = this.buffer.length();
        this.reachedEOF = true;
    }

    public BufferedScanner(UTF8String uTF8String) {
        this(new ByteBuffer(uTF8String.getBytes()));
        this.bufferLimit = this.buffer.length();
        this.reachedEOF = true;
    }

    public void close() throws IOException {
        this.buffer.close();
    }

    public boolean hasReachedEOF() {
        return this.reachedEOF && this.current.cursor >= this.bufferLimit;
    }

    public CharSequence nextLine() throws IOException {
        ArrayBuilder arrayBuilder = null;
        while (true) {
            int n;
            if (this.current.cursor >= this.bufferLimit) {
                this.fill();
            }
            if (this.current.cursor >= this.bufferLimit) {
                if (arrayBuilder != null && arrayBuilder.size() > 0) {
                    return arrayBuilder.toRawString();
                }
                return null;
            }
            boolean bl = false;
            int n2 = -1;
            for (n = this.current.cursor; n < this.bufferLimit; ++n) {
                n2 = this.buffer.get(n);
                if (n2 != 10 && n2 != 13) continue;
                bl = true;
                break;
            }
            int n3 = this.current.cursor;
            int n4 = n - n3;
            this.current.cursor = n + 1;
            if (bl) {
                if (n2 == 13 && this.LA(1) == 10) {
                    ++this.current.cursor;
                }
                if (arrayBuilder == null) {
                    return this.buffer.toRawString(n3, n4);
                }
                arrayBuilder.append(this.buffer, n3, n4);
                return arrayBuilder != null && arrayBuilder.size() > 0 ? arrayBuilder.toRawString() : null;
            }
            if (arrayBuilder == null) {
                arrayBuilder = this.buffer.newBuilder(16);
            }
            arrayBuilder.append(this.buffer, n3, n4);
        }
    }

    public int consume() throws IOException {
        if (this.current.cursor >= this.bufferLimit && !this.fill()) {
            return -1;
        }
        int n = this.buffer.get(this.current.cursor++);
        return n;
    }

    public int LA(int n) throws IOException {
        if (this.current.cursor + n - 1 >= this.bufferLimit && !this.fill()) {
            return -1;
        }
        return this.buffer.get(this.current.cursor + n - 1);
    }

    private boolean fill() throws IOException {
        int n;
        if (this.reachedEOF) {
            return false;
        }
        if (!this.markQueue.isEmpty()) {
            ScannerState scannerState = this.markQueue.peekFirst();
            n = this.bufferLimit - scannerState.cursor;
            if (n < this.buffer.length()) {
                if (n > 0) {
                    this.buffer.slide(scannerState.cursor, n);
                }
                this.bufferLimit = n;
                this.current.cursor -= scannerState.cursor;
                int n2 = scannerState.cursor;
                for (ScannerState scannerState2 : this.markQueue) {
                    scannerState2.cursor -= n2;
                }
            } else {
                this.markQueue.clear();
                this.bufferLimit = 0;
                this.current.cursor = 0;
            }
        } else {
            this.bufferLimit = 0;
            this.current.cursor = 0;
        }
        int n3 = this.buffer.length() - this.bufferLimit;
        n = this.buffer.feed(this.current.cursor, n3);
        if (n < n3) {
            this.reachedEOF = true;
        }
        if (n == -1) {
            return false;
        }
        this.bufferLimit += n;
        return true;
    }

    public Range getSelectedRange() {
        if (this.markQueue.isEmpty()) {
            throw new NullPointerException("no mark is set");
        }
        return new Range(this.markQueue.getLast().cursor, this.current.cursor);
    }

    public CharSequence selectedRawString() {
        Range range = this.getSelectedRange();
        return this.buffer.toRawString(range.begin, range.size());
    }

    public CharSequence selectedRawStringWithTrimming() {
        Range range = this.trim(this.getSelectedRange());
        return this.buffer.toRawString(range.begin, range.size());
    }

    Range trim(Range range) {
        int n;
        int n2;
        int n3 = range.end;
        for (n2 = range.begin; n2 < n3 && ((n = this.buffer.get(n2)) == 32 || n == 9 || n == 13 || n == 10); ++n2) {
        }
        while (n2 < n3 && ((n = this.buffer.get(n3 - 1)) == 32 || n == 9 || n == 13 || n == 10)) {
            --n3;
        }
        if (n2 >= n3) {
            n2 = n3;
        }
        n = n3 - n2;
        return new Range(n2, n3);
    }

    Range trim() {
        return this.trim(this.getSelectedRange());
    }

    public CharSequence selectedRawString(int n) {
        if (this.markQueue.isEmpty()) {
            return null;
        }
        Range range = this.getSelectedRange();
        Range range2 = new Range(range.begin + n, range.end - n);
        return this.buffer.toRawString(range2.begin, range2.size());
    }

    public CharSequence selectedRawStringFromFirstMark() {
        Range range = new Range(this.markQueue.peekFirst().cursor, this.current.cursor);
        return this.buffer.toRawString(range.begin, range.size());
    }

    public int distanceFromFirstMark() {
        return this.current.cursor - this.markQueue.peekFirst().cursor;
    }

    public void mark() {
        this.markQueue.add(new ScannerState(this.current));
    }

    public void resetMarks() {
        this.markQueue.clear();
    }

    public void rewind() {
        this.current = this.markQueue.pollLast();
    }

    private static class Range {
        public final int begin;
        public final int end;

        public Range(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        public int size() {
            return this.end - this.begin;
        }

        public String toString() {
            return String.format("[%d,%d)", this.begin, this.end);
        }
    }

    private static class ScannerState {
        public int cursor = 0;

        public ScannerState() {
        }

        public ScannerState(ScannerState scannerState) {
            this.cursor = scannerState.cursor;
        }

        public String toString() {
            return String.format("%d", this.cursor);
        }
    }

    private static class CharBuffer
    implements Buffer {
        Reader source;
        char[] buffer;

        public CharBuffer(Reader reader, int n) {
            this.source = reader;
            this.buffer = new char[n];
        }

        public CharBuffer(CharSequence charSequence) {
            this.source = null;
            this.buffer = new char[charSequence.length()];
            for (int i = 0; i < charSequence.length(); ++i) {
                this.buffer[i] = charSequence.charAt(i);
            }
        }

        @Override
        public int get(int n) {
            return this.buffer[n];
        }

        @Override
        public int length() {
            return this.buffer.length;
        }

        @Override
        public int feed(int n, int n2) throws IOException {
            if (this.source == null) {
                return -1;
            }
            return this.source.read(this.buffer, n, n2);
        }

        @Override
        public void close() throws IOException {
            if (this.source != null) {
                this.source.close();
            }
        }

        @Override
        public void slide(int n, int n2) {
            System.arraycopy(this.buffer, n, this.buffer, 0, n2);
        }

        @Override
        public CharSequence toRawString(int n, int n2) {
            return new String(this.buffer, n, n2);
        }

        @Override
        public ArrayBuilder newBuilder(int n) {
            return new CharArrayBuilder(n);
        }
    }

    private static class ByteBuffer
    implements Buffer {
        InputStream source;
        byte[] buffer;

        public ByteBuffer(InputStream inputStream, int n) {
            this.source = inputStream;
            this.buffer = new byte[n];
        }

        public ByteBuffer(byte[] byArray) {
            this.buffer = byArray;
        }

        @Override
        public int get(int n) {
            return this.buffer[n];
        }

        @Override
        public int length() {
            return this.buffer.length;
        }

        @Override
        public CharSequence toRawString(int n, int n2) {
            return new UTF8String(this.buffer, n, n2);
        }

        @Override
        public int feed(int n, int n2) throws IOException {
            if (this.source == null) {
                return -1;
            }
            return this.source.read(this.buffer, n, n2);
        }

        @Override
        public void close() throws IOException {
            if (this.source != null) {
                this.source.close();
            }
        }

        @Override
        public void slide(int n, int n2) {
            System.arraycopy(this.buffer, n, this.buffer, 0, n2);
        }

        @Override
        public ArrayBuilder newBuilder(int n) {
            return new ByteArrayBuilder(n);
        }
    }

    private static class CharArrayBuilder
    implements ArrayBuilder {
        StringBuilder out;

        public CharArrayBuilder(int n) {
            this.out = new StringBuilder(n);
        }

        @Override
        public void append(Buffer buffer, int n, int n2) {
            this.out.append(((CharBuffer)buffer).buffer, n, n2);
        }

        @Override
        public CharSequence toRawString() {
            return new UTF8String(this.out.toString());
        }

        @Override
        public int size() {
            return this.out.length();
        }
    }

    private static class ByteArrayBuilder
    implements ArrayBuilder {
        ByteArrayOutputStream out;

        public ByteArrayBuilder(int n) {
            this.out = new ByteArrayOutputStream(n);
        }

        @Override
        public void append(Buffer buffer, int n, int n2) {
            this.out.write(((ByteBuffer)buffer).buffer, n, n2);
        }

        @Override
        public CharSequence toRawString() {
            return new UTF8String(this.out.toByteArray());
        }

        @Override
        public int size() {
            return this.out.size();
        }
    }

    private static interface ArrayBuilder {
        public void append(Buffer var1, int var2, int var3);

        public CharSequence toRawString();

        public int size();
    }

    private static interface Buffer {
        public int length();

        public int get(int var1);

        public int feed(int var1, int var2) throws IOException;

        public CharSequence toRawString(int var1, int var2);

        public void close() throws IOException;

        public void slide(int var1, int var2);

        public ArrayBuilder newBuilder(int var1);
    }
}

