/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.io;

import org.xerial.core.XerialException;
import org.xerial.util.VariableLengthInteger;
import org.xerial.util.io.DBFile;

public class Buffer {
    private final byte[] buffer;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    public static final int BYTE_SIZE = 1;
    public static final int BOOLEAN_SIZE = 1;

    public Buffer(int n) {
        this.buffer = new byte[n];
    }

    public Buffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    public int size() {
        return this.buffer.length;
    }

    public int readInt(int n) {
        int n2 = (this.buffer[n] & 0xFF) << 24;
        int n3 = (this.buffer[n + 1] & 0xFF) << 16;
        int n4 = (this.buffer[n + 2] & 0xFF) << 8;
        int n5 = this.buffer[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public byte readByte(int n) {
        return this.buffer[n];
    }

    public long readLong(int n) {
        return (long)(this.buffer[n] & 0xFF) << 56 | (long)(this.buffer[n + 1] & 0xFF) << 48 | (long)(this.buffer[n + 2] & 0xFF) << 40 | (long)(this.buffer[n + 3] & 0xFF) << 32 | (long)(this.buffer[n + 4] & 0xFF) << 24 | (long)(this.buffer[n + 5] & 0xFF) << 16 | (long)(this.buffer[n + 6] & 0xFF) << 8 | (long)(this.buffer[n + 7] & 0xFF);
    }

    public boolean readBoolean(int n) {
        return this.readByte(n) > 0;
    }

    public VariableLengthInteger readVariableLengthInteger(int n) throws XerialException {
        return new VariableLengthInteger(this.buffer, n);
    }

    public boolean isSet(int n, int n2) {
        assert (n2 >= 0 && n2 < 8);
        return (this.buffer[n] & 128 >> n2) != 0;
    }

    public void set(int n, int n2, boolean bl) {
        assert (n2 >= 0 && n2 < 8);
        this.buffer[n] = bl ? (byte)(this.buffer[n] | 128 >> n2) : (byte)(this.buffer[n] & ~(128 >> n2));
    }

    public void writeByte(int n, int n2) {
        this.buffer[n] = (byte)n2;
    }

    public void writeInt(int n, int n2) {
        this.buffer[n++] = (byte)(n2 >> 24 & 0xFF);
        this.buffer[n++] = (byte)(n2 >> 16 & 0xFF);
        this.buffer[n++] = (byte)(n2 >> 8 & 0xFF);
        this.buffer[n++] = (byte)(n2 >> 0 & 0xFF);
    }

    public void writeLong(int n, long l) {
        this.buffer[n++] = (byte)(0xFFL & l >> 56);
        this.buffer[n++] = (byte)(0xFFL & l >> 48);
        this.buffer[n++] = (byte)(0xFFL & l >> 40);
        this.buffer[n++] = (byte)(0xFFL & l >> 32);
        this.buffer[n++] = (byte)(0xFFL & l >> 24);
        this.buffer[n++] = (byte)(0xFFL & l >> 16);
        this.buffer[n++] = (byte)(0xFFL & l >> 8);
        this.buffer[n++] = (byte)(0xFFL & l);
    }

    public void writeBoolean(int n, boolean bl) {
        this.writeByte(n, bl ? 1 : 0);
    }

    public void writeVariablenLengthInteger(int n, VariableLengthInteger variableLengthInteger) {
        byte[] byArray = variableLengthInteger.getByte();
        for (int i = 0; i < byArray.length; ++i) {
            this.buffer[n + i] = byArray[i];
        }
    }

    public void save(DBFile dBFile) throws XerialException {
        dBFile.write(this.buffer, 0, this.buffer.length);
    }

    public void load(DBFile dBFile) throws XerialException {
        dBFile.read(this.buffer, 0, this.buffer.length);
    }
}

