/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.ArrayList;
import java.util.HashMap;
import org.xerial.util.BitVector;
import org.xerial.util.IndexedSet;
import org.xerial.util.graph.LatticeCursor;
import org.xerial.util.graph.LatticeNode;

public class Lattice<T> {
    private IndexedSet<T> elementSet = new IndexedSet();
    private IndexedSet<LatticeNode<T>> latticeNodeSet = new IndexedSet();
    private ArrayList<HashMap<T, LatticeNode<T>>> outEdgeIndexTable = new ArrayList();
    private ArrayList<HashMap<T, LatticeNode<T>>> inEdgeIndexTable = new ArrayList();
    private final LatticeNode<T> emptySet = this.newLatticeNode(new BitVector());

    private HashMap<T, LatticeNode<T>> getOutEdgeIndex(int n) {
        assert (n >= 0);
        return this.outEdgeIndexTable.get(n);
    }

    private HashMap<T, LatticeNode<T>> getInEdgeIndex(int n) {
        assert (n >= 0);
        return this.inEdgeIndexTable.get(n);
    }

    LatticeNode<T> next(LatticeNode<T> latticeNode, T t) {
        int n = latticeNode.getID();
        HashMap<T, LatticeNode<T>> hashMap = this.getOutEdgeIndex(n);
        LatticeNode<T> latticeNode2 = hashMap.get(t);
        if (latticeNode2 != null) {
            return latticeNode2;
        }
        BitVector bitVector = BitVector.newInstanceWithAnAdditionalBit(latticeNode.getElementOnOffIndicator(), this.elementSet.getIDwithAddition(t));
        for (LatticeNode<T> latticeNode3 : this.latticeNodeSet) {
            if (!latticeNode3.getElementOnOffIndicator().equals(bitVector)) continue;
            this.getOutEdgeIndex(n).put(t, latticeNode3);
            this.getInEdgeIndex(latticeNode3.getID()).put(t, latticeNode);
            return latticeNode3;
        }
        LatticeNode<T> latticeNode4 = this.newLatticeNode(bitVector);
        this.getInEdgeIndex(latticeNode4.getID()).put(t, latticeNode);
        this.getOutEdgeIndex(n).put(t, latticeNode4);
        return latticeNode4;
    }

    LatticeNode<T> back(LatticeNode<T> latticeNode, T t) {
        int n = latticeNode.getID();
        HashMap<T, LatticeNode<T>> hashMap = this.getInEdgeIndex(n);
        LatticeNode<T> latticeNode2 = hashMap.get(t);
        if (latticeNode2 != null) {
            return latticeNode2;
        }
        return this.previousLatticeNode(latticeNode.getElementOnOffIndicator(), t);
    }

    private LatticeNode<T> previousLatticeNode(BitVector bitVector, T t) {
        if (t == null) {
            return this.emptySet;
        }
        int n = this.getElementID(t);
        BitVector bitVector2 = BitVector.newInstance(bitVector);
        bitVector2.off(n);
        for (int i = 0; i < bitVector2.size(); ++i) {
            if (!bitVector2.get(i)) continue;
            T t2 = this.getElementByID(i);
            LatticeNode<T> latticeNode = this.previousLatticeNode(bitVector2, t2);
            return latticeNode.next(t2);
        }
        return this.previousLatticeNode(bitVector2, null);
    }

    protected LatticeNode<T> newLatticeNode(BitVector bitVector) {
        LatticeNode latticeNode = new LatticeNode(this, bitVector);
        int n = this.latticeNodeSet.getIDwithAddition(latticeNode);
        latticeNode.setID(n);
        this.inEdgeIndexTable.add(new HashMap());
        this.outEdgeIndexTable.add(new HashMap());
        assert (n == this.outEdgeIndexTable.size() - 1);
        assert (n == this.inEdgeIndexTable.size() - 1);
        return latticeNode;
    }

    public LatticeNode<T> emptyNode() {
        return this.emptySet;
    }

    public LatticeCursor<T> cursor() {
        return new LatticeCursorImpl<T>(this.emptySet);
    }

    public int getElementID(T t) {
        return this.elementSet.getID(t);
    }

    public T getElementByID(int n) {
        return this.elementSet.getByID(n);
    }

    private static class LatticeCursorImpl<T>
    implements LatticeCursor<T> {
        private LatticeNode<T> currentLatticeNode;

        public LatticeCursorImpl(LatticeNode<T> latticeNode) {
            this.currentLatticeNode = latticeNode;
        }

        @Override
        public LatticeNode<T> reset(LatticeNode<T> latticeNode) {
            this.currentLatticeNode = latticeNode;
            return this.currentLatticeNode;
        }

        @Override
        public LatticeNode<T> back(T t) {
            this.currentLatticeNode = this.currentLatticeNode.back(t);
            return this.currentLatticeNode;
        }

        @Override
        public boolean contains(T t) {
            return this.currentLatticeNode.contains(t);
        }

        @Override
        public LatticeNode<T> next(T t) {
            this.currentLatticeNode = this.currentLatticeNode.next(t);
            return this.currentLatticeNode;
        }

        @Override
        public LatticeNode<T> getNode() {
            return this.currentLatticeNode;
        }

        @Override
        public int getNodeID() {
            return this.currentLatticeNode.getID();
        }
    }
}

