/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.xerial.util.StringUtil;

public class GraphvizHelper {
    private PrintWriter _out;
    private Stack<GraphvizComponent> _componentStack = new Stack();

    public GraphvizHelper(OutputStream outputStream) {
        this._out = new PrintWriter(outputStream);
    }

    public GraphvizHelper(Writer writer) {
        this._out = new PrintWriter(writer);
    }

    public void beginDigraph(String string) {
        this.pushComponent(new Digraph(string));
    }

    public void endDigraph() {
        assert (!this._componentStack.empty());
        GraphvizComponent graphvizComponent = this.popComponent();
        assert (graphvizComponent instanceof Digraph);
        graphvizComponent.leave(this._out);
        this.flush();
    }

    public void node(String string, String string2) {
        this._out.println(String.format("%s [label=\"%s\"];", string, string2.toString()));
    }

    public void node(int n, String string) {
        this._out.println(String.format("%d [label=\"%s\"];", n, string.toString()));
    }

    public void node(String string, Properties properties) {
        this._out.println(String.format("%s [%s]", string, this.format(properties)));
    }

    private String format(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            arrayList.add(String.format("%s=%s", entry.getKey(), entry.getValue()));
        }
        return StringUtil.join(arrayList, ", ");
    }

    public void graphOption(String string) {
        this._out.println(String.format("graph [%s];", string));
    }

    public void edge(String string, String string2) {
        this._out.println(string + " -> " + string2 + ";");
    }

    public void edge(String string, String string2, Properties properties) {
        this._out.println(String.format("%s -> %s [%s];", string, string2, this.format(properties)));
    }

    public void edge(int n, int n2) {
        this._out.println(n + " -> " + n2 + ";");
    }

    public void edge(String string, String string2, String string3) {
        this._out.println(String.format("%s -> %s [label=\"%s\"];", string, string2, string3));
    }

    public void edge(int n, int n2, String string) {
        this._out.println(String.format("%d -> %d [label=\"%s\"];", n, n2, string));
    }

    public void endOutput() {
        while (!this._componentStack.empty()) {
            GraphvizComponent graphvizComponent = this.popComponent();
            graphvizComponent.leave(this._out);
        }
        this._out.flush();
    }

    public void flush() {
        this._out.flush();
    }

    private void pushComponent(GraphvizComponent graphvizComponent) {
        this._componentStack.add(graphvizComponent);
        graphvizComponent.enter(this._out);
    }

    private GraphvizComponent popComponent() {
        assert (!this._componentStack.empty());
        return this._componentStack.pop();
    }

    class Digraph
    extends GraphvizComponent {
        private String _graphName;

        public Digraph(String string) {
            this._graphName = string;
        }

        @Override
        public void enter(PrintWriter printWriter) {
            printWriter.println("digraph " + this._graphName + "{");
        }

        @Override
        public void leave(PrintWriter printWriter) {
            printWriter.println("}");
        }
    }

    class GraphvizComponent {
        GraphvizComponent() {
        }

        public void enter(PrintWriter printWriter) {
        }

        public void leave(PrintWriter printWriter) {
        }
    }
}

