/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.HashMap;
import org.xerial.util.graph.Edge;
import org.xerial.util.graph.Graph;
import org.xerial.util.graph.GraphHelper;

public abstract class DepthFirstSearch<NodeLabel, EdgeLabel> {
    private Graph<NodeLabel, EdgeLabel> _graph;
    private HashMap<NodeLabel, NodeColor> _nodeColor = new HashMap();
    private HashMap<NodeLabel, NodeLabel> _predecessor = new HashMap();
    private int _time;
    private HashMap<NodeLabel, Integer> _discoveryTime = new HashMap();
    private HashMap<NodeLabel, Integer> _finishTime = new HashMap();

    public void run(Graph<NodeLabel, EdgeLabel> graph) {
        this.run(graph, null);
    }

    public void run(Graph<NodeLabel, EdgeLabel> graph, NodeLabel NodeLabel) {
        this._graph = graph;
        for (NodeLabel NodeLabel2 : this._graph.getNodeLabelSet()) {
            this.initializeNode(NodeLabel2);
            this._nodeColor.put(NodeLabel2, NodeColor.WHITE);
            this._predecessor.put(NodeLabel2, NodeLabel2);
        }
        this._time = 0;
        if (NodeLabel != null) {
            this.startNode(NodeLabel);
            this.dfsVisit(NodeLabel);
        }
        for (NodeLabel NodeLabel2 : this._graph.getNodeLabelSet()) {
            NodeColor nodeColor = this._nodeColor.get(NodeLabel2);
            assert (nodeColor != null);
            if (nodeColor != NodeColor.WHITE) continue;
            this.startNode(NodeLabel2);
            this.dfsVisit(NodeLabel2);
        }
    }

    private void dfsVisit(NodeLabel NodeLabel) {
        this.discoverNode(NodeLabel);
        this._nodeColor.put(NodeLabel, NodeColor.GRAY);
        this._discoveryTime.put(NodeLabel, this._time++);
        for (Edge edge : this._graph.getOutEdgeSet(NodeLabel)) {
            this.examineEdge(edge);
            NodeLabel NodeLabel2 = this._graph.getNodeLabel(edge.getDestNodeID());
            NodeColor nodeColor = this._nodeColor.get(NodeLabel2);
            assert (nodeColor != null);
            if (nodeColor == NodeColor.WHITE) {
                this.treeEdge(edge);
                this._predecessor.put(NodeLabel2, NodeLabel);
                this.dfsVisit(NodeLabel2);
                continue;
            }
            if (nodeColor == NodeColor.GRAY) {
                this.backEdge(edge);
                continue;
            }
            if (nodeColor != NodeColor.BLACK) continue;
            this.forwardOrCrossEdge(edge);
        }
        this.finishNode(NodeLabel);
        this._nodeColor.put(NodeLabel, NodeColor.BLACK);
        this._finishTime.put(NodeLabel, this._time++);
    }

    protected NodeLabel getPredecessor(NodeLabel NodeLabel) {
        return this._predecessor.get(NodeLabel);
    }

    protected int getDiscoveryTime(NodeLabel NodeLabel) {
        return this._discoveryTime.get(NodeLabel);
    }

    protected int getFinishTime(NodeLabel NodeLabel) {
        return this._finishTime.get(NodeLabel);
    }

    protected final Graph<NodeLabel, EdgeLabel> getGraph() {
        return this._graph;
    }

    protected EdgeLabel getEdgeLabel(Edge edge) {
        return this._graph.getEdgeLabel(edge);
    }

    protected NodeLabel getSourceNodeLabel(Edge edge) {
        return GraphHelper.getSourceNodeLabel(this._graph, edge);
    }

    protected NodeLabel getDestNodeLabel(Edge edge) {
        return GraphHelper.getDestNodeLabel(this._graph, edge);
    }

    protected String toString(Edge edge) {
        return GraphHelper.toString(this._graph, edge);
    }

    protected abstract void initializeNode(NodeLabel var1);

    protected abstract void startNode(NodeLabel var1);

    protected abstract void discoverNode(NodeLabel var1);

    protected abstract void finishNode(NodeLabel var1);

    protected abstract void examineEdge(Edge var1);

    protected abstract void treeEdge(Edge var1);

    protected abstract void backEdge(Edge var1);

    protected abstract void forwardOrCrossEdge(Edge var1);

    static enum NodeColor {
        WHITE,
        GRAY,
        BLACK;

    }
}

