/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.bean.impl;

import java.util.Vector;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.bean.BeanBinder;
import org.xerial.util.bean.BeanBinderSet;
import org.xerial.util.bean.BeanUtil;
import org.xerial.util.bean.impl.BeanStreamReader;
import org.xerial.util.bean.impl.BindRuleGenerator;
import org.xerial.util.bean.impl.CollectionAdder;
import org.xerial.util.bean.impl.MapPutter;

public class BindRuleGeneratorForBeanStream<E>
implements BindRuleGenerator {
    private final Class<E> targetBeanClass;
    private String className;
    private final BeanBinderSet binderSetForTargetBean;

    public BindRuleGeneratorForBeanStream(Class<E> clazz) throws XerialException {
        this(clazz, clazz.getSimpleName());
    }

    public BindRuleGeneratorForBeanStream(Class<E> clazz, String string) throws XerialException {
        this.targetBeanClass = clazz;
        this.className = string.toLowerCase();
        try {
            this.binderSetForTargetBean = new MyBeanBinderSet();
        }
        catch (SecurityException securityException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvalidBeanClass, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvalidBeanClass, (Throwable)noSuchMethodException);
        }
    }

    @Override
    public <T> BeanBinderSet getBeanBinderSet(Class<T> clazz) throws XerialException {
        if (BeanStreamReader.class.isAssignableFrom(clazz)) {
            return this.binderSetForTargetBean;
        }
        return BeanUtil.getBeanLoadRule(clazz);
    }

    class MyBeanBinderSet
    implements BeanBinderSet {
        private CollectionAdder adder;

        public MyBeanBinderSet() throws XerialException, SecurityException, NoSuchMethodException {
            this.adder = new CollectionAdder(BeanStreamReader.class.getMethod("add", Object.class), BindRuleGeneratorForBeanStream.this.className, BindRuleGeneratorForBeanStream.this.targetBeanClass);
        }

        @Override
        public void addRule(BeanBinder beanBinder) {
            throw new UnsupportedOperationException("addRule");
        }

        @Override
        public BeanBinder findRule(String string) {
            if (string.equals(BindRuleGeneratorForBeanStream.this.className)) {
                return this.adder;
            }
            return null;
        }

        @Override
        public Vector<BeanBinder> getBindRules() {
            throw new UnsupportedOperationException("getBindRules");
        }

        @Override
        public MapPutter getStandardMapPutter() {
            throw new UnsupportedOperationException("getStandardMapPutter");
        }
    }
}

