/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Element;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.ArrayDeque;
import org.xerial.util.Pair;
import org.xerial.util.Triplet;

public class TypeInfo {
    private static Class<?>[] _parameterClass = new Class[]{Integer.TYPE, Double.TYPE, Float.TYPE, Long.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Byte.TYPE, String.class, Integer.class, Double.class, Float.class, Long.class, Boolean.class, Character.class, Short.class, Byte.class, Date.class, File.class};
    private static HashSet<Class<?>> basicTypeSet = new HashSet();
    private static ConcurrentHashMap<Class<?>, Constructor<?>> constructorTable;

    private TypeInfo() {
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (clazz.isArray()) {
            return basicTypeSet.contains(clazz.getComponentType());
        }
        if (clazz.isEnum()) {
            return true;
        }
        return basicTypeSet.contains(clazz);
    }

    public static Class<?> getArrayElementType(Class<?> clazz) {
        if (!TypeInfo.isArray(clazz)) {
            return null;
        }
        return clazz.getComponentType();
    }

    public static boolean isIterable(Class<?> clazz) {
        return Iterable.class.isAssignableFrom(clazz);
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isSet(Class<?> clazz) {
        return Set.class.isAssignableFrom(clazz);
    }

    public static boolean isSortedSet(Class<?> clazz) {
        return SortedSet.class.isAssignableFrom(clazz);
    }

    public static boolean isSortedMap(Class<?> clazz) {
        return SortedMap.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isQueue(Class<?> clazz) {
        return Queue.class.isAssignableFrom(clazz);
    }

    public static boolean isEnum(Class<?> clazz) {
        return clazz.isEnum();
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    public static boolean isString(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz);
    }

    public static boolean isDOMElement(Class<?> clazz) {
        return Element.class.isAssignableFrom(clazz);
    }

    public static boolean isPair(Class<?> clazz) {
        return Pair.class.isAssignableFrom(clazz);
    }

    public static boolean isTriplet(Class<?> clazz) {
        return Triplet.class.isAssignableFrom(clazz);
    }

    public static boolean hasDefaultConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPublicDefaultConstructor(Class<?> clazz) {
        return TypeInfo.getPublicDefaultConstructor(clazz) != null;
    }

    public static Constructor<?> getPublicDefaultConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return constructor;
        }
        return null;
    }

    public static boolean canInstantiate(Class<?> clazz) {
        return TypeInfo.isBasicType(clazz) || TypeInfo.alternateConstractableClassFor(clazz) != null;
    }

    private static <T> Class<T> alternateConstractableClassFor(Class<T> clazz) {
        if (TypeInfo.hasPublicDefaultConstructor(clazz)) {
            return clazz;
        }
        if (TypeInfo.isCollection(clazz)) {
            if (TypeInfo.isSet(clazz)) {
                if (TypeInfo.isSortedSet(clazz)) {
                    return TreeSet.class;
                }
                return LinkedHashSet.class;
            }
            if (TypeInfo.isQueue(clazz)) {
                return ArrayDeque.class;
            }
            return ArrayList.class;
        }
        if (TypeInfo.isMap(clazz)) {
            if (TypeInfo.isSortedMap(clazz)) {
                return TreeMap.class;
            }
            return LinkedHashMap.class;
        }
        return null;
    }

    public static <T> Object createPrimitiveTypeInstance(Class<T> clazz) throws XerialException {
        if (!clazz.isPrimitive()) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvalidType, String.format("%s is not a primitive", clazz.getSimpleName()));
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 1L;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private static <T> Object createInstance(Constructor<?> constructor) throws XerialException {
        try {
            Class<?>[] classArray = constructor.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                objectArray[i] = TypeInfo.createInstance(classArray[i]);
            }
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new XerialException((ErrorCode)XerialErrorCode.InstantiationFailure, (Throwable)exception);
        }
    }

    public static <T> T createInstance(Class<T> clazz) throws XerialException {
        if (clazz.isPrimitive()) {
            return (T)TypeInfo.createPrimitiveTypeInstance(clazz);
        }
        try {
            Constructor<?> constructor = constructorTable.get(clazz);
            if (constructor != null) {
                return (T)TypeInfo.createInstance(constructor);
            }
            assert (constructor == null);
            Class<T> clazz2 = TypeInfo.alternateConstractableClassFor(clazz);
            if (clazz2 != null) {
                constructor = TypeInfo.getPublicDefaultConstructor(clazz2);
                assert (constructor != null);
                constructorTable.put(clazz, constructor);
                return clazz2.newInstance();
            }
            for (Constructor<?> constructor2 : clazz.getConstructors()) {
                try {
                    Object object = TypeInfo.createInstance(constructor2);
                    constructorTable.put(clazz, constructor2);
                    return (T)object;
                }
                catch (Exception exception) {
                }
            }
            for (Constructor<?> constructor2 : clazz.getDeclaredConstructors()) {
                try {
                    constructor2.setAccessible(true);
                    Object object = TypeInfo.createInstance(constructor2);
                    constructorTable.put(clazz, constructor2);
                    return (T)object;
                }
                catch (Exception exception) {
                }
            }
            throw new XerialException((ErrorCode)XerialErrorCode.NoPublicConstructor, "No public constructor for the class: " + clazz.getName() + " is available");
        }
        catch (InstantiationException instantiationException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InstantiationFailure, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XerialException((ErrorCode)XerialErrorCode.IllegalAccess, (Throwable)illegalAccessException);
        }
    }

    public static Class<?> getElementTypeOfCollection(Class<? extends Collection<?>> clazz) {
        return null;
    }

    public static ParameterizedType getParameterizedType(Type type) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType;
        }
        if (type instanceof Class) {
            return TypeInfo.getParameterizedType(((Class)type).getGenericSuperclass());
        }
        return null;
    }

    public static ParameterizedType getParentParameterizedType(Type type, Class clazz) {
        Type type2;
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType && clazz.isAssignableFrom((Class)(type2 = (ParameterizedType)type).getRawType())) {
            return type2;
        }
        if (type instanceof Class) {
            type2 = (Class)type;
            return TypeInfo.getParentParameterizedType(((Class)type2).getGenericSuperclass(), clazz);
        }
        return null;
    }

    public static Class<?> resolveRawType(Type type, Class<?> clazz) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeInfo.resolveRawType(parameterizedType.getRawType(), clazz);
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return clazz;
    }

    public static Class<?> resolveRawType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeInfo.resolveRawType(parameterizedType.getRawType());
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    public static Class<?>[] resolveActualTypeOfMapElement(Type type, Class<?>[] classArray) {
        Type[] typeArray;
        ParameterizedType parameterizedType = TypeInfo.getParentParameterizedType(type, Map.class);
        if (parameterizedType != null && (typeArray = parameterizedType.getActualTypeArguments()).length > 0) {
            return new Class[]{TypeInfo.resolveRawType(typeArray[0], classArray[0]), TypeInfo.resolveRawType(typeArray[1], classArray[1])};
        }
        return classArray;
    }

    static {
        for (Class<?> clazz : _parameterClass) {
            basicTypeSet.add(clazz);
        }
        constructorTable = new ConcurrentHashMap();
    }
}

