/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xerial.util.impl.CSVLineParser;

public class StringUtil {
    public static final String SINGLE_QUOTE = "'";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String NEW_LINE = System.getProperty("line.separator");
    static Pattern _whiteSpacePattern = Pattern.compile("[ \t\n\r]*");
    private static HashMap<String, String> canonicalNameTable = new HashMap();
    private static HashMap<String, String> naturalNameTable = new HashMap();
    private static Pattern paramNameReplacePattern = Pattern.compile("[\\s-_]");

    private StringUtil() {
    }

    public static <T> String join(Collection<T> collection, String string) {
        if (collection == null) {
            return "";
        }
        int n = collection.size();
        if (n == 0) {
            return "";
        }
        Iterator<T> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; iterator.hasNext() && i < n - 1; ++i) {
            T t = iterator.next();
            if (t != null) {
                stringBuilder.append(t.toString());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append(string);
        }
        T t = iterator.next();
        if (t != null) {
            stringBuilder.append(t.toString());
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    public static String join(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "";
        }
        int n = objectArray.length;
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - 1; ++i) {
            Object object = objectArray[i];
            stringBuilder.append(object != null ? object.toString() : "");
            stringBuilder.append(string);
        }
        stringBuilder.append(objectArray[n - 1]);
        return stringBuilder.toString();
    }

    public static String quote(String string, String string2) {
        if (string == null) {
            return string;
        }
        return String.format("%s%s%s", string2, string, string2);
    }

    public static String doubleQuote(String string) {
        return StringUtil.quote(string, DOUBLE_QUOTE);
    }

    public static String unquote(String string) {
        if (string == null) {
            return string;
        }
        if (string.length() > 1 && (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean isWhiteSpace(String string) {
        Matcher matcher = _whiteSpacePattern.matcher(string);
        return matcher.matches();
    }

    public static String concatinateWithTab(Object ... objectArray) {
        return StringUtil.join(objectArray, "\t");
    }

    public static String newline() {
        return NEW_LINE;
    }

    public static String chompNewLine(String string) {
        return string.replaceAll("(\r|\n\r?)$", "");
    }

    public static ArrayList<String> splitAtTab(String string) {
        return StringUtil.split(string, '\t');
    }

    public static ArrayList<String> splitCSV(String string) {
        CSVLineParser cSVLineParser = new CSVLineParser();
        return cSVLineParser.parseLine(string);
    }

    public static ArrayList<String> split(String string, char c) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != c) continue;
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        arrayList.add(string.substring(n, n2));
        return arrayList;
    }

    public static String varNameToCanonicalName(String string) {
        if (string == null) {
            return string;
        }
        String string2 = canonicalNameTable.get(string);
        if (string2 == null) {
            Matcher matcher = paramNameReplacePattern.matcher(string);
            string2 = matcher.replaceAll("").toLowerCase();
            canonicalNameTable.put(string, string2);
        }
        return string2;
    }

    public static String varNameToNaturalName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = naturalNameTable.get(string);
        if (string2 == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                char c;
                while (n2 < string.length() && StringUtil.isPrefix(string.charAt(n2))) {
                    ++n2;
                }
                if (n2 - n >= 2) {
                    arrayList.add(string.substring(n, n2));
                    n = n2;
                    continue;
                }
                while (n2 < string.length() && !StringUtil.isSplitChar(c = string.charAt(n2))) {
                    ++n2;
                }
                if (n < n2) {
                    arrayList.add(string.substring(n, n2).toLowerCase());
                }
                n = ++n2;
            }
            string2 = StringUtil.join(arrayList, " ");
            naturalNameTable.put(string, string2);
        }
        return string2;
    }

    private static boolean isSplitChar(char c) {
        return Character.isUpperCase(c) || c == '_' || c == '-' || c == ' ';
    }

    private static boolean isPrefix(char c) {
        return Character.isUpperCase(c) || Character.isDigit(c);
    }

    public static String[] tokenizeCommandLineArgument(String string) {
        ArrayList<String> arrayList = CommandLineParser.split(string);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = arrayList.get(i);
        }
        return stringArray;
    }

    public static class CommandLineParser {
        private final String arg;
        private int wordStart = 0;
        private int cursor = 0;
        private ArrayList<String> tokens = new ArrayList();

        private CommandLineParser(String string) {
            this.arg = string;
        }

        ArrayList<String> split() {
            while (this.cursor < this.arg.length()) {
                char c = this.arg.charAt(this.cursor);
                switch (c) {
                    case '\"': {
                        this.parseDoubleQuoteString();
                        break;
                    }
                    case '\'': {
                        this.parseSingleQuoteString();
                        break;
                    }
                    case '\\': {
                        this.parseEscapeSequence();
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (this.wordStart < this.cursor) {
                            this.tokens.add(this.arg.substring(this.wordStart, this.cursor));
                        }
                        this.wordStart = this.cursor + 1;
                        break;
                    }
                }
                ++this.cursor;
            }
            if (this.wordStart < this.cursor) {
                this.tokens.add(this.arg.substring(this.wordStart, Math.min(this.cursor, this.arg.length())));
            }
            return this.tokens;
        }

        void parseEscapeSequence() {
            ++this.cursor;
            ++this.cursor;
        }

        void parseDoubleQuoteString() {
            boolean bl = false;
            if (this.wordStart == this.cursor) {
                this.wordStart = this.cursor + 1;
                bl = true;
            }
            ++this.cursor;
            while (this.cursor < this.arg.length()) {
                switch (this.arg.charAt(this.cursor)) {
                    case '\\': {
                        this.parseEscapeSequence();
                        break;
                    }
                    case '\"': {
                        if (this.wordStart < this.cursor) {
                            this.tokens.add(this.arg.substring(this.wordStart, bl ? this.cursor : this.cursor + 1));
                            this.wordStart = this.cursor + 1;
                        }
                        return;
                    }
                }
                ++this.cursor;
            }
        }

        void parseSingleQuoteString() {
            boolean bl = false;
            if (this.wordStart == this.cursor) {
                this.wordStart = this.cursor + 1;
                bl = true;
            }
            ++this.cursor;
            while (this.cursor < this.arg.length()) {
                switch (this.arg.charAt(this.cursor)) {
                    case '\\': {
                        this.parseEscapeSequence();
                        break;
                    }
                    case '\'': {
                        if (this.wordStart < this.cursor) {
                            this.tokens.add(this.arg.substring(this.wordStart, bl ? this.cursor : this.cursor + 1));
                            this.wordStart = this.cursor + 1;
                        }
                        return;
                    }
                }
                ++this.cursor;
            }
        }

        public static ArrayList<String> split(String string) {
            return new CommandLineParser(string).split();
        }
    }
}

