/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.xerial.util.FileResource;
import org.xerial.util.io.VirtualFile;
import org.xerial.util.log.Logger;

public class FileUtil {
    private static Logger _logger = Logger.getLogger(FileUtil.class);
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static File createTempDir(File file, String string) {
        File file2 = new File(file, string);
        int n = 1;
        while (file2.exists()) {
            file2 = new File(file, string + n++);
        }
        file2.mkdirs();
        return file2;
    }

    public static File createTempFile(File file, String string, String string2) throws IOException {
        return File.createTempFile(string, string2, file);
    }

    public static void copyResourceDir(String string, String string2) throws IOException {
        if (_logger.isDebugEnabled()) {
            _logger.debug(String.format("copy from %s to %s", string, string2));
        }
        File file = new File(string2);
        List<VirtualFile> list = FileResource.listResources(string);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        HashSet hashSet = new HashSet();
        for (VirtualFile virtualFile : list) {
            if (hashSet.contains(virtualFile.getLogicalPath())) continue;
            hashSet.add(virtualFile.getLogicalPath());
            arrayList.add(virtualFile);
        }
        if (arrayList.size() <= 0) {
            throw new FileNotFoundException(string + " is not found");
        }
        for (VirtualFile virtualFile : arrayList) {
            String string3 = virtualFile.getLogicalPath();
            if (virtualFile.isDirectory()) {
                FileUtil.mkdirs(new File(file, string3));
                continue;
            }
            String string4 = string3;
            File file2 = new File(file, string4);
            File file3 = file2.getParentFile();
            FileUtil.mkdirs(file3);
            InputStream inputStream = virtualFile.getURL().openStream();
            _logger.debug("create a file: " + file2);
            FileUtil.copy(inputStream, file2);
        }
    }

    public static void mkdirs(File file) {
        if (!file.exists()) {
            _logger.debug("create a dir: " + file);
            file.mkdirs();
        }
    }

    public static void rmdir(File file) {
        if (file.exists()) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    FileUtil.rmdir(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public static void copy(InputStream inputStream, File file) throws IOException {
        FileUtil.copy(inputStream, file, new CopyConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File file, CopyConfig copyConfig) throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        WritableByteChannel writableByteChannel = Channels.newChannel(new FileOutputStream(file));
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocate(copyConfig.BLOCK_SIZE);
            byteBuffer.clear();
            while (readableByteChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        finally {
            if (readableByteChannel != null) {
                readableByteChannel.close();
            }
            if (writableByteChannel != null) {
                writableByteChannel.close();
            }
        }
    }

    public static void copy(File file, File file2) throws IOException {
        FileUtil.copy(file, file2, new CopyConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2, CopyConfig copyConfig) throws IOException {
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            long l;
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            long l2 = fileChannel.size();
            for (long i = 0L; i < l2; i += l) {
                long l3 = l2 - i < (long)copyConfig.BLOCK_SIZE ? l2 - i : (long)copyConfig.BLOCK_SIZE;
                l = fileChannel.transferTo(i, l3, (WritableByteChannel)((Object)abstractInterruptibleChannel));
            }
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public static String sha1(File file) throws IOException {
        return FileUtil.toHexString(FileUtil.sha1hash(file));
    }

    public static String sha1(InputStream inputStream) throws IOException {
        return FileUtil.toHexString(FileUtil.sha1hash(inputStream));
    }

    private static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuilder.append(HEX[by >>> 4 & 0xF]);
            stringBuilder.append(HEX[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static byte[] sha1hash(File file) throws IOException {
        return FileUtil.sha1hash(new BufferedInputStream(new FileInputStream(file)));
    }

    public static byte[] sha1hash(InputStream inputStream) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(20);
            byteArrayOutputStream.write(messageDigest.digest());
            return byteArrayOutputStream.toByteArray();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("SHA-1 algorithm is not available: " + noSuchAlgorithmException);
        }
    }

    public static String md5sum(File file) throws IOException {
        return FileUtil.md5sum(new BufferedInputStream(new FileInputStream(file)));
    }

    public static String md5sum(InputStream inputStream) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(messageDigest.digest());
            String string = byteArrayOutputStream.toString();
            return string;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("MD5 algorithm is not available: " + noSuchAlgorithmException);
        }
        finally {
            inputStream.close();
        }
    }

    public static class CopyConfig {
        public int BLOCK_SIZE = 65536;
    }
}

