/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.xerial.util.BinaryFunctor;
import org.xerial.util.Functor;
import org.xerial.util.Predicate;
import org.xerial.util.StringUtil;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <In> List<String> toString(Collection<In> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (In In : collection) {
            if (In != null) {
                arrayList.add(In.toString());
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public static <In, Out> List<Out> collectFromNonGenericCollection(Iterable<In> iterable, Functor<In, Out> functor) {
        ArrayList<Out> arrayList = new ArrayList<Out>();
        for (In In : iterable) {
            arrayList.add(functor.apply(In));
        }
        return arrayList;
    }

    public static <In> List<In> select(Iterable<In> iterable, Predicate<In> predicate) {
        ArrayList<In> arrayList = new ArrayList<In>();
        for (In In : iterable) {
            if (!predicate.apply(In)) continue;
            arrayList.add(In);
        }
        return arrayList;
    }

    public static <In, Out> List<Out> collect(Iterable<In> iterable, Functor<In, Out> functor) {
        ArrayList<Out> arrayList = new ArrayList<Out>();
        for (In In : iterable) {
            arrayList.add(functor.apply(In));
        }
        return arrayList;
    }

    public static <In, Out> List<Out> collect(In[] InArray, Functor<In, Out> functor) {
        ArrayList<Out> arrayList = new ArrayList<Out>();
        for (In In : InArray) {
            arrayList.add(functor.apply(In));
        }
        return arrayList;
    }

    public static <K, V> List<Object> collect(Map<K, V> map, BinaryFunctor<K, V> binaryFunctor) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (K k : map.keySet()) {
            arrayList.add(binaryFunctor.apply(k, map.get(k)));
        }
        return arrayList;
    }

    public static <K, V> String displayMap(Map<K, V> map, final String string, String string2) {
        return StringUtil.join(CollectionUtil.collect(map, new BinaryFunctor<K, V>(){

            @Override
            public Object apply(K k, V v) {
                return k.toString() + string + v.toString();
            }
        }), ", ");
    }

    public static <E> TreeSet<E> sort(Collection<E> collection) {
        TreeSet<E> treeSet = new TreeSet<E>();
        for (E e : collection) {
            treeSet.add(e);
        }
        return treeSet;
    }

    public static <E> List<E> toList(E[] EArray) {
        ArrayList<E> arrayList = new ArrayList<E>(EArray.length);
        for (int i = 0; i < EArray.length; ++i) {
            arrayList.add(EArray[i]);
        }
        return arrayList;
    }
}

