/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import org.xerial.json.JSONArray;
import org.xerial.json.JSONBoolean;
import org.xerial.json.JSONDouble;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONException;
import org.xerial.json.JSONInteger;
import org.xerial.json.JSONLong;
import org.xerial.json.JSONNull;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONString;
import org.xerial.json.JSONValue;
import org.xerial.json.JSONWriter;
import org.xerial.util.TypeInfo;
import org.xerial.util.lens.ObjectLens;
import org.xerial.util.lens.impl.ParameterGetter;

public class JSONUtil {
    private JSONUtil() {
    }

    public static String toJSON(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (TypeInfo.isBasicType(clazz)) {
            if (clazz == String.class) {
                return JSONString.toJSONString(object.toString());
            }
            return object.toString();
        }
        StringWriter stringWriter = new StringWriter();
        JSONWriter jSONWriter = new JSONWriter(stringWriter);
        JSONUtil.toJSON(jSONWriter, object);
        jSONWriter.flush();
        return stringWriter.toString();
    }

    private static void toJSON(JSONWriter jSONWriter, Object object) {
        Class<?> clazz = object.getClass();
        if (TypeInfo.isBasicType(clazz)) {
            jSONWriter.addObject(object);
            return;
        }
        ObjectLens objectLens = ObjectLens.getObjectLens(object.getClass());
        if (TypeInfo.isCollection(clazz)) {
            Collection collection = (Collection)object;
            boolean bl = objectLens.hasAttributes();
            boolean bl2 = false;
            if (bl) {
                jSONWriter.startObject();
                JSONUtil.outputParemters(jSONWriter, object);
                if (!collection.isEmpty()) {
                    jSONWriter.startArray("entry");
                    bl2 = true;
                }
            } else {
                jSONWriter.startArray();
                bl2 = true;
            }
            for (Object e : collection) {
                JSONUtil.toJSON(jSONWriter, e);
            }
            if (bl2) {
                jSONWriter.endArray();
            }
            if (bl) {
                jSONWriter.endObject();
            }
        } else if (TypeInfo.isMap(clazz)) {
            Map map = (Map)object;
            boolean bl = objectLens.hasAttributes();
            if (bl) {
                jSONWriter.startObject();
                JSONUtil.outputParemters(jSONWriter, object);
                if (!map.isEmpty()) {
                    jSONWriter.startArray("entry");
                }
            } else if (!map.isEmpty()) {
                jSONWriter.startArray();
            }
            for (Map.Entry entry : map.entrySet()) {
                jSONWriter.startObject();
                jSONWriter.putObject("key", entry.getKey());
                jSONWriter.putObject("value", entry.getValue());
                jSONWriter.endObject();
            }
            if (!map.isEmpty()) {
                jSONWriter.endArray();
            }
            if (bl) {
                jSONWriter.endObject();
            }
        } else if (!objectLens.getGetterContainer().isEmpty()) {
            jSONWriter.startObject();
            JSONUtil.outputParemters(jSONWriter, object);
            jSONWriter.endObject();
        } else {
            jSONWriter.startString();
            jSONWriter.append(object.toString());
            jSONWriter.endString();
        }
    }

    private static void outputParemters(JSONWriter jSONWriter, Object object) {
        ObjectLens objectLens = ObjectLens.getObjectLens(object.getClass());
        for (ParameterGetter parameterGetter : objectLens.getGetterContainer()) {
            jSONWriter.putObject(parameterGetter.getCanonicalParamName(), parameterGetter.get(object));
        }
    }

    public static JSONValue toJSONValue(Object object) throws JSONException {
        if (object == null) {
            return JSONNull.NULL;
        }
        if (object instanceof JSONValue) {
            return (JSONValue)object;
        }
        if (object instanceof String) {
            return new JSONString((String)object);
        }
        if (object instanceof Integer) {
            return new JSONInteger((Integer)object);
        }
        if (object instanceof Long) {
            return new JSONLong((Long)object);
        }
        if (object instanceof Double) {
            return new JSONDouble((Double)object);
        }
        if (object instanceof Boolean) {
            return JSONBoolean.toJSONBoolean((Boolean)object);
        }
        if (object instanceof Float) {
            return new JSONDouble(((Float)object).floatValue());
        }
        throw new JSONException(JSONErrorCode.CannotConvertToJSONValue, "cannot resolve " + object + " type as JSONValue");
    }

    public static JSONValue parseJSON(String string) throws JSONException {
        String string2 = string.trim();
        if (string2.startsWith("{")) {
            return JSONObject.parse(string2);
        }
        if (string2.startsWith("[")) {
            return new JSONArray(string2);
        }
        throw new JSONException(JSONErrorCode.InvalidJSONData, "json data must start with { or [");
    }
}

