/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.json.JSONArray;
import org.xerial.json.JSONBoolean;
import org.xerial.json.JSONDouble;
import org.xerial.json.JSONErrorCode;
import org.xerial.json.JSONEvent;
import org.xerial.json.JSONException;
import org.xerial.json.JSONInteger;
import org.xerial.json.JSONLexer;
import org.xerial.json.JSONNull;
import org.xerial.json.JSONObject;
import org.xerial.json.JSONPullParserEvent;
import org.xerial.json.JSONString;
import org.xerial.json.JSONValue;
import org.xerial.json.impl.JSONToken;
import org.xerial.util.ArrayDeque;
import org.xerial.util.log.Logger;

public class JSONPullParser {
    private static Logger _logger = Logger.getLogger(JSONPullParser.class);
    private JSONLexer _lexer;
    private ArrayDeque<ParseState> parseStateStack = new ArrayDeque();
    private ArrayDeque<String> keyStack = new ArrayDeque();
    private JSONPullParserEvent lastReportedEvent = null;
    private int currentDepth = 0;

    public JSONPullParser(String string) {
        this._lexer = new JSONLexer(string);
        this.init();
    }

    public JSONPullParser(InputStream inputStream) throws IOException {
        this._lexer = new JSONLexer(inputStream);
        this.init();
    }

    public JSONPullParser(Reader reader) throws IOException {
        this._lexer = new JSONLexer(reader);
        this.init();
    }

    public JSONPullParser(JSONObject jSONObject) {
        this(jSONObject.toJSONString());
    }

    private void init() {
        this.parseStateStack.clear();
        this.keyStack.clear();
        this.lastReportedEvent = null;
        this.currentDepth = 0;
        this.parseStateStack.addLast(ParseState.Root);
    }

    private ParseState getCurrentParseState() {
        return this.parseStateStack.getLast();
    }

    private void validateParseState(ParseState ... parseStateArray) throws JSONException {
        ParseState parseState = this.getCurrentParseState();
        for (ParseState parseState2 : parseStateArray) {
            if (parseState2 != parseState) continue;
            return;
        }
        throw new JSONException(JSONErrorCode.InvalidJSONData, "invalid parse state: " + parseState.name() + " line = " + this._lexer.getLineNumber());
    }

    private void popKeyStack() {
        if (this.getCurrentParseState() == ParseState.Key) {
            this.keyStack.removeLast();
        }
    }

    private void pushParseState(ParseState parseState) {
        this.parseStateStack.addLast(parseState);
    }

    private void popParseState() {
        this.parseStateStack.removeLast();
    }

    private void valueWithKeyTest() {
        if (this.getCurrentParseState() == ParseState.Key) {
            this.pushParseState(ParseState.KeyedValue);
        }
    }

    public JSONValue getValue() throws JSONException {
        if (this.lastReportedEvent == null) {
            this.next();
        }
        while (this.lastReportedEvent.getEvent() != JSONEvent.EndJSON) {
            switch (this.lastReportedEvent.getEvent()) {
                case String: {
                    return new JSONString(this.getText());
                }
                case Integer: {
                    return new JSONInteger(this.getText());
                }
                case Double: {
                    return new JSONDouble(this.getText());
                }
                case True: {
                    return JSONBoolean.True;
                }
                case False: {
                    return JSONBoolean.False;
                }
                case Null: {
                    return JSONNull.NULL;
                }
                case StartObject: {
                    return this.readJSONObject(new JSONObject(), this.getDepth());
                }
                case StartArray: {
                    return this.readJSONArray(new JSONArray(), this.getDepth());
                }
            }
            this.next();
        }
        throw new JSONException(JSONErrorCode.JSONValueIsNotFound);
    }

    public String getValueAsText() throws JSONException {
        if (this.lastReportedEvent == null) {
            this.next();
        }
        while (this.lastReportedEvent.getEvent() != JSONEvent.EndJSON) {
            switch (this.lastReportedEvent.getEvent()) {
                case String: 
                case Integer: 
                case Double: {
                    return this.getText();
                }
                case True: {
                    return "true";
                }
                case False: {
                    return "false";
                }
                case Null: {
                    return "null";
                }
                case StartObject: {
                    return this.readJSONObject(new JSONObject(), this.getDepth()).toJSONString();
                }
                case StartArray: {
                    return this.readJSONArray(new JSONArray(), this.getDepth()).toJSONString();
                }
            }
            this.next();
        }
        throw new JSONException(JSONErrorCode.JSONValueIsNotFound);
    }

    public void populateJSONObject(JSONObject jSONObject) throws JSONException {
        if (this.lastReportedEvent == null) {
            this.next();
        }
        if (this.lastReportedEvent.getEvent() != JSONEvent.StartObject) {
            throw new JSONException(JSONErrorCode.InvalidJSONData);
        }
        this.readJSONObject(jSONObject, this.getDepth());
    }

    public void populateJSONArray(JSONArray jSONArray) throws JSONException {
        if (this.lastReportedEvent == null) {
            this.next();
        }
        if (this.lastReportedEvent.getEvent() != JSONEvent.StartArray) {
            throw new JSONException(JSONErrorCode.InvalidJSONData);
        }
        this.readJSONArray(jSONArray, this.getDepth());
    }

    JSONObject readJSONObject(JSONObject jSONObject, int n) throws JSONException {
        block10: while (true) {
            JSONEvent jSONEvent = this.next();
            switch (jSONEvent) {
                case StartObject: {
                    jSONObject.put(this.getKeyName(), this.readJSONObject(new JSONObject(), this.getDepth()));
                    continue block10;
                }
                case EndObject: {
                    if (this.getDepth() < n) {
                        return jSONObject;
                    }
                    throw new JSONException(JSONErrorCode.ParseError);
                }
                case StartArray: {
                    jSONObject.put(this.getKeyName(), this.readJSONArray(new JSONArray(), this.getDepth()));
                    continue block10;
                }
                case EndArray: {
                    throw new JSONException(JSONErrorCode.NotInAJSONObject);
                }
                case True: {
                    jSONObject.put(this.getKeyName(), JSONBoolean.True);
                    continue block10;
                }
                case False: {
                    jSONObject.put(this.getKeyName(), JSONBoolean.False);
                    continue block10;
                }
                case Null: {
                    jSONObject.put(this.getKeyName(), JSONNull.NULL);
                    continue block10;
                }
                case String: 
                case Integer: 
                case Double: {
                    jSONObject.put(this.getKeyName(), this.getValue());
                    continue block10;
                }
            }
            break;
        }
        throw new JSONException(JSONErrorCode.UnexpectedEndOfJSON);
    }

    private JSONArray readJSONArray(JSONArray jSONArray, int n) throws JSONException {
        block10: while (true) {
            JSONEvent jSONEvent = this.next();
            switch (jSONEvent) {
                case StartObject: {
                    jSONArray.add(this.readJSONObject(new JSONObject(), this.getDepth()));
                    continue block10;
                }
                case EndObject: {
                    throw new JSONException(JSONErrorCode.ParseError);
                }
                case StartArray: {
                    jSONArray.add(this.readJSONArray(new JSONArray(), this.getDepth()));
                    continue block10;
                }
                case EndArray: {
                    if (this.getDepth() < n) {
                        return jSONArray;
                    }
                    throw new JSONException(JSONErrorCode.ParseError);
                }
                case True: {
                    jSONArray.add(JSONBoolean.True);
                    continue block10;
                }
                case False: {
                    jSONArray.add(JSONBoolean.False);
                    continue block10;
                }
                case Null: {
                    jSONArray.add(JSONNull.NULL);
                    continue block10;
                }
                case String: 
                case Integer: 
                case Double: {
                    jSONArray.add(this.getValue());
                    continue block10;
                }
            }
            break;
        }
        throw new JSONException(JSONErrorCode.UnexpectedEndOfJSON);
    }

    public JSONEvent next() throws JSONException {
        try {
            JSONLexer.Token token = null;
            block20: while ((token = this._lexer.nextToken()) != null) {
                if (this.getCurrentParseState() == ParseState.KeyedValue) {
                    this.keyStack.removeLast();
                    this.popParseState();
                    if (this.getCurrentParseState() == ParseState.Key) {
                        this.popParseState();
                    } else {
                        throw new JSONException(JSONErrorCode.ParseError);
                    }
                }
                JSONToken jSONToken = token.type;
                switch (jSONToken) {
                    case LBrace: {
                        this.valueWithKeyTest();
                        ++this.currentDepth;
                        this.pushParseState(ParseState.InObject);
                        return this.reportEvent(token, JSONEvent.StartObject);
                    }
                    case RBrace: {
                        --this.currentDepth;
                        this.validateParseState(ParseState.InObject);
                        this.popParseState();
                        this.popKeyStack();
                        return this.reportEvent(token, JSONEvent.EndObject);
                    }
                    case LBracket: {
                        this.valueWithKeyTest();
                        ++this.currentDepth;
                        this.pushParseState(ParseState.InArray);
                        return this.reportEvent(token, JSONEvent.StartArray);
                    }
                    case RBracket: {
                        --this.currentDepth;
                        this.validateParseState(ParseState.InArray);
                        this.popParseState();
                        this.popKeyStack();
                        return this.reportEvent(token, JSONEvent.EndArray);
                    }
                    case Comma: {
                        this.validateParseState(ParseState.InArray, ParseState.InObject);
                        continue block20;
                    }
                    case Colon: {
                        this.validateParseState(ParseState.Key);
                        continue block20;
                    }
                    case String: {
                        if (this.getCurrentParseState() == ParseState.InObject) {
                            this.pushParseState(ParseState.Key);
                            this.keyStack.addLast(JSONPullParser.unescapeString(token.str));
                            continue block20;
                        }
                        this.valueWithKeyTest();
                        return this.reportEvent(token, JSONEvent.String);
                    }
                    case Integer: {
                        this.valueWithKeyTest();
                        return this.reportEvent(token, JSONEvent.Integer);
                    }
                    case Double: {
                        this.valueWithKeyTest();
                        return this.reportEvent(token, JSONEvent.Double);
                    }
                    case True: {
                        this.valueWithKeyTest();
                        return this.reportEvent(token, JSONEvent.True);
                    }
                    case False: {
                        this.valueWithKeyTest();
                        return this.reportEvent(token, JSONEvent.False);
                    }
                    case Null: {
                        this.valueWithKeyTest();
                        return this.reportEvent(token, JSONEvent.Null);
                    }
                }
            }
        }
        catch (JSONException jSONException) {
            throw jSONException;
        }
        catch (XerialException xerialException) {
            XerialErrorCode xerialErrorCode = (XerialErrorCode)xerialException.getErrorCode();
            switch (xerialErrorCode) {
                case PARSE_ERROR: {
                    throw new JSONException(JSONErrorCode.ParseError, (Throwable)xerialException);
                }
            }
            throw new JSONException(JSONErrorCode.Inherited, (Throwable)xerialException);
        }
        return JSONEvent.EndJSON;
    }

    protected JSONEvent reportEvent(JSONLexer.Token token, JSONEvent jSONEvent) {
        this.lastReportedEvent = new JSONPullParserEvent(token, jSONEvent);
        return this.lastReportedEvent.getEvent();
    }

    public String getKeyName() throws JSONException {
        if (this.keyStack.isEmpty()) {
            return null;
        }
        return this.keyStack.getLast();
    }

    public String getText() {
        switch (this.lastReportedEvent.getEvent()) {
            case String: {
                return JSONPullParser.unescapeString(this.lastReportedEvent.getToken().str);
            }
            case True: {
                return "true";
            }
            case False: {
                return "false";
            }
            case Null: {
                return "null";
            }
        }
        return this.lastReportedEvent.getToken().str.toString();
    }

    private static String unescapeString(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        int n = 0;
        int n2 = charSequence.length();
        if (charSequence.charAt(n) == '\"') {
            ++n;
            --n2;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c == '\\' && n + 1 < n2) {
                char c2 = charSequence.charAt(n + 1);
                switch (c2) {
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'u': {
                        if (n + 4 >= n2) break;
                        CharSequence charSequence2 = charSequence.subSequence(n + 1, n + 5);
                        int n3 = Integer.parseInt(charSequence2.toString(), 16);
                        stringBuilder.append((char)n3);
                        n += 3;
                    }
                }
                ++n;
            } else {
                stringBuilder.append(c);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public int getDepth() {
        return this.currentDepth;
    }

    private static enum ParseState {
        Root,
        InObject,
        InArray,
        Key,
        KeyedValue;

    }
}

