/*
 * Decompiled with CFR 0.152.
 */
package io.github.soc.directories;

import io.github.soc.directories.UnsupportedOperatingSystemException;
import io.github.soc.directories.Util;

public final class BaseDirectories {
    static final String homeDir;
    static final String cacheDir;
    static final String configDir;
    static final String dataDir;
    static final String dataRoamingDir;
    static final String runtimeDir;
    static final String desktopDir;
    static final String documentsDir;
    static final String downloadDir;
    static final String musicDir;
    static final String picturesDir;
    static final String publicDir;
    static final String templatesDir;
    static final String videosDir;
    static final String executablesDir;
    static final String fontsDir;

    private BaseDirectories() {
        throw new Error();
    }

    static {
        switch (Util.operatingSystem) {
            case 'l': {
                homeDir = System.getenv("HOME");
                cacheDir = Util.defaultIfNullOrEmpty(System.getenv("XDG_CACHE_HOME"), homeDir, "/.cache/");
                configDir = Util.defaultIfNullOrEmpty(System.getenv("XDG_CONFIG_HOME"), homeDir, "/.config/");
                dataRoamingDir = dataDir = Util.defaultIfNullOrEmpty(System.getenv("XDG_DATA_HOME"), homeDir, "/.local/share/");
                runtimeDir = System.getenv("XDG_RUNTIME_DIR");
                desktopDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("DESKTOP"), homeDir, "/Desktop/");
                documentsDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("DOCUMENTS"), homeDir, "/Documents/");
                downloadDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("DOWNLOAD"), homeDir, "/Downloads/");
                musicDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("MUSIC"), homeDir, "/Music/");
                picturesDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("PICTURES"), homeDir, "/Pictures/");
                publicDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("PUBLICSHARE"), homeDir, "/Public/");
                templatesDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("TEMPLATES"), homeDir, "/Templates/");
                videosDir = Util.defaultIfNullOrEmpty(Util.runXDGUserDir("VIDEOS"), homeDir, "/Videos/");
                executablesDir = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), "/../bin/", homeDir, "/.local/bin/");
                fontsDir = Util.defaultIfNullOrEmptyExtended(System.getenv("XDG_DATA_HOME"), "/fonts/", homeDir, "/.local/share/fonts/");
                break;
            }
            case 'm': {
                homeDir = System.getenv("HOME");
                cacheDir = homeDir + "/Library/Caches/";
                configDir = homeDir + "/Library/Preferences/";
                dataRoamingDir = dataDir = homeDir + "/Library/Application Support/";
                runtimeDir = null;
                desktopDir = homeDir + "/Desktop/";
                documentsDir = homeDir + "/Documents/";
                downloadDir = homeDir + "/Downloads/";
                musicDir = homeDir + "/Music/";
                picturesDir = homeDir + "/Pictures/";
                publicDir = homeDir + "/Public/";
                templatesDir = null;
                videosDir = homeDir + "/Movies/";
                executablesDir = homeDir + "/Applications/";
                fontsDir = homeDir + "/Library/Fonts/";
                break;
            }
            case 'w': {
                homeDir = Util.runPowerShellCommand("UserProfile");
                dataDir = Util.runPowerShellCommand("LocalApplicationData");
                configDir = dataRoamingDir = Util.runPowerShellCommand("ApplicationData");
                cacheDir = dataDir + "/cache/";
                runtimeDir = null;
                desktopDir = Util.runPowerShellCommand("Desktop");
                documentsDir = Util.runPowerShellCommand("Documents");
                downloadDir = Util.runPowerShellCommand("Downloads");
                musicDir = Util.runPowerShellCommand("Music");
                picturesDir = Util.runPowerShellCommand("Pictures");
                publicDir = Util.runPowerShellCommand("Public");
                templatesDir = Util.runPowerShellCommand("Templates");
                videosDir = Util.runPowerShellCommand("Videos");
                executablesDir = null;
                fontsDir = null;
                break;
            }
            default: {
                throw new UnsupportedOperatingSystemException("Base directories are not supported on " + Util.operatingSystemName);
            }
        }
    }
}

