/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlgen;

import org.postgresql.pljava.annotation.Trigger;

class TriggerNamer {
    TriggerNamer() {
    }

    static String synthesizeName(Trigger t) {
        StringBuilder bld = new StringBuilder();
        bld.append("trg_");
        switch (t.called()) {
            case BEFORE: {
                bld.append('b');
                break;
            }
            case AFTER: {
                bld.append('a');
                break;
            }
            case INSTEAD_OF: {
                bld.append('i');
            }
        }
        bld.append(t.scope() == Trigger.Scope.ROW ? (char)'r' : 's');
        boolean atDelete = false;
        boolean atInsert = false;
        boolean atUpdate = false;
        boolean atTruncate = false;
        block10: for (Trigger.Event e : t.events()) {
            switch (e) {
                case DELETE: {
                    atDelete = true;
                    continue block10;
                }
                case INSERT: {
                    atInsert = true;
                    continue block10;
                }
                case TRUNCATE: {
                    atTruncate = true;
                    continue block10;
                }
                default: {
                    atUpdate = true;
                }
            }
        }
        bld.append('_');
        if (atDelete) {
            bld.append('d');
        }
        if (atInsert) {
            bld.append('i');
        }
        if (atUpdate) {
            bld.append('u');
        }
        if (atTruncate) {
            bld.append('t');
        }
        return bld.toString();
    }
}

