/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;

public class SQLOutputToTuple
implements SQLOutput {
    private final Object[] m_values;
    private final TupleDesc m_tupleDesc;
    private int m_index;
    private Tuple m_tuple;

    public SQLOutputToTuple(TupleDesc tupleDesc) {
        this.m_tupleDesc = tupleDesc;
        this.m_values = new Object[tupleDesc.size()];
        this.m_index = 0;
    }

    public long getTuple() throws SQLException {
        if (this.m_tuple != null) {
            return this.m_tuple.getNativePointer();
        }
        if (this.m_index < this.m_values.length) {
            throw new SQLException("Too few values have been written");
        }
        this.m_tuple = this.m_tupleDesc.formTuple(this.m_values);
        return this.m_tuple.getNativePointer();
    }

    @Override
    public void writeArray(Array value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeAsciiStream(InputStream value) throws SQLException {
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(value, "US-ASCII"));
            this.writeClob(new ClobValue(rdr, ClobValue.getReaderLength(rdr)));
        }
        catch (UnsupportedEncodingException e) {
            throw new SQLException(e.toString());
        }
    }

    @Override
    public void writeBigDecimal(BigDecimal value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeBinaryStream(InputStream value) throws SQLException {
        if (!value.markSupported()) {
            value = new BufferedInputStream(value);
        }
        this.writeBlob(new BlobValue(value, BlobValue.getStreamLength(value)));
    }

    @Override
    public void writeBlob(Blob value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeBoolean(boolean value) throws SQLException {
        this.writeValue(value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void writeByte(byte value) throws SQLException {
        this.writeValue(new Byte(value));
    }

    @Override
    public void writeBytes(byte[] value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeCharacterStream(Reader value) throws SQLException {
        if (!value.markSupported()) {
            value = new BufferedReader(value);
        }
        this.writeClob(new ClobValue(value, ClobValue.getReaderLength(value)));
    }

    @Override
    public void writeClob(Clob value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeDate(Date value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeDouble(double value) throws SQLException {
        this.writeValue(new Double(value));
    }

    @Override
    public void writeFloat(float value) throws SQLException {
        this.writeValue(new Float(value));
    }

    @Override
    public void writeInt(int value) throws SQLException {
        this.writeValue(new Integer(value));
    }

    @Override
    public void writeLong(long value) throws SQLException {
        this.writeValue(new Long(value));
    }

    @Override
    public void writeObject(SQLData value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeRef(Ref value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeShort(short value) throws SQLException {
        this.writeValue(new Short(value));
    }

    @Override
    public void writeString(String value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeStruct(Struct value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeTime(Time value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeTimestamp(Timestamp value) throws SQLException {
        this.writeValue(value);
    }

    @Override
    public void writeURL(URL value) throws SQLException {
        this.writeValue(value.toString());
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeNClob( NClob ) not implemented yet.", "0A000");
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeNString( String ) not implemented yet.", "0A000");
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeRowId( RowId ) not implemented yet.", "0A000");
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".writeSQLXML( SQLXML ) not implemented yet.", "0A000");
    }

    private void writeValue(Object value) throws SQLException {
        if (this.m_index >= this.m_values.length) {
            throw new SQLException("Tuple cannot take more values");
        }
        this.m_values[this.m_index++] = value;
    }
}

