/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.AbstractResultSetMetaData;

public class SPIResultSetMetaData
extends AbstractResultSetMetaData {
    private final TupleDesc m_tupleDesc;

    public SPIResultSetMetaData(TupleDesc tupleDesc) {
        this.m_tupleDesc = tupleDesc;
    }

    @Override
    public final int getColumnCount() throws SQLException {
        return this.m_tupleDesc.size();
    }

    @Override
    public final boolean isAutoIncrement(int column) throws SQLException {
        this.checkColumnIndex(column);
        return false;
    }

    @Override
    public final String getColumnLabel(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.m_tupleDesc.getColumnName(column).toUpperCase();
    }

    @Override
    public final String getColumnClassName(int column) throws SQLException {
        this.checkColumnIndex(column);
        return this.getOid(column).getJavaClass().getName();
    }

    @Override
    protected final void checkColumnIndex(int column) throws SQLException {
        if (column < 1 || column > this.m_tupleDesc.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
    }

    @Override
    protected final Oid getOid(int column) throws SQLException {
        return this.m_tupleDesc.getOid(column);
    }

    @Override
    protected final int getFieldLength(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<T> ) not implemented yet.", "0A000");
    }
}

