/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TransactionalMap
extends HashMap {
    private static final long serialVersionUID = 5337569423915578121L;
    private static final Object s_noObject = new Object();
    private Set m_entrySet;
    private Set m_keySet;
    private Collection m_valueColl;
    private final Map m_base;

    protected TransactionalMap(Map base) {
        this.m_base = base;
    }

    public void abort() {
        super.clear();
    }

    @Override
    public void clear() {
        super.clear();
        Iterator itor = this.m_base.keySet().iterator();
        while (itor.hasNext()) {
            super.put(itor.next(), s_noObject);
        }
    }

    public void commit() {
        for (Map.Entry e : super.entrySet()) {
            Object key = e.getKey();
            Object val = e.getValue();
            if (val == s_noObject) {
                this.m_base.remove(key);
                continue;
            }
            this.m_base.put(key, val);
        }
        super.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Object v = super.get(key);
        if (v != null) {
            return v != s_noObject;
        }
        return super.containsKey(key) || this.m_base.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        Object val = super.get(key);
        if (val == s_noObject) {
            val = null;
        } else if (val == null && !super.containsKey(key)) {
            val = this.m_base.get(key);
        }
        return val;
    }

    @Override
    public Object remove(Object key) {
        Object val = super.get(key);
        if (val == s_noObject) {
            return null;
        }
        Object bval = this.m_base.get(key);
        if (bval == null && !this.m_base.containsKey(key)) {
            if (val != null || super.containsKey(key)) {
                super.remove(key);
            }
            return val;
        }
        if (val == null && !super.containsKey(key)) {
            val = bval;
        }
        super.put(key, s_noObject);
        return val;
    }

    @Override
    public int size() {
        int sz = this.m_base.size();
        int psz = super.size();
        if (sz == 0) {
            return psz;
        }
        if (psz == 0) {
            return sz;
        }
        for (Map.Entry me : super.entrySet()) {
            Object val = me.getValue();
            if (val == s_noObject) {
                --sz;
                continue;
            }
            if (this.m_base.containsKey(me.getKey())) continue;
            ++sz;
        }
        return sz;
    }

    @Override
    public boolean containsValue(Object val) {
        Iterator itor = this.getValueIterator();
        while (itor.hasNext()) {
            Object v = itor.next();
            if (v != val && (v == null || !v.equals(val))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return TransactionalMap.this.getEntryIterator();
                }

                @Override
                public int size() {
                    return TransactionalMap.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return TransactionalMap.this.containsKey(k);
                }
            };
        }
        return this.m_entrySet;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set keySet() {
        if (this.m_keySet == null) {
            this.m_keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return TransactionalMap.this.getKeyIterator();
                }

                @Override
                public int size() {
                    return TransactionalMap.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return TransactionalMap.this.containsKey(k);
                }
            };
        }
        return this.m_keySet;
    }

    @Override
    public Object put(Object key, Object value) {
        Object old = this.get(key);
        super.put(key, value);
        return old;
    }

    @Override
    public void putAll(Map t) {
        super.putAll(t);
    }

    @Override
    public Collection values() {
        if (this.m_valueColl == null) {
            this.m_valueColl = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return TransactionalMap.this.getValueIterator();
                }

                @Override
                public int size() {
                    return TransactionalMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return TransactionalMap.this.containsValue(v);
                }
            };
        }
        return this.m_valueColl;
    }

    private Set superKeySet() {
        return super.keySet();
    }

    protected Iterator getEntryIterator() {
        return new EntryIterator();
    }

    protected Iterator getKeyIterator() {
        return new KeyIterator();
    }

    protected Iterator getValueIterator() {
        return new ValueIterator();
    }

    static /* synthetic */ Set access$000(TransactionalMap x0) {
        return x0.superKeySet();
    }

    protected class ValueIterator
    extends KeyIterator {
        protected ValueIterator() {
        }

        @Override
        public Object next() {
            return TransactionalMap.this.get(super.next());
        }
    }

    protected class EntryIterator
    extends KeyIterator {
        protected EntryIterator() {
        }

        @Override
        public Object next() {
            return new BackedEntry(super.next());
        }
    }

    protected class KeyIterator
    implements Iterator {
        private boolean m_phaseA = true;
        private Iterator m_currentItor = TransactionalMap.access$000(TransactionalMap.this).iterator();
        private Object m_currentKey = null;

        protected KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            this.m_currentKey = this.getValidKey(this.m_currentKey);
            return this.m_currentKey != null;
        }

        public Object next() {
            Object key = this.getValidKey(this.m_currentKey);
            if (key == null) {
                throw new NoSuchElementException();
            }
            this.m_currentKey = null;
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected Object getValidKey(Object key) {
            if (key != null && TransactionalMap.this.containsKey(key)) {
                return key;
            }
            while (true) {
                if (this.m_currentItor.hasNext()) {
                    key = this.m_currentItor.next();
                    if (!TransactionalMap.this.containsKey(key)) continue;
                    return key;
                }
                if (!this.m_phaseA) break;
                this.m_currentItor = TransactionalMap.this.m_base.keySet().iterator();
                this.m_phaseA = false;
            }
            return null;
        }
    }

    protected class BackedEntry
    implements Map.Entry {
        private Object m_key;

        public BackedEntry(Object key) {
            this.m_key = key;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return TransactionalMap.this.get(this.m_key);
        }

        public Object setValue(Object value) {
            return TransactionalMap.this.put(this.m_key, value);
        }
    }
}

