/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example.annotation;

import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import org.postgresql.pljava.annotation.BaseUDT;
import org.postgresql.pljava.annotation.Function;
import org.postgresql.pljava.annotation.SQLAction;
import org.postgresql.pljava.annotation.SQLType;

@SQLAction(requires={"IntWithMod type", "IntWithMod modApply"}, remove={"DROP CAST (javatest.IntWithMod AS javatest.IntWithMod)"}, install={"CREATE CAST (javatest.IntWithMod AS javatest.IntWithMod) WITH FUNCTION javatest.intwithmod_typmodapply( javatest.IntWithMod, integer, boolean)", "COMMENT ON CAST (javatest.IntWithMod AS javatest.IntWithMod) IS 'Cast that applies/verifies the type modifier on an IntWithMod.'"})
@BaseUDT(schema="javatest", provides={"IntWithMod type"}, requires={"IntWithMod modIn", "IntWithMod modOut"}, typeModifierInput="javatest.intwithmod_typmodin", typeModifierOutput="javatest.intwithmod_typmodout", like="pg_catalog.int4")
public class IntWithMod
implements SQLData {
    private int m_value;
    private String m_typeName;

    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static IntWithMod parse(String input, String typeName) throws SQLException {
        try {
            int v = Integer.parseInt(input);
            IntWithMod o = new IntWithMod();
            o.m_value = v;
            o.m_typeName = typeName;
            return o;
        }
        catch (NumberFormatException e) {
            throw new SQLDataException("invalid IntWithMod value", "22P02", e);
        }
    }

    @Override
    public String getSQLTypeName() {
        return this.m_typeName;
    }

    @Override
    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public void readSQL(SQLInput stream, String typeName) throws SQLException {
        this.m_value = stream.readInt();
        this.m_typeName = typeName;
    }

    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public String toString() {
        return String.valueOf(this.m_value);
    }

    @Override
    @Function(effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public void writeSQL(SQLOutput stream) throws SQLException {
        stream.writeInt(this.m_value);
    }

    @Function(schema="javatest", name="intwithmod_typmodin", provides={"IntWithMod modIn"}, effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static int modIn(@SQLType(value="cstring[]") String[] toks) throws SQLException {
        if (1 != toks.length) {
            throw new SQLDataException("only one type modifier allowed for IntWithMod", "22023");
        }
        if ("even".equalsIgnoreCase(toks[0])) {
            return 0;
        }
        if ("odd".equalsIgnoreCase(toks[0])) {
            return 1;
        }
        throw new SQLDataException("modifier for IntWithMod must be \"even\" or \"odd\"", "22023");
    }

    @Function(schema="javatest", name="intwithmod_typmodout", provides={"IntWithMod modOut"}, type="cstring", effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static String modOut(int mod) throws SQLException {
        switch (mod) {
            case 0: {
                return "(even)";
            }
            case 1: {
                return "(odd)";
            }
        }
        throw new SQLException("impossible IntWithMod typmod: " + mod);
    }

    @Function(schema="javatest", name="intwithmod_typmodapply", requires={"IntWithMod type"}, provides={"IntWithMod modApply"}, type="javatest.IntWithMod", effects=Function.Effects.IMMUTABLE, onNullInput=Function.OnNullInput.RETURNS_NULL)
    public static IntWithMod modApply(@SQLType(value="javatest.IntWithMod") IntWithMod iwm, int mod, boolean explicit) throws SQLException {
        if (-1 == mod) {
            return iwm;
        }
        if ((iwm.m_value & 1) != mod) {
            throw new SQLDataException("invalid value " + iwm + " for " + iwm.getSQLTypeName() + IntWithMod.modOut(mod), "22000");
        }
        iwm.m_typeName = iwm.m_typeName + IntWithMod.modOut(mod);
        return iwm;
    }
}

