/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.postgresql.pljava.ResultSetProvider;

public class TupleReturn
implements ResultSetProvider {
    private final int m_base;
    private final int m_increment;

    public static String makeString(ResultSet _testSetReturn) throws SQLException {
        int base = _testSetReturn.getInt(1);
        int incbase = _testSetReturn.getInt(2);
        Timestamp ctime = _testSetReturn.getTimestamp(3);
        return "Base = \"" + base + "\", incbase = \"" + incbase + "\", ctime = \"" + ctime + "\"";
    }

    public static ResultSetProvider setReturn(int base, int increment) throws SQLException {
        return new TupleReturn(base, increment);
    }

    public static boolean tupleReturn(int base, int increment, ResultSet receiver) throws SQLException {
        receiver.updateInt(1, base);
        receiver.updateInt(2, base + increment);
        receiver.updateTimestamp(3, new Timestamp(System.currentTimeMillis()));
        return true;
    }

    public static boolean tupleReturn(Integer base, Integer increment, ResultSet receiver) throws SQLException {
        if (base == null) {
            receiver.updateNull(1);
            receiver.updateNull(2);
        } else {
            receiver.updateInt(1, (int)base);
            if (increment == null) {
                receiver.updateNull(2);
            } else {
                receiver.updateInt(2, base + increment);
            }
        }
        receiver.updateTimestamp(3, new Timestamp(System.currentTimeMillis()));
        return true;
    }

    public TupleReturn(int base, int increment) {
        this.m_base = base;
        this.m_increment = increment;
    }

    public boolean assignRowValues(ResultSet receiver, int currentRow) throws SQLException {
        if (currentRow >= 12) {
            return false;
        }
        receiver.updateInt(1, this.m_base);
        receiver.updateInt(2, this.m_base + this.m_increment * currentRow);
        receiver.updateTimestamp(3, new Timestamp(System.currentTimeMillis()));
        return true;
    }

    public void close() {
    }
}

