/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.surefire.util.SpecificFileFilter;
import org.apache.maven.surefire.util.DefaultScanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner {
    private static final String FS = System.getProperty("file.separator");
    private static final String JAVA_SOURCE_FILE_EXTENSION = ".java";
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private final File basedir;
    private final List<String> includes;
    private final List<String> excludes;
    private final List<String> specificTests;

    public DirectoryScanner(File basedir, List<String> includes, List<String> excludes, List<String> specificTests) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
        this.specificTests = specificTests;
    }

    public DefaultScanResult scan() {
        String[] specific = this.specificTests == null ? new String[]{} : DirectoryScanner.processIncludesExcludes(this.specificTests);
        SpecificFileFilter specificTestFilter = new SpecificFileFilter(specific);
        ArrayList<String> result = new ArrayList<String>();
        if (this.basedir.exists()) {
            org.codehaus.plexus.util.DirectoryScanner scanner = new org.codehaus.plexus.util.DirectoryScanner();
            scanner.setBasedir(this.basedir);
            if (this.includes != null) {
                scanner.setIncludes(DirectoryScanner.processIncludesExcludes(this.includes));
            }
            if (this.excludes != null) {
                scanner.setExcludes(DirectoryScanner.processIncludesExcludes(this.excludes));
            }
            scanner.scan();
            for (String test : scanner.getIncludedFiles()) {
                if (!specificTestFilter.accept(this.stripBaseDir(this.basedir.getAbsolutePath(), test))) continue;
                result.add(this.convertToJavaClassName(test));
            }
        }
        return new DefaultScanResult(result);
    }

    private String convertToJavaClassName(String test) {
        return StringUtils.removeEnd((String)test, (String)JAVA_CLASS_FILE_EXTENSION).replace(FS, ".");
    }

    private String stripBaseDir(String basedir, String test) {
        return StringUtils.removeStart((String)test, (String)basedir);
    }

    private static String[] processIncludesExcludes(List<String> list) {
        ArrayList newList = new ArrayList();
        Iterator<String> i$ = list.iterator();
        while (i$.hasNext()) {
            String aList;
            String include = aList = i$.next();
            String[] includes = include.split(",");
            Collections.addAll(newList, includes);
        }
        String[] incs = new String[newList.size()];
        for (int i = 0; i < incs.length; ++i) {
            String inc = (String)newList.get(i);
            if (inc.endsWith(JAVA_SOURCE_FILE_EXTENSION)) {
                inc = StringUtils.removeEnd((String)inc, (String)JAVA_SOURCE_FILE_EXTENSION) + JAVA_CLASS_FILE_EXTENSION;
            }
            incs[i] = inc;
        }
        return incs;
    }
}

