/*
 * arch/arm/mach-ux500/ste_dma40_db8500.h
 * DB8500-SoC-specific configuration for DMA40
 *
 * Copyright (C) ST-Ericsson 2007-2010
 * License terms: GNU General Public License (GPL) version 2
 * Author: Per Friden <per.friden@stericsson.com>
 * Author: Jonas Aaberg <jonas.aberg@stericsson.com>
 */
#ifndef STE_DMA40_DB8500_H
#define STE_DMA40_DB8500_H

#define DB8500_DMA_NR_DEV 64

enum dma_src_dev_type {
	DB8500_DMA_DEV0_SPI0_RX = 0,
	DB8500_DMA_DEV1_SD_MMC0_RX = 1,
	DB8500_DMA_DEV2_SD_MMC1_RX = 2,
	DB8500_DMA_DEV3_SD_MMC2_RX = 3,
	DB8500_DMA_DEV4_I2C1_RX = 4,
	DB8500_DMA_DEV5_I2C3_RX = 5,
	DB8500_DMA_DEV6_I2C2_RX = 6,
	DB8500_DMA_DEV7_I2C4_RX = 7, /* Only on V1 and later */
	DB8500_DMA_DEV8_SSP0_RX = 8,
	DB8500_DMA_DEV9_SSP1_RX = 9,
	DB8500_DMA_DEV10_MCDE_RX = 10,
	DB8500_DMA_DEV11_UART2_RX = 11,
	DB8500_DMA_DEV12_UART1_RX = 12,
	DB8500_DMA_DEV13_UART0_RX = 13,
	DB8500_DMA_DEV14_MSP2_RX = 14,
	DB8500_DMA_DEV15_I2C0_RX = 15,
	DB8500_DMA_DEV16_USB_OTG_IEP_7_15 = 16,
	DB8500_DMA_DEV17_USB_OTG_IEP_6_14 = 17,
	DB8500_DMA_DEV18_USB_OTG_IEP_5_13 = 18,
	DB8500_DMA_DEV19_USB_OTG_IEP_4_12 = 19,
	DB8500_DMA_DEV20_SLIM0_CH0_RX_HSI_RX_CH0 = 20,
	DB8500_DMA_DEV21_SLIM0_CH1_RX_HSI_RX_CH1 = 21,
	DB8500_DMA_DEV22_SLIM0_CH2_RX_HSI_RX_CH2 = 22,
	DB8500_DMA_DEV23_SLIM0_CH3_RX_HSI_RX_CH3 = 23,
	DB8500_DMA_DEV24_SRC_SXA0_RX_TX = 24,
	DB8500_DMA_DEV25_SRC_SXA1_RX_TX = 25,
	DB8500_DMA_DEV26_SRC_SXA2_RX_TX = 26,
	DB8500_DMA_DEV27_SRC_SXA3_RX_TX = 27,
	DB8500_DMA_DEV28_SD_MM2_RX = 28,
	DB8500_DMA_DEV29_SD_MM0_RX = 29,
	DB8500_DMA_DEV30_MSP1_RX = 30,
	/* On DB8500v2, MSP3 RX replaces MSP1 RX */
	DB8500_DMA_DEV30_MSP3_RX = 30,
	DB8500_DMA_DEV31_MSP0_RX_SLIM0_CH0_RX = 31,
	DB8500_DMA_DEV32_SD_MM1_RX = 32,
	DB8500_DMA_DEV33_SPI2_RX = 33,
	DB8500_DMA_DEV34_I2C3_RX2 = 34,
	DB8500_DMA_DEV35_SPI1_RX = 35,
	DB8500_DMA_DEV36_USB_OTG_IEP_3_11 = 36,
	DB8500_DMA_DEV37_USB_OTG_IEP_2_10 = 37,
	DB8500_DMA_DEV38_USB_OTG_IEP_1_9 = 38,
	DB8500_DMA_DEV39_USB_OTG_IEP_8 = 39,
	DB8500_DMA_DEV40_SPI3_RX = 40,
	DB8500_DMA_DEV41_SD_MM3_RX = 41,
	DB8500_DMA_DEV42_SD_MM4_RX = 42,
	DB8500_DMA_DEV43_SD_MM5_RX = 43,
	DB8500_DMA_DEV44_SRC_SXA4_RX_TX = 44,
	DB8500_DMA_DEV45_SRC_SXA5_RX_TX = 45,
	DB8500_DMA_DEV46_SLIM0_CH8_RX_SRC_SXA6_RX_TX = 46,
	DB8500_DMA_DEV47_SLIM0_CH9_RX_SRC_SXA7_RX_TX = 47,
	DB8500_DMA_DEV48_CAC1_RX = 48,
	/* 49, 50 and 51 are not used */
	DB8500_DMA_DEV52_SLIM0_CH4_RX_HSI_RX_CH4 = 52,
	DB8500_DMA_DEV53_SLIM0_CH5_RX_HSI_RX_CH5 = 53,
	DB8500_DMA_DEV54_SLIM0_CH6_RX_HSI_RX_CH6 = 54,
	DB8500_DMA_DEV55_SLIM0_CH7_RX_HSI_RX_CH7 = 55,
	/* 56, 57, 58, 59 and 60 are not used */
	DB8500_DMA_DEV61_CAC0_RX = 61,
	/* 62 and 63 are not used */
};

enum dma_dest_dev_type {
	DB8500_DMA_DEV0_SPI0_TX = 0,
	DB8500_DMA_DEV1_SD_MMC0_TX = 1,
	DB8500_DMA_DEV2_SD_MMC1_TX = 2,
	DB8500_DMA_DEV3_SD_MMC2_TX = 3,
	DB8500_DMA_DEV4_I2C1_TX = 4,
	DB8500_DMA_DEV5_I2C3_TX = 5,
	DB8500_DMA_DEV6_I2C2_TX = 6,
	DB8500_DMA_DEV7_I2C4_TX = 7, /* Only on V1 and later */
	DB8500_DMA_DEV8_SSP0_TX = 8,
	DB8500_DMA_DEV9_SSP1_TX = 9,
	/* 10 is not used*/
	DB8500_DMA_DEV11_UART2_TX = 11,
	DB8500_DMA_DEV12_UART1_TX = 12,
	DB8500_DMA_DEV13_UART0_TX = 13,
	DB8500_DMA_DEV14_MSP2_TX = 14,
	DB8500_DMA_DEV15_I2C0_TX = 15,
	DB8500_DMA_DEV16_USB_OTG_OEP_7_15 = 16,
	DB8500_DMA_DEV17_USB_OTG_OEP_6_14 = 17,
	DB8500_DMA_DEV18_USB_OTG_OEP_5_13 = 18,
	DB8500_DMA_DEV19_USB_OTG_OEP_4_12 = 19,
	DB8500_DMA_DEV20_SLIM0_CH0_TX_HSI_TX_CH0 = 20,
	DB8500_DMA_DEV21_SLIM0_CH1_TX_HSI_TX_CH1 = 21,
	DB8500_DMA_DEV22_SLIM0_CH2_TX_HSI_TX_CH2 = 22,
	DB8500_DMA_DEV23_SLIM0_CH3_TX_HSI_TX_CH3 = 23,
	DB8500_DMA_DEV24_DST_SXA0_RX_TX = 24,
	DB8500_DMA_DEV25_DST_SXA1_RX_TX = 25,
	DB8500_DMA_DEV26_DST_SXA2_RX_TX = 26,
	DB8500_DMA_DEV27_DST_SXA3_RX_TX = 27,
	DB8500_DMA_DEV28_SD_MM2_TX = 28,
	DB8500_DMA_DEV29_SD_MM0_TX = 29,
	DB8500_DMA_DEV30_MSP1_TX = 30,
	DB8500_DMA_DEV31_MSP0_TX_SLIM0_CH0_TX = 31,
	DB8500_DMA_DEV32_SD_MM1_TX = 32,
	DB8500_DMA_DEV33_SPI2_TX = 33,
	DB8500_DMA_DEV34_I2C3_TX2 = 34,
	DB8500_DMA_DEV35_SPI1_TX = 35,
	DB8500_DMA_DEV36_USB_OTG_OEP_3_11 = 36,
	DB8500_DMA_DEV37_USB_OTG_OEP_2_10 = 37,
	DB8500_DMA_DEV38_USB_OTG_OEP_1_9 = 38,
	DB8500_DMA_DEV39_USB_OTG_OEP_8 = 39,
	DB8500_DMA_DEV40_SPI3_TX = 40,
	DB8500_DMA_DEV41_SD_MM3_TX = 41,
	DB8500_DMA_DEV42_SD_MM4_TX = 42,
	DB8500_DMA_DEV43_SD_MM5_TX = 43,
	DB8500_DMA_DEV44_DST_SXA4_RX_TX = 44,
	DB8500_DMA_DEV45_DST_SXA5_RX_TX = 45,
	DB8500_DMA_DEV46_SLIM0_CH8_TX_DST_SXA6_RX_TX = 46,
	DB8500_DMA_DEV47_SLIM0_CH9_TX_DST_SXA7_RX_TX = 47,
	DB8500_DMA_DEV48_CAC1_TX  = 48,
	DB8500_DMA_DEV49_CAC1_TX_HAC1_TX = 49,
	DB8500_DMA_DEV50_HAC1_TX = 50,
	DB8500_DMA_MEMCPY_TX_0 = 51,
	DB8500_DMA_DEV52_SLIM1_CH4_TX_HSI_TX_CH4 = 52,
	DB8500_DMA_DEV53_SLIM1_CH5_TX_HSI_TX_CH5 = 53,
	DB8500_DMA_DEV54_SLIM1_CH6_TX_HSI_TX_CH6 = 54,
	DB8500_DMA_DEV55_SLIM1_CH7_TX_HSI_TX_CH7 = 55,
	DB8500_DMA_MEMCPY_TX_1 = 56,
	DB8500_DMA_MEMCPY_TX_2 = 57,
	DB8500_DMA_MEMCPY_TX_3 = 58,
	DB8500_DMA_MEMCPY_TX_4 = 59,
	DB8500_DMA_MEMCPY_TX_5 = 60,
	DB8500_DMA_DEV61_CAC0_TX = 61,
	DB8500_DMA_DEV62_CAC0_TX_HAC0_TX = 62,
	DB8500_DMA_DEV63_HAC0_TX = 63,
};

#endif
